/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.jackson.extensions.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import org.jooq.exception.DataTypeException;
import org.jooq.impl.AbstractConverter;

abstract class AbstractToJacksonConverter<J, U>
extends AbstractConverter<J, U> {
    final ObjectMapper mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new JavaTimeModule())).addModule((Module)new KotlinModule.Builder().build())).build();

    public AbstractToJacksonConverter(Class<J> fromType, Class<U> toType) {
        super(fromType, toType);
    }

    abstract String data(J var1);

    abstract J json(String var1);

    public U from(J databaseObject) {
        if (databaseObject == null) {
            return null;
        }
        try {
            return (U)this.mapper.readValue(this.data(databaseObject), this.toType());
        }
        catch (JsonProcessingException e) {
            throw new DataTypeException("Error when converting JSON to " + this.toType(), (Throwable)e);
        }
    }

    public J to(U userObject) {
        if (userObject == null) {
            return null;
        }
        try {
            return this.json(this.mapper.writeValueAsString(userObject));
        }
        catch (JsonProcessingException e) {
            throw new DataTypeException("Error when converting object of type " + this.toType() + " to JSON", (Throwable)e);
        }
    }
}

