/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.util.maven;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.jooq.util.GenerationTool;
import org.jooq.util.maven.Generator;
import org.jooq.util.maven.Jdbc;
import org.jooq.util.maven.MasterDataTable;

public class Plugin
extends AbstractMojo {
    private MavenProject project;
    private Jdbc jdbc;
    private Generator generator;

    public void execute() throws MojoExecutionException {
        Properties props = new Properties();
        props.put("jdbc.Driver", this.jdbc.getDriver());
        props.put("jdbc.URL", this.jdbc.getUrl());
        props.put("jdbc.Schema", this.jdbc.getSchema());
        props.put("jdbc.User", this.jdbc.getUser());
        props.put("jdbc.Password", this.jdbc.getPassword());
        props.put("generator", this.generator.getName());
        props.put("generator.database", this.generator.getDatabase().getName());
        props.put("generator.database.includes", this.generator.getDatabase().getIncludes());
        props.put("generator.database.excludes", this.generator.getDatabase().getExcludes());
        props.put("generator.generate.relations", this.generator.getGenerate().getRelations());
        props.put("generator.generate.deprecated", this.generator.getGenerate().getDeprecated());
        props.put("generator.target.package", this.generator.getTarget().getPackageName());
        props.put("generator.target.directory", this.generator.getTarget().getDirectory());
        if (this.generator.getMasterDataTables() != null) {
            StringBuilder mdtList = new StringBuilder();
            for (MasterDataTable mdt : this.generator.getMasterDataTables()) {
                if (mdtList.length() > 0) {
                    mdtList.append(",");
                }
                mdtList.append(mdt.getName());
                props.put("generator.generate.master-data-table-literal." + mdt.getName(), mdt.getLiteral());
                props.put("generator.generate.master-data-table-description." + mdt.getName(), mdt.getDescription());
            }
            props.put("generator.generate.master-data-tables", mdtList.toString());
        }
        if (this.getLog().isDebugEnabled()) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            try {
                props.store(stream, "passing these properties to jooq-codegen:");
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
            this.getLog().debug((CharSequence)stream.toString());
        }
        try {
            GenerationTool.main((Properties)props);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        this.project.addCompileSourceRoot(this.generator.getTarget().getDirectory());
    }
}

