/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.checker;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePath;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.javacutil.TreeUtils;
import org.jooq.Allow;
import org.jooq.PlainSQL;
import org.jooq.Require;
import org.jooq.SQLDialect;
import org.jooq.Support;

final class Tools {
    Tools() {
    }

    static final <T> T checkSQLDialect(MethodInvocationTree node, Supplier<Element> enclosingSupplier, Function<? super String, ? extends T> error, Function<? super Printer, ? extends T> print) {
        try {
            ExecutableElement elementFromUse = TreeUtils.elementFromUse((MethodInvocationTree)node);
            Support support = elementFromUse.getAnnotation(Support.class);
            if (support != null) {
                EnumSet<SQLDialect> supported = EnumSet.copyOf(support.value().length > 0 ? Arrays.asList(support.value()) : Arrays.asList(SQLDialect.values()));
                EnumSet<SQLDialect> allowed = EnumSet.noneOf(SQLDialect.class);
                EnumSet<SQLDialect> required = EnumSet.noneOf(SQLDialect.class);
                Tools.defaults("org.jooq.checker.dialects.allow", allowed);
                Tools.defaults("org.jooq.checker.dialects.require", required);
                boolean evaluateRequire = true;
                for (Element enclosing = enclosingSupplier.get(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
                    Require require;
                    Allow allow = enclosing.getAnnotation(Allow.class);
                    if (allow != null) {
                        allowed.addAll(Arrays.asList(allow.value()));
                    }
                    if (!evaluateRequire || (require = enclosing.getAnnotation(Require.class)) == null) continue;
                    evaluateRequire = false;
                    required.clear();
                    required.addAll(Arrays.asList(require.value()));
                }
                if (allowed.isEmpty()) {
                    return error.apply("No jOOQ API usage is allowed at current scope. Use @Allow.");
                }
                boolean allowedFail = true;
                block3: for (SQLDialect a : allowed) {
                    for (SQLDialect s : supported) {
                        if (!a.supports(s)) continue;
                        allowedFail = false;
                        break block3;
                    }
                }
                if (allowedFail) {
                    return error.apply("The allowed dialects in scope " + String.valueOf(allowed) + " do not include any of the supported dialects: " + String.valueOf(supported));
                }
                boolean requiredFail = false;
                block5: for (SQLDialect r : required) {
                    for (SQLDialect s : supported) {
                        if (!r.supports(s)) continue;
                        continue block5;
                    }
                    requiredFail = true;
                    break;
                }
                if (requiredFail) {
                    return error.apply("Not all of the required dialects " + String.valueOf(required) + " from the current scope are supported " + String.valueOf(supported));
                }
            }
        }
        catch (Exception e) {
            return print.apply(new Printer(){

                @Override
                public void print(PrintWriter t) {
                    e.printStackTrace(t);
                }
            });
        }
        return null;
    }

    private static void defaults(String property, EnumSet<SQLDialect> set) {
        Stream.of(System.getProperty(property, "").split(",")).map(String::trim).filter(s -> !s.isEmpty()).map(s -> SQLDialect.valueOf((String)s.toUpperCase())).forEach(set::add);
    }

    static final <T> T checkPlainSQL(MethodInvocationTree node, Supplier<Element> enclosingSupplier, Function<? super String, ? extends T> error, Function<? super Printer, ? extends T> print) {
        try {
            ExecutableElement elementFromUse = TreeUtils.elementFromUse((MethodInvocationTree)node);
            PlainSQL plainSQL = elementFromUse.getAnnotation(PlainSQL.class);
            if (plainSQL != null) {
                boolean allowed = false;
                for (Element enclosing = enclosingSupplier.get(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
                    if (enclosing.getAnnotation(Allow.PlainSQL.class) == null) continue;
                    allowed = true;
                    break;
                }
                if (!allowed) {
                    return error.apply("Plain SQL usage not allowed at current scope. Use @Allow.PlainSQL.");
                }
            }
        }
        catch (Exception e) {
            return print.apply(new Printer(){

                @Override
                public void print(PrintWriter t) {
                    e.printStackTrace(t);
                }
            });
        }
        return null;
    }

    static Element enclosing(TreePath path) {
        MethodTree enclosingMethod = TreeUtils.enclosingMethod((TreePath)path);
        if (enclosingMethod != null) {
            return TreeUtils.elementFromDeclaration((MethodTree)enclosingMethod);
        }
        ClassTree enclosingClass = TreeUtils.enclosingClass((TreePath)path);
        return TreeUtils.elementFromDeclaration((ClassTree)enclosingClass);
    }

    static interface Printer {
        public void print(PrintWriter var1);
    }
}

