/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.checker;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.EnumSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.javacutil.TreeUtils;
import org.jooq.Allow;
import org.jooq.Require;
import org.jooq.SQLDialect;
import org.jooq.Support;
import org.jooq.checker.AbstractChecker;

public class SQLDialectChecker
extends AbstractChecker {
    protected SourceVisitor<Void, Void> createSourceVisitor() {
        return new SourceVisitor<Void, Void>(this.getChecker()){

            public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                try {
                    ExecutableElement elementFromUse = TreeUtils.elementFromUse((MethodInvocationTree)node);
                    Support support = elementFromUse.getAnnotation(Support.class);
                    if (support != null) {
                        EnumSet<SQLDialect> supported = EnumSet.copyOf(support.value().length > 0 ? Arrays.asList(support.value()) : Arrays.asList(SQLDialect.values()));
                        EnumSet<SQLDialect> allowed = EnumSet.noneOf(SQLDialect.class);
                        EnumSet<SQLDialect> required = EnumSet.noneOf(SQLDialect.class);
                        boolean evaluateRequire = true;
                        for (Element enclosing = AbstractChecker.enclosing(TreePath.getPath(this.root, (Tree)node)); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
                            Require require;
                            Allow allow = enclosing.getAnnotation(Allow.class);
                            if (allow != null) {
                                allowed.addAll(Arrays.asList(allow.value()));
                            }
                            if (!evaluateRequire || (require = enclosing.getAnnotation(Require.class)) == null) continue;
                            evaluateRequire = false;
                            required.clear();
                            required.addAll(Arrays.asList(require.value()));
                        }
                        if (allowed.isEmpty()) {
                            SQLDialectChecker.this.error(node, "No jOOQ API usage is allowed at current scope. Use @Allow.");
                        }
                        boolean allowedFail = true;
                        block3: for (SQLDialect a : allowed) {
                            for (SQLDialect s : supported) {
                                if (!a.supports(s)) continue;
                                allowedFail = false;
                                break block3;
                            }
                        }
                        if (allowedFail) {
                            SQLDialectChecker.this.error(node, "The allowed dialects in scope " + allowed + " do not include any of the supported dialects: " + supported);
                        }
                        boolean requiredFail = false;
                        block5: for (SQLDialect r : required) {
                            for (SQLDialect s : supported) {
                                if (!r.supports(s)) continue;
                                continue block5;
                            }
                            requiredFail = true;
                            break;
                        }
                        if (requiredFail) {
                            SQLDialectChecker.this.error(node, "Not all of the required dialects " + required + " from the current scope are supported " + supported);
                        }
                    }
                }
                catch (Exception e) {
                    AbstractChecker.print(new AbstractChecker.Printer(){

                        @Override
                        public void print(PrintWriter t) {
                            e.printStackTrace(t);
                        }
                    });
                }
                return (Void)super.visitMethodInvocation(node, (Object)p);
            }
        };
    }
}

