/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.checker;

import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.PrintWriter;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.framework.source.SourceVisitor;
import org.checkerframework.javacutil.TreeUtils;
import org.jooq.Allow;
import org.jooq.PlainSQL;
import org.jooq.checker.AbstractChecker;

public class PlainSQLChecker
extends AbstractChecker {
    protected SourceVisitor<Void, Void> createSourceVisitor() {
        return new SourceVisitor<Void, Void>(this.getChecker()){

            public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
                try {
                    ExecutableElement elementFromUse = TreeUtils.elementFromUse((MethodInvocationTree)node);
                    PlainSQL plainSQL = elementFromUse.getAnnotation(PlainSQL.class);
                    if (plainSQL != null) {
                        boolean allowed = false;
                        for (Element enclosing = TreeUtils.elementFromDeclaration((MethodTree)TreeUtils.enclosingMethod((TreePath)TreePath.getPath(this.root, (Tree)node))); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
                            if (enclosing.getAnnotation(Allow.PlainSQL.class) == null) continue;
                            allowed = true;
                            break;
                        }
                        if (!allowed) {
                            PlainSQLChecker.this.error(node, "Plain SQL usage not allowed at current scope. Use @Allow.PlainSQL.");
                        }
                    }
                }
                catch (Exception e) {
                    PlainSQLChecker.this.print(new AbstractChecker.Printer(){

                        @Override
                        public void print(PrintWriter t) {
                            e.printStackTrace(t);
                        }
                    });
                }
                return (Void)super.visitMethodInvocation(node, (Object)p);
            }
        };
    }
}

