/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.test.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public class EnvTestUtil {
    private EnvTestUtil() {
    }

    public static int getFreePort() throws IOException {
        for (int port = 22332; port < 22500; ++port) {
            if (!EnvTestUtil.trySocket(port)) continue;
            return port;
        }
        throw new IllegalStateException("Cannot find a single free port");
    }

    public static boolean trySocket(int port) throws IOException {
        boolean bl;
        InetAddress address = Inet4Address.getByName("localhost");
        ServerSocket s = new ServerSocket();
        try {
            s.bind(new InetSocketAddress(address, port));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    s.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exp) {
                System.err.println("Port " + port + " already in use, trying next ...");
                return false;
            }
        }
        s.close();
        return bl;
    }

    public static String readToString(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int read = -1;
        while ((read = is.read(buffer)) != -1) {
            os.write(buffer, 0, read);
            os.flush();
        }
        return os.toString();
    }
}

