/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.spring.actuator;

import jakarta.servlet.Servlet;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRegistration;
import java.util.Map;
import org.jolokia.server.core.http.AgentServlet;
import org.jolokia.server.core.service.api.Restrictor;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.ApplicationContext;

public class JolokiaServletRegistration
implements ServletContextInitializer {
    private final Map<String, String> initParameters;
    private final DispatcherServletPath dispatcherServletPath;
    private final WebEndpointProperties webEndpointProperties;
    private final ApplicationContext applicationContext;

    public JolokiaServletRegistration(Map<String, String> initParameters, WebEndpointProperties webEndpointProperties, DispatcherServletPath dispatcherServletPath, ApplicationContext applicationContext) {
        this.initParameters = initParameters;
        this.dispatcherServletPath = dispatcherServletPath;
        this.webEndpointProperties = webEndpointProperties;
        this.applicationContext = applicationContext;
    }

    public void onStartup(ServletContext servletContext) {
        String prefix = this.dispatcherServletPath.getPrefix();
        String endpointsBasePath = this.webEndpointProperties.getBasePath();
        String jolokiaPath = "jolokia";
        Map mapping = this.webEndpointProperties.getPathMapping();
        if (mapping.containsKey(jolokiaPath)) {
            jolokiaPath = (String)mapping.get(jolokiaPath);
        }
        Map restrictors = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, Restrictor.class);
        AgentServlet servlet = new AgentServlet();
        servlet.getInitRestrictors().putAll(restrictors);
        ServletRegistration.Dynamic reg = servletContext.addServlet("jolokia", (Servlet)servlet);
        reg.setInitParameters(this.initParameters);
        reg.addMapping(new String[]{prefix + endpointsBasePath + "/" + jolokiaPath + "/*"});
    }
}

