/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.support.jmx;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jolokia.server.core.service.serializer.Serializer;
import org.jolokia.support.jmx.JolokiaMBeanServerHolder;

public final class JolokiaMBeanServerUtil {
    private JolokiaMBeanServerUtil() {
    }

    public static MBeanServer getJolokiaMBeanServer() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        MBeanServer jolokiaMBeanServer = null;
        try {
            jolokiaMBeanServer = (MBeanServer)server.getAttribute(JolokiaMBeanServerHolder.MBEAN_SERVER_HOLDER_OBJECTNAME, "JolokiaMBeanServer");
        }
        catch (InstanceNotFoundException exp) {
            Serializer serializer = JolokiaMBeanServerUtil.lookupSerializer();
            if (serializer != null) {
                jolokiaMBeanServer = JolokiaMBeanServerHolder.registerJolokiaMBeanServerHolderMBean(server, serializer);
            }
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal: Cannot get JolokiaMBean server via JMX lookup: " + String.valueOf(e), e);
        }
        return jolokiaMBeanServer;
    }

    public static ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return JolokiaMBeanServerUtil.getJolokiaMBeanServer().registerMBean(object, name);
    }

    public static void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        JolokiaMBeanServerUtil.getJolokiaMBeanServer().unregisterMBean(name);
    }

    private static Serializer lookupSerializer() {
        try {
            Class<?> clazz = Class.forName("org.jolokia.service.serializer.JolokiaSerializer");
            return (Serializer)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }
}

