/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.jolokia.json.JSONArray;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.ObjectAccessor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.Converter;
import org.jolokia.service.serializer.object.ObjectToOpenTypeConverter;
import org.jolokia.service.serializer.object.TabularDataConverter;

public class TabularDataAccessor
implements ObjectAccessor {
    private final ObjectToOpenTypeConverter objectToOpenTypeConverter;

    public TabularDataAccessor(ObjectToOpenTypeConverter pObjectToOpenTypeConverter) {
        this.objectToOpenTypeConverter = pObjectToOpenTypeConverter;
    }

    @Override
    public Class<?> getType() {
        return TabularData.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pTabularData, Deque<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String pathPart;
        TabularData td = (TabularData)pTabularData;
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            try {
                pPathParts.push(pathPart);
                CompositeData cd = this.extractCompositeDataFromPath(pConverter, td, pPathParts);
                return pConverter.extractObject(cd != null && TabularDataConverter.isMXBeanMapWithSimpleKeys(td.getTabularType()) ? cd.get("value") : cd, pPathParts, pJsonify);
            }
            catch (AttributeNotFoundException exp) {
                ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
                return faultHandler.handleException((Throwable)exp);
            }
        }
        if (pJsonify) {
            return TabularDataConverter.isMXBeanMapWithSimpleKeys(td.getTabularType()) ? this.convertMXBeanTabularDataToJSON(pConverter, td, pPathParts) : this.convertGenericTabularDataToJSON(pConverter, td, pPathParts);
        }
        return td;
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public Object setObjectValue(Converter<String> pConverter, Object pObject, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("TabularData cannot be written to");
    }

    private Object convertMXBeanTabularDataToJSON(ObjectToJsonConverter pConverter, TabularData pTabularData, Deque<String> pPath) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (Object rowObject : pTabularData.values()) {
            CompositeData row = (CompositeData)rowObject;
            LinkedList<String> path = new LinkedList<String>(pPath);
            Object keyObject = row.get("key");
            if (keyObject == null) continue;
            try {
                String stringKey = (String)pConverter.getConverter().convert(String.class.getName(), keyObject);
                Object value = pConverter.extractObject(row.get("value"), path, true);
                ret.put((Object)stringKey, value);
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (!pTabularData.isEmpty() && ret.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object convertGenericTabularDataToJSON(ObjectToJsonConverter pConverter, TabularData pTabularData, Deque<String> pPath) throws AttributeNotFoundException {
        TabularType type = pTabularData.getTabularType();
        if (this.hasComplexKeys(type)) {
            return this.convertTabularDataWithComplexKeys(pConverter, pTabularData, pPath);
        }
        return this.convertTabularDataWithSimpleKeys(pConverter, pTabularData, pPath);
    }

    private boolean hasComplexKeys(TabularType pType) {
        List<String> indexes = pType.getIndexNames();
        CompositeType rowType = pType.getRowType();
        for (String index : indexes) {
            if (rowType.getType(index) instanceof SimpleType) continue;
            return true;
        }
        return false;
    }

    private Object convertTabularDataWithComplexKeys(ObjectToJsonConverter pConverter, TabularData pTabularData, Deque<String> pPath) throws AttributeNotFoundException {
        if (!pPath.isEmpty()) {
            throw new IllegalArgumentException("Cannot use a path for converting tabular data with complex keys (" + String.valueOf(pTabularData.getTabularType().getRowType()) + ")");
        }
        JSONObject ret = new JSONObject();
        TabularType type = pTabularData.getTabularType();
        JSONArray indexNames = new JSONArray(type.getIndexNames().size());
        indexNames.addAll(type.getIndexNames());
        ret.put((Object)"indexNames", (Object)indexNames);
        JSONArray values = new JSONArray(pTabularData.values().size());
        for (CompositeData row : pTabularData.values()) {
            values.add(pConverter.extractObject(row, pPath, true));
        }
        ret.put((Object)"values", (Object)values);
        return ret;
    }

    private Object convertTabularDataWithSimpleKeys(ObjectToJsonConverter pConverter, TabularData pTabularData, Deque<String> pPath) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        TabularType type = pTabularData.getTabularType();
        List<String> indexNames = type.getIndexNames();
        boolean found = false;
        for (CompositeData tableRow : pTabularData.values()) {
            LinkedList<String> path = new LinkedList<String>(pPath);
            try {
                JSONObject targetJSONObject = ret;
                for (int i = 0; i < indexNames.size() - 1; ++i) {
                    Object indexValue = pConverter.extractObject(tableRow.get(indexNames.get(i)), null, true);
                    String index = (String)pConverter.getConverter().convert(String.class.getName(), indexValue);
                    targetJSONObject = this.getNextMap(targetJSONObject, indexValue == null ? null : index);
                }
                Object row = pConverter.extractObject(tableRow, path, true);
                String finalIndex = indexNames.get(indexNames.size() - 1);
                Object finalIndexValue = pConverter.extractObject(tableRow.get(finalIndex), null, true);
                String index = (String)pConverter.getConverter().convert(String.class.getName(), finalIndexValue);
                targetJSONObject.put((Object)(finalIndexValue == null ? null : index), row);
                found = true;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (!pTabularData.isEmpty() && !found) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private JSONObject getNextMap(JSONObject pJsonObject, String pKey) {
        JSONObject ret = (JSONObject)pJsonObject.get((Object)pKey);
        if (ret == null) {
            ret = new JSONObject();
            pJsonObject.put((Object)pKey, (Object)ret);
        }
        return ret;
    }

    private CompositeData extractCompositeDataFromPath(ObjectToJsonConverter pConverter, TabularData pTd, Deque<String> pPath) throws AttributeNotFoundException {
        TabularType type = pTd.getTabularType();
        List<String> indexNames = type.getIndexNames();
        this.validatePathWithDeclaredIndex(pPath, indexNames);
        Object[] keys = new Object[indexNames.size()];
        CompositeType rowType = type.getRowType();
        ArrayList<String> pathPartsUsed = new ArrayList<String>();
        for (int i = 0; i < indexNames.size(); ++i) {
            String path = pPath.pop();
            pathPartsUsed.add(path);
            keys[i] = this.getKey(pConverter, rowType, indexNames.get(i), path);
        }
        if (pTd.containsKey(keys)) {
            return pTd.get(keys);
        }
        throw new AttributeNotFoundException("No entry for index " + String.valueOf(pathPartsUsed) + " found");
    }

    private void validatePathWithDeclaredIndex(Deque<String> pPathStack, List<String> pIndexNames) throws AttributeNotFoundException {
        if (pIndexNames.size() > pPathStack.size()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < pIndexNames.size(); ++i) {
                buf.append(pIndexNames.get(i));
                if (i >= pIndexNames.size() - 1) continue;
                buf.append(",");
            }
            throw new AttributeNotFoundException("No enough keys on path stack provided for accessing tabular data with index names " + String.valueOf(buf));
        }
    }

    private Object getKey(ObjectToJsonConverter pConverter, CompositeType rowType, String key, String value) {
        OpenType<?> keyType = rowType.getType(key);
        if (keyType instanceof SimpleType) {
            return this.objectToOpenTypeConverter.convert(keyType, (Object)value);
        }
        throw new IllegalArgumentException("All keys must be of SimpleType for accessing TabularData via a path. This is not the case for '" + key + "' which is of type " + String.valueOf(keyType));
    }
}

