/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.jolokia.server.core.service.serializer.ValueFaultHandler;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularDataExtractor
implements Extractor {
    @Override
    public Class getType() {
        return TabularData.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean pJsonify) throws AttributeNotFoundException {
        String tdPath;
        TabularData td = (TabularData)pValue;
        String string = tdPath = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (tdPath != null) {
            try {
                pPathParts.push(tdPath);
                CompositeData cd = this.extractCompositeDataFromPath(td, pPathParts);
                return pConverter.extractObject(cd != null && this.checkForMxBeanMap(td.getTabularType()) ? cd.get("value") : cd, pPathParts, pJsonify);
            }
            catch (AttributeNotFoundException exp) {
                ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
                return faultHandler.handleException((Throwable)exp);
            }
        }
        if (pJsonify) {
            return this.checkForMxBeanMap(td.getTabularType()) ? this.convertMxBeanMapToJson(td, pPathParts, pConverter) : this.convertTabularDataToJson(td, pPathParts, pConverter);
        }
        return td;
    }

    private boolean checkForMxBeanMap(TabularType pType) {
        CompositeType rowType = pType.getRowType();
        return rowType.containsKey("key") && rowType.containsKey("value") && rowType.keySet().size() == 2 && rowType.getType("key") instanceof SimpleType;
    }

    private Object convertTabularDataToJson(TabularData pTd, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter) throws AttributeNotFoundException {
        TabularType type = pTd.getTabularType();
        if (this.hasComplexKeys(type)) {
            return this.convertTabularDataDirectly(pTd, pExtraArgs, pConverter);
        }
        return this.convertToMaps(pTd, pExtraArgs, pConverter);
    }

    private boolean hasComplexKeys(TabularType pType) {
        List<String> indexes = pType.getIndexNames();
        CompositeType rowType = pType.getRowType();
        for (String index : indexes) {
            if (rowType.getType(index) instanceof SimpleType) continue;
            return true;
        }
        return false;
    }

    private Object convertToMaps(TabularData pTd, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        TabularType type = pTd.getTabularType();
        List<String> indexNames = type.getIndexNames();
        boolean found = false;
        for (CompositeData cd : pTd.values()) {
            Stack path = (Stack)pExtraArgs.clone();
            try {
                JSONObject targetJSONObject = ret;
                for (int i = 0; i < indexNames.size() - 1; ++i) {
                    Object indexValue = pConverter.extractObject(cd.get(indexNames.get(i)), null, true);
                    targetJSONObject = this.getNextMap(targetJSONObject, indexValue);
                }
                Object row = pConverter.extractObject(cd, path, true);
                String finalIndex = indexNames.get(indexNames.size() - 1);
                Object finalIndexValue = pConverter.extractObject(cd.get(finalIndex), null, true);
                targetJSONObject.put(finalIndexValue, row);
                found = true;
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (!pTd.isEmpty() && !found) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object convertTabularDataDirectly(TabularData pTd, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter) throws AttributeNotFoundException {
        if (!pExtraArgs.empty()) {
            throw new IllegalArgumentException("Cannot use a path for converting tabular data with complex keys (" + pTd.getTabularType().getRowType() + ")");
        }
        JSONObject ret = new JSONObject();
        JSONArray indexNames = new JSONArray();
        TabularType type = pTd.getTabularType();
        for (String index : type.getIndexNames()) {
            indexNames.add((Object)index);
        }
        ret.put((Object)"indexNames", (Object)indexNames);
        JSONArray values = new JSONArray();
        for (CompositeData cd : pTd.values()) {
            values.add(pConverter.extractObject(cd, pExtraArgs, true));
        }
        ret.put((Object)"values", (Object)values);
        return ret;
    }

    private JSONObject getNextMap(JSONObject pJsonObject, Object pKey) {
        JSONObject ret = (JSONObject)pJsonObject.get(pKey);
        if (ret == null) {
            ret = new JSONObject();
            pJsonObject.put(pKey, (Object)ret);
        }
        return ret;
    }

    private CompositeData extractCompositeDataFromPath(TabularData pTd, Stack<String> pPathStack) throws AttributeNotFoundException {
        TabularType type = pTd.getTabularType();
        List<String> indexNames = type.getIndexNames();
        this.checkPathFitsIndexNames(pPathStack, indexNames);
        Object[] keys = new Object[indexNames.size()];
        CompositeType rowType = type.getRowType();
        ArrayList<String> pathPartsUsed = new ArrayList<String>();
        for (int i = 0; i < indexNames.size(); ++i) {
            String path = pPathStack.pop();
            pathPartsUsed.add(path);
            keys[i] = this.getKey(rowType, indexNames.get(i), path);
        }
        if (pTd.containsKey(keys)) {
            return pTd.get(keys);
        }
        throw new AttributeNotFoundException("No entry with " + pathPartsUsed + " found");
    }

    private void checkPathFitsIndexNames(Stack<String> pPathStack, List<String> pIndexNames) throws AttributeNotFoundException {
        if (pIndexNames.size() > pPathStack.size()) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < pIndexNames.size(); ++i) {
                buf.append(pIndexNames.get(i));
                if (i >= pIndexNames.size() - 1) continue;
                buf.append(",");
            }
            throw new AttributeNotFoundException("No enough keys on path stack provided for accessing tabular data with index names " + buf.toString());
        }
    }

    private Object getKey(CompositeType rowType, String key, String value) {
        OpenType<?> keyType = rowType.getType(key);
        if (SimpleType.STRING == keyType) {
            return value;
        }
        if (SimpleType.INTEGER == keyType) {
            return Integer.parseInt(value);
        }
        if (SimpleType.LONG == keyType) {
            return Long.parseLong(value);
        }
        if (SimpleType.SHORT == keyType) {
            return Short.parseShort(value);
        }
        if (SimpleType.BYTE == keyType) {
            return Byte.parseByte(value);
        }
        if (SimpleType.OBJECTNAME == keyType) {
            try {
                return new ObjectName(value);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Can not convert " + value + " to an ObjectName", e);
            }
        }
        throw new IllegalArgumentException("All keys must be a string, integer, long, short, byte or ObjectName type for accessing TabularData via a path. This is not the case for '" + key + "' which is of type " + keyType);
    }

    private Object convertMxBeanMapToJson(TabularData pTd, Stack<String> pExtraArgs, ObjectToJsonConverter pConverter) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (Object rowObject : pTd.values()) {
            CompositeData row = (CompositeData)rowObject;
            Stack path = (Stack)pExtraArgs.clone();
            Object keyObject = row.get("key");
            if (keyObject == null) continue;
            try {
                Object value = pConverter.extractObject(row.get("value"), path, true);
                ret.put((Object)keyObject.toString(), value);
            }
            catch (ValueFaultHandler.AttributeFilteredException attributeFilteredException) {}
        }
        if (!pTd.isEmpty() && ret.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("TabularData cannot be written to");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

