/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.serializer.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.service.serializer.json.Extractor;
import org.jolokia.service.serializer.json.ObjectToJsonConverter;
import org.jolokia.service.serializer.object.StringToObjectConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumExtractor
implements Extractor {
    @Override
    public Class getType() {
        return Enum.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathPart, boolean jsonify) throws AttributeNotFoundException {
        String pathPart = pPathPart.isEmpty() ? null : pPathPart.pop();
        Enum en = (Enum)pValue;
        String name = en.name();
        if (pathPart != null) {
            if (name.equals(pathPart)) {
                return name;
            }
            return pConverter.getValueFaultHandler().handleException((Throwable)new AttributeNotFoundException("Enum value '" + name + "' doesn't match path '" + pathPart + "'"));
        }
        return jsonify ? name : en;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("An enum itself is immutable an cannot change its value");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

