/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.discovery;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jolokia.json.JSONObject;
import org.jolokia.json.parser.JSONParser;
import org.jolokia.json.parser.ParseException;
import org.jolokia.server.core.service.api.AgentDetails;
import org.jolokia.service.discovery.AbstractDiscoveryMessage;

public class DiscoveryIncomingMessage
extends AbstractDiscoveryMessage {
    private final InetAddress sourceAddress;
    private final int sourcePort;

    public DiscoveryIncomingMessage(DatagramPacket pPacket) throws IOException {
        this.sourceAddress = pPacket.getAddress();
        this.sourcePort = pPacket.getPort();
        JSONObject data = this.parseData(pPacket.getData(), pPacket.getLength());
        this.initType(data);
        Map<AgentDetails.AgentDetailProperty, Object> inData = this.extractDetails(data);
        if (this.isResponse()) {
            this.setAgentDetails(new AgentDetails(inData));
        }
    }

    private void initType(JSONObject pData) throws IOException {
        String typeS = (String)pData.remove((Object)"type");
        if (typeS == null) {
            throw new IOException("No message type given in discovery message " + pData.toJSONString());
        }
        try {
            AbstractDiscoveryMessage.MessageType type = AbstractDiscoveryMessage.MessageType.valueOf(typeS.toUpperCase());
            this.setType(type);
        }
        catch (IllegalArgumentException exp) {
            throw new IOException("Invalid type " + typeS + " given in discovery message", exp);
        }
    }

    public InetAddress getSourceAddress() {
        return this.sourceAddress;
    }

    public int getSourcePort() {
        return this.sourcePort;
    }

    @Override
    public String toString() {
        return "JolokiaDiscoveryIncomingMessage{source = " + String.valueOf(this.getSourceAddress()) + ":" + this.getSourcePort() + ": " + super.toString() + "}";
    }

    private Map<AgentDetails.AgentDetailProperty, Object> extractDetails(JSONObject pData) {
        HashMap<AgentDetails.AgentDetailProperty, Object> data = new HashMap<AgentDetails.AgentDetailProperty, Object>();
        for (Map.Entry entry : pData.entrySet()) {
            try {
                data.put(AgentDetails.AgentDetailProperty.fromKey((String)((String)entry.getKey())), entry.getValue());
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return data;
    }

    private JSONObject parseData(byte[] pData, int pLength) throws IOException {
        JSONParser parser = new JSONParser();
        ByteArrayInputStream is = new ByteArrayInputStream(pData, 0, pLength);
        try {
            return (JSONObject)parser.parse((Reader)new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
        }
        catch (ParseException e) {
            throw new IOException("Cannot parse discovery message as JSON", e);
        }
    }
}

