/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassUtil {
    private ClassUtil() {
    }

    public static Class classForName(String pClassName, boolean pInitialize) {
        HashSet<ClassLoader> tried = new HashSet<ClassLoader>();
        for (ClassLoader loader : new ClassLoader[]{Thread.currentThread().getContextClassLoader(), ClassUtil.class.getClassLoader()}) {
            do {
                try {
                    if (!tried.contains(loader)) {
                        return Class.forName(pClassName, pInitialize, loader);
                    }
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                tried.add(loader);
            } while ((loader = loader.getParent()) != null);
        }
        return null;
    }

    public static Class classForName(String pClassName) {
        return ClassUtil.classForName(pClassName, true);
    }

    public static boolean checkForClass(String pClassName) {
        return ClassUtil.classForName(pClassName, false) != null;
    }

    public static <T> T newInstance(String pClass) {
        try {
            Class clazz = ClassUtil.classForName(pClass);
            if (clazz != null) {
                return clazz.newInstance();
            }
            throw new IllegalArgumentException("Cannot find " + pClass);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot instantiate " + pClass + ": " + e, e);
        }
    }
}

