/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.detector;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.detector.AbstractServerDetector;
import org.jolokia.detector.ServerHandle;
import org.jolokia.request.JmxObjectNameRequest;
import org.jolokia.request.JmxRequest;
import org.jolokia.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossDetector
extends AbstractServerDetector {
    @Override
    public ServerHandle detect(MBeanServerExecutor pMBeanServerExecutor) {
        String version;
        if (ClassUtil.checkForClass("org.jboss.mx.util.MBeanServerLocator") && (version = this.getVersionFromJsr77(pMBeanServerExecutor)) != null) {
            int idx = version.indexOf(32);
            if (idx >= 0) {
                version = version.substring(0, idx);
            }
            return new JBossServerHandle(version, null, null, true);
        }
        if (this.mBeanExists(pMBeanServerExecutor, "jboss.system:type=Server")) {
            String versionFull = this.getAttributeValue(pMBeanServerExecutor, "jboss.system:type=Server", "Version");
            String version2 = null;
            if (versionFull != null) {
                version2 = versionFull.replaceAll("\\(.*", "").trim();
            }
            return new JBossServerHandle(version2, null, null, true);
        }
        version = this.getSingleStringAttribute(pMBeanServerExecutor, "jboss.as:management-root=server", "releaseVersion");
        if (version != null) {
            return new JBossServerHandle(version, null, null, false);
        }
        if (this.mBeanExists(pMBeanServerExecutor, "jboss.modules:*")) {
            return new JBossServerHandle("7", null, null, false);
        }
        return null;
    }

    @Override
    public void addMBeanServers(Set<MBeanServerConnection> servers) {
        try {
            Class<?> locatorClass = Class.forName("org.jboss.mx.util.MBeanServerLocator");
            Method method = locatorClass.getMethod("locateJBoss", new Class[0]);
            servers.add((MBeanServer)method.invoke(null, new Object[0]));
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossServerHandle
    extends ServerHandle {
        private boolean workaroundRequired = true;
        private static final MBeanServerExecutor.MBeanAction<Void> JBOSS_WORKAROUND_HANDLER = new MBeanServerExecutor.MBeanAction<Void>(){

            @Override
            public Void execute(MBeanServerConnection pConn, ObjectName pName, Object ... pExtraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException {
                try {
                    pConn.getMBeanInfo(pName);
                }
                catch (IntrospectionException e) {
                    // empty catch block
                }
                return null;
            }
        };

        JBossServerHandle(String version, URL agentUrl, Map<String, String> extraInfo, boolean pWorkaroundRequired) {
            super("RedHat", "jboss", version, agentUrl, extraInfo);
            this.workaroundRequired = pWorkaroundRequired;
        }

        @Override
        public void preDispatch(MBeanServerExecutor pMBeanServerExecutor, JmxRequest pJmxReq) {
            if (this.workaroundRequired && pJmxReq instanceof JmxObjectNameRequest) {
                this.workaroundForMXBeans(pMBeanServerExecutor, (JmxObjectNameRequest)pJmxReq);
            }
        }

        private void workaroundForMXBeans(MBeanServerExecutor pMBeanServerExecutor, JmxObjectNameRequest pRequest) {
            if (pRequest.getObjectName() != null && "java.lang".equals(pRequest.getObjectName().getDomain())) {
                try {
                    pMBeanServerExecutor.call(pRequest.getObjectName(), JBOSS_WORKAROUND_HANDLER, new Object[0]);
                }
                catch (ReflectionException e) {
                    throw new IllegalStateException("Workaround for JBoss failed for object " + pRequest.getObjectName() + ": " + e);
                }
                catch (JMException e) {
                    throw new IllegalStateException("Workaround for JBoss failed for object " + pRequest.getObjectName() + ": " + e);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

