/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ReflectionException;
import org.jolokia.backend.LocalRequestDispatcher;
import org.jolokia.backend.RequestDispatcher;
import org.jolokia.converter.Converters;
import org.jolokia.detector.ServerHandle;
import org.jolokia.history.HistoryStore;
import org.jolokia.request.JmxRequest;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.DebugStore;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendManager {
    private LocalRequestDispatcher localDispatcher;
    private Converters converters;
    private Restrictor restrictor;
    private HistoryStore historyStore;
    private DebugStore debugStore;
    private LogHandler logHandler;
    private List<RequestDispatcher> requestDispatchers;

    public BackendManager(Map<ConfigKey, String> pConfig, LogHandler pLogHandler) {
        this(pConfig, pLogHandler, null);
    }

    public BackendManager(Map<ConfigKey, String> pConfig, LogHandler pLogHandler, Restrictor pRestrictor) {
        this.converters = new Converters(pConfig);
        this.restrictor = pRestrictor != null ? pRestrictor : new AllowAllRestrictor();
        this.logHandler = pLogHandler;
        this.localDispatcher = new LocalRequestDispatcher(this.converters, this.restrictor, pConfig, this.logHandler);
        ServerHandle serverHandle = this.localDispatcher.getServerInfo();
        this.requestDispatchers = this.createRequestDispatchers(ConfigKey.DISPATCHER_CLASSES.getValue(pConfig), this.converters, serverHandle, this.restrictor);
        this.requestDispatchers.add(this.localDispatcher);
        this.initStores(pConfig);
    }

    private List<RequestDispatcher> createRequestDispatchers(String pClasses, Converters pConverters, ServerHandle pServerHandle, Restrictor pRestrictor) {
        ArrayList<RequestDispatcher> ret = new ArrayList<RequestDispatcher>();
        if (pClasses != null && pClasses.length() > 0) {
            String[] names;
            for (String name : names = pClasses.split("\\s*,\\s*")) {
                ret.add(this.createDispatcher(name, pConverters, pServerHandle, pRestrictor));
            }
        }
        return ret;
    }

    private RequestDispatcher createDispatcher(String pDispatcherClass, Converters pConverters, ServerHandle pServerHandle, Restrictor pRestrictor) {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(pDispatcherClass);
            Constructor<?> constructor = clazz.getConstructor(Converters.class, ServerHandle.class, Restrictor.class);
            return (RequestDispatcher)constructor.newInstance(pConverters, pServerHandle, pRestrictor);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Couldn't load class " + pDispatcherClass + ": " + e, e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + pDispatcherClass + " has invalid constructor: " + e, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Constructor of " + pDispatcherClass + " couldn't be accessed: " + e, e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(pDispatcherClass + " couldn't be instantiated: " + e, e);
        }
    }

    public JSONObject handleRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        boolean debug = this.isDebug();
        long time = 0L;
        if (debug) {
            time = System.currentTimeMillis();
        }
        JSONObject json = this.callRequestDispatcher(pJmxReq);
        this.historyStore.updateAndAdd(pJmxReq, json);
        json.put((Object)"status", (Object)200);
        if (debug) {
            this.debug("Execution time: " + (System.currentTimeMillis() - time) + " ms");
            this.debug("Response: " + json);
        }
        return json;
    }

    private JSONObject callRequestDispatcher(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        Object retValue = null;
        boolean useValueWithPath = false;
        boolean found = false;
        for (RequestDispatcher dispatcher : this.requestDispatchers) {
            if (!dispatcher.canHandle(pJmxReq)) continue;
            retValue = dispatcher.dispatchRequest(pJmxReq);
            useValueWithPath = dispatcher.useReturnValueWithPath(pJmxReq);
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalStateException("Internal error: No dispatcher found for handling " + pJmxReq);
        }
        return this.converters.getToJsonConverter().convertToJson(retValue, pJmxReq, useValueWithPath);
    }

    private void initStores(Map<ConfigKey, String> pConfig) {
        int maxEntries = this.getIntConfigValue(pConfig, ConfigKey.HISTORY_MAX_ENTRIES);
        int maxDebugEntries = this.getIntConfigValue(pConfig, ConfigKey.DEBUG_MAX_ENTRIES);
        String doDebug = ConfigKey.DEBUG.getValue(pConfig);
        boolean debug = false;
        if (doDebug != null && Boolean.valueOf(doDebug).booleanValue()) {
            debug = true;
        }
        this.historyStore = new HistoryStore(maxEntries);
        this.debugStore = new DebugStore(maxDebugEntries, debug);
        try {
            this.localDispatcher.initMBeans(this.historyStore, this.debugStore);
        }
        catch (NotCompliantMBeanException e) {
            this.intError("Error registering config MBean: " + e, e);
        }
        catch (MBeanRegistrationException e) {
            this.intError("Cannot register MBean: " + e, e);
        }
        catch (MalformedObjectNameException e) {
            this.intError("Invalid name for config MBean: " + e, e);
        }
    }

    private void intError(String message, Throwable t) {
        this.logHandler.error(message, t);
        this.debugStore.log(message, t);
    }

    private int getIntConfigValue(Map<ConfigKey, String> pConfig, ConfigKey pKey) {
        int ret;
        try {
            ret = Integer.parseInt(pKey.getValue(pConfig));
        }
        catch (NumberFormatException exp) {
            ret = Integer.parseInt(pKey.getDefaultValue());
        }
        return ret;
    }

    public void destroy() {
        try {
            this.localDispatcher.destroy();
        }
        catch (JMException e) {
            this.error("Cannot unregister MBean: " + e, e);
        }
    }

    public boolean isRemoteAccessAllowed(String pRemoteHost, String pRemoteAddr) {
        return this.restrictor.isRemoteAccessAllowed(pRemoteHost, pRemoteAddr);
    }

    public boolean isCorsAccessAllowed(String pOrigin) {
        return this.restrictor.isCorsAccessAllowed(pOrigin);
    }

    public void info(String msg) {
        this.logHandler.info(msg);
        if (this.debugStore != null) {
            this.debugStore.log(msg);
        }
    }

    public void debug(String msg) {
        this.logHandler.debug(msg);
        if (this.debugStore != null) {
            this.debugStore.log(msg);
        }
    }

    public void error(String message, Throwable t) {
        this.logHandler.error(message, t);
        if (this.debugStore != null) {
            this.debugStore.log(message, t);
        }
    }

    public boolean isDebug() {
        return this.debugStore != null && this.debugStore.isDebug();
    }
}

