/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxReadRequest;
import org.jolokia.request.ValueFaultHandler;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadHandler
extends JsonRequestHandler<JmxReadRequest> {
    public ReadHandler(Restrictor pRestrictor) {
        super(pRestrictor);
    }

    @Override
    public RequestType getType() {
        return RequestType.READ;
    }

    @Override
    public boolean handleAllServersAtOnce(JmxReadRequest pRequest) {
        return pRequest.getObjectName().isPattern() || pRequest.isMultiAttributeMode() || !pRequest.hasAttribute();
    }

    @Override
    public Object doHandleRequest(MBeanServerConnection pServer, JmxReadRequest pRequest) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        this.checkRestriction(pRequest.getObjectName(), pRequest.getAttributeName());
        return pServer.getAttribute(pRequest.getObjectName(), pRequest.getAttributeName());
    }

    @Override
    public Object doHandleRequest(Set<MBeanServerConnection> pServers, JmxReadRequest pRequest) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        ObjectName oName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        if (oName.isPattern()) {
            return this.fetchAttributesForMBeanPattern(pServers, pRequest);
        }
        return this.fetchAttributes(pServers, oName, pRequest.getAttributeNames(), faultHandler);
    }

    private Object fetchAttributesForMBeanPattern(Set<MBeanServerConnection> pServers, JmxReadRequest pRequest) throws IOException, InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        ObjectName objectName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        Set<ObjectName> names = this.searchMBeans(pServers, objectName);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        List<String> attributeNames = pRequest.getAttributeNames();
        for (ObjectName name : names) {
            if (!pRequest.hasAttribute()) {
                Map values = (Map)this.fetchAttributes(pServers, name, null, faultHandler);
                if (values == null || values.size() <= 0) continue;
                ret.put(name.getCanonicalName(), values);
                continue;
            }
            List<String> filteredAttributeNames = this.filterAttributeNames(pServers, name, attributeNames);
            if (filteredAttributeNames.size() == 0) continue;
            ret.put(name.getCanonicalName(), this.fetchAttributes(pServers, name, filteredAttributeNames, faultHandler));
        }
        if (ret.size() == 0) {
            throw new IllegalArgumentException("No matching attributes " + pRequest.getAttributeNames() + " found on MBeans " + names);
        }
        return ret;
    }

    private Set<ObjectName> searchMBeans(Set<MBeanServerConnection> pServers, ObjectName pObjectName) throws IOException, InstanceNotFoundException {
        HashSet<ObjectName> names = new HashSet<ObjectName>();
        for (MBeanServerConnection server : pServers) {
            Set<ObjectName> found = server.queryNames(pObjectName, null);
            if (found == null) continue;
            names.addAll(found);
        }
        if (names == null || names.size() == 0) {
            throw new InstanceNotFoundException("No MBean with pattern " + pObjectName + " found for reading attributes");
        }
        return names;
    }

    private List<String> filterAttributeNames(Set<MBeanServerConnection> pServers, ObjectName pName, List<String> pNames) throws InstanceNotFoundException, IOException, ReflectionException {
        HashSet<String> attrs = new HashSet<String>(this.getAllAttributesNames(pServers, pName));
        ArrayList<String> ret = new ArrayList<String>();
        for (String name : pNames) {
            if (!attrs.contains(name)) continue;
            ret.add(name);
        }
        return ret;
    }

    private Object fetchAttributes(Set<MBeanServerConnection> pServers, ObjectName pMBeanName, List<String> pAttributeNames, ValueFaultHandler pFaultHandler) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        List<String> attributes = pAttributeNames;
        if (this.shouldAllAttributesBeFetched(pAttributeNames)) {
            attributes = this.getAllAttributesNames(pServers, pMBeanName);
        }
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String attribute : attributes) {
            try {
                this.checkRestriction(pMBeanName, attribute);
                ret.put(attribute, this.getAttribute(pServers, pMBeanName, attribute));
            }
            catch (MBeanException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (AttributeNotFoundException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (InstanceNotFoundException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (ReflectionException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (IOException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (RuntimeException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
        }
        return ret;
    }

    private boolean shouldAllAttributesBeFetched(List<String> pAttributeNames) {
        if (pAttributeNames == null || pAttributeNames.size() == 0) {
            return true;
        }
        return pAttributeNames.size() == 1 && pAttributeNames.get(0) == null;
    }

    private MBeanInfo getMBeanInfo(Set<MBeanServerConnection> pServers, ObjectName pObjectName) throws IntrospectionException, InstanceNotFoundException, IOException, ReflectionException {
        for (MBeanServerConnection server : pServers) {
            try {
                return server.getMBeanInfo(pObjectName);
            }
            catch (InstanceNotFoundException exp) {
            }
        }
        throw new InstanceNotFoundException("No MBean with ObjectName " + pObjectName + " found in any MBeanServer");
    }

    private Object getAttribute(Set<MBeanServerConnection> pServers, ObjectName pMBeanName, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException, IOException, InstanceNotFoundException {
        for (MBeanServerConnection server : pServers) {
            try {
                return server.getAttribute(pMBeanName, attribute);
            }
            catch (InstanceNotFoundException exp) {
            }
        }
        throw new InstanceNotFoundException("No MBean with ObjectName " + pMBeanName + " found at any known MBeanServer");
    }

    private List<String> getAllAttributesNames(Set<MBeanServerConnection> pServers, ObjectName pObjectName) throws InstanceNotFoundException, IOException, ReflectionException {
        try {
            MBeanInfo mBeanInfo = this.getMBeanInfo(pServers, pObjectName);
            ArrayList<String> ret = new ArrayList<String>();
            for (MBeanAttributeInfo attrInfo : mBeanInfo.getAttributes()) {
                if (!attrInfo.isReadable()) continue;
                ret.add(attrInfo.getName());
            }
            return ret;
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Internal error while retrieving list: " + e, e);
        }
    }

    private void checkRestriction(ObjectName mBeanName, String attribute) {
        if (!this.getRestrictor().isAttributeReadAllowed(mBeanName, attribute)) {
            throw new SecurityException("Reading attribute " + attribute + " is forbidden for MBean " + mBeanName.getCanonicalName());
        }
    }

    @Override
    protected void checkForRestriction(JmxReadRequest pRequest) {
    }
}

