/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletException;
import org.jolokia.config.ConfigKey;
import org.jolokia.osgi.security.Authenticator;
import org.jolokia.osgi.security.BasicAuthenticationHttpContext;
import org.jolokia.osgi.security.BasicAuthenticator;
import org.jolokia.osgi.security.DefaultHttpContext;
import org.jolokia.osgi.security.DelegatingRestrictor;
import org.jolokia.osgi.security.JaasAuthenticator;
import org.jolokia.osgi.security.ServiceAuthenticationHttpContext;
import org.jolokia.osgi.servlet.JolokiaContext;
import org.jolokia.osgi.servlet.JolokiaServlet;
import org.jolokia.osgi.util.LogHelper;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.NetworkUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class JolokiaActivator
implements BundleActivator,
JolokiaContext {
    public static final String HTTP_SERVICE_FILTER_BASE = "(objectClass=" + HttpService.class.getName() + ")";
    private BundleContext bundleContext;
    private ServiceTracker httpServiceTracker;
    private ServiceTracker configAdminTracker;
    private static final String CONFIG_PREFIX = "org.jolokia";
    private static final String CONFIG_ADMIN_PID = "org.jolokia.osgi";
    private HttpContext jolokiaHttpContext;
    private ServiceRegistration jolokiaServiceRegistration;
    private Restrictor restrictor = null;

    public void start(BundleContext pBundleContext) {
        this.bundleContext = pBundleContext;
        this.configAdminTracker = new ServiceTracker(pBundleContext, "org.osgi.service.cm.ConfigurationAdmin", null);
        this.configAdminTracker.open();
        if (Boolean.parseBoolean(this.getConfiguration(ConfigKey.USE_RESTRICTOR_SERVICE))) {
            this.restrictor = new DelegatingRestrictor(this.bundleContext);
        }
        if (Boolean.parseBoolean(this.getConfiguration(ConfigKey.LISTEN_FOR_HTTP_SERVICE))) {
            this.httpServiceTracker = new ServiceTracker(pBundleContext, this.buildHttpServiceFilter(pBundleContext), (ServiceTrackerCustomizer)new HttpServiceCustomizer(pBundleContext));
            this.httpServiceTracker.open();
            this.jolokiaServiceRegistration = pBundleContext.registerService(JolokiaContext.class.getCanonicalName(), (Object)this, null);
        }
    }

    public void stop(BundleContext pBundleContext) {
        assert (pBundleContext.equals(this.bundleContext));
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if (this.jolokiaServiceRegistration != null) {
            this.jolokiaServiceRegistration.unregister();
            this.jolokiaServiceRegistration = null;
        }
        if (this.configAdminTracker != null) {
            this.configAdminTracker.close();
            this.configAdminTracker = null;
        }
        if (this.jolokiaHttpContext instanceof ServiceAuthenticationHttpContext) {
            ServiceAuthenticationHttpContext context = (ServiceAuthenticationHttpContext)this.jolokiaHttpContext;
            context.close();
        }
        this.restrictor = null;
        this.bundleContext = null;
    }

    @Override
    public synchronized HttpContext getHttpContext() {
        if (this.jolokiaHttpContext == null) {
            String user = this.getConfiguration(ConfigKey.USER);
            String authMode = this.getConfiguration(ConfigKey.AUTH_MODE);
            this.jolokiaHttpContext = user != null || "jaas".equalsIgnoreCase(authMode) ? new BasicAuthenticationHttpContext(this.getConfiguration(ConfigKey.REALM), this.createAuthenticator(authMode)) : (ServiceAuthenticationHttpContext.shouldBeUsed(authMode) ? new ServiceAuthenticationHttpContext(this.bundleContext, authMode) : new DefaultHttpContext());
        }
        return this.jolokiaHttpContext;
    }

    @Override
    public String getServletAlias() {
        return this.getConfiguration(ConfigKey.AGENT_CONTEXT);
    }

    private Dictionary<String, String> getConfiguration() {
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (ConfigKey key : ConfigKey.values()) {
            String value = this.getConfiguration(key);
            if (value == null) continue;
            ((Dictionary)config).put(key.getKeyValue(), value);
        }
        String jolokiaId = NetworkUtil.replaceExpression((String)((Dictionary)config).get(ConfigKey.AGENT_ID.getKeyValue()));
        if (jolokiaId == null) {
            ((Dictionary)config).put(ConfigKey.AGENT_ID.getKeyValue(), NetworkUtil.getAgentId(this.hashCode(), "osgi"));
        }
        ((Dictionary)config).put(ConfigKey.AGENT_TYPE.getKeyValue(), "osgi");
        return config;
    }

    private String getConfiguration(ConfigKey pKey) {
        String value = this.getConfigurationFromConfigAdmin(pKey);
        if (value == null) {
            value = this.bundleContext.getProperty("org.jolokia." + pKey.getKeyValue());
        }
        if (value == null) {
            value = pKey.getDefaultValue();
        }
        return value;
    }

    private String getConfigurationFromConfigAdmin(ConfigKey pkey) {
        ConfigurationAdmin configAdmin = (ConfigurationAdmin)this.configAdminTracker.getService();
        if (configAdmin == null) {
            return null;
        }
        try {
            Configuration config = configAdmin.getConfiguration(CONFIG_ADMIN_PID);
            if (config == null) {
                return null;
            }
            Dictionary props = config.getProperties();
            if (props == null) {
                return null;
            }
            return (String)props.get("org.jolokia." + pkey.getKeyValue());
        }
        catch (IOException e) {
            return null;
        }
    }

    private Filter buildHttpServiceFilter(BundleContext pBundleContext) {
        String customFilter = this.getConfiguration(ConfigKey.HTTP_SERVICE_FILTER);
        String filter = customFilter != null && customFilter.trim().length() > 0 ? "(&" + HTTP_SERVICE_FILTER_BASE + customFilter + ")" : HTTP_SERVICE_FILTER_BASE;
        try {
            return pBundleContext.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unable to parse filter " + filter, e);
        }
    }

    private Authenticator createAuthenticator(String authMode) {
        Authenticator authenticator = this.createCustomAuthenticator();
        if (authenticator != null) {
            return authenticator;
        }
        return this.createAuthenticatorFromAuthMode(authMode);
    }

    private Authenticator createCustomAuthenticator() {
        String authenticatorClass = this.getConfiguration(ConfigKey.AUTH_CLASS);
        if (authenticatorClass != null) {
            try {
                Class<?> authClass = Class.forName(authenticatorClass);
                if (!Authenticator.class.isAssignableFrom(authClass)) {
                    throw new IllegalArgumentException("Provided authenticator class [" + authenticatorClass + "] is not a subclass of Authenticator");
                }
                return this.lookupAuthenticator(authClass);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot find authenticator class", e);
            }
        }
        return null;
    }

    private Authenticator lookupAuthenticator(Class<?> pAuthClass) {
        Authenticator authenticator = null;
        try {
            try {
                Constructor<?> constructorThatTakesConfiguration = pAuthClass.getConstructor(Configuration.class);
                authenticator = (Authenticator)constructorThatTakesConfiguration.newInstance(this.getConfiguration());
            }
            catch (NoSuchMethodException ignore) {
                authenticator = this.lookupAuthenticatorWithDefaultConstructor(pAuthClass, ignore);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot create an instance of custom authenticator class with configuration", e);
            }
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class", e);
        }
        return authenticator;
    }

    private Authenticator lookupAuthenticatorWithDefaultConstructor(Class<?> pAuthClass, NoSuchMethodException ignore) throws InstantiationException, IllegalAccessException {
        try {
            Constructor<?> defaultConstructor = pAuthClass.getConstructor(new Class[0]);
            return (Authenticator)defaultConstructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator class, no default constructor to use", e);
        }
        catch (InvocationTargetException e) {
            e.initCause(ignore);
            throw new IllegalArgumentException("Cannot create an instance of custom authenticator using default constructor", e);
        }
    }

    private Authenticator createAuthenticatorFromAuthMode(String pAuthMode) {
        if ("basic".equalsIgnoreCase(pAuthMode)) {
            return new BasicAuthenticator(this.getConfiguration(ConfigKey.USER), this.getConfiguration(ConfigKey.PASSWORD));
        }
        if ("jaas".equalsIgnoreCase(pAuthMode)) {
            return new JaasAuthenticator(this.getConfiguration(ConfigKey.REALM));
        }
        throw new IllegalArgumentException("Unknown authentication method '" + pAuthMode + "' configured");
    }

    private class HttpServiceCustomizer
    implements ServiceTrackerCustomizer {
        private final BundleContext context;

        HttpServiceCustomizer(BundleContext pContext) {
            this.context = pContext;
        }

        public Object addingService(ServiceReference reference) {
            HttpService service = (HttpService)this.context.getService(reference);
            try {
                service.registerServlet(JolokiaActivator.this.getServletAlias(), new JolokiaServlet(this.context, JolokiaActivator.this.restrictor), JolokiaActivator.this.getConfiguration(), JolokiaActivator.this.getHttpContext());
            }
            catch (ServletException e) {
                LogHelper.logError(JolokiaActivator.this.bundleContext, "Servlet Exception: " + e, e);
            }
            catch (NamespaceException e) {
                LogHelper.logError(JolokiaActivator.this.bundleContext, "Namespace Exception: " + e, e);
            }
            return service;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            HttpService httpService = (HttpService)service;
            httpService.unregister(JolokiaActivator.this.getServletAlias());
        }
    }
}

