/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json.simplifier;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONObject;

public abstract class SimplifierExtractor<T>
implements Extractor {
    private final Map<String, AttributeExtractor<T>> extractorMap = new HashMap<String, AttributeExtractor<T>>();
    private Class<T> type;

    protected SimplifierExtractor(Class<T> pType) {
        this.type = pType;
        this.init(this.extractorMap);
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String path = pPathParts.isEmpty() ? null : pPathParts.pop();
        ValueFaultHandler faultHandler = pConverter.getValueFaultHandler();
        if (path != null) {
            return this.extractWithPath(pConverter, pValue, pPathParts, jsonify, path, faultHandler);
        }
        return jsonify ? this.extractAll(pConverter, pValue, pPathParts, jsonify) : pValue;
    }

    private Object extractAll(ObjectToJsonConverter pConverter, T pValue, Stack<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (Map.Entry<String, AttributeExtractor<T>> entry : this.extractorMap.entrySet()) {
            Stack paths = (Stack)pPathParts.clone();
            try {
                Object value = entry.getValue().extract(pValue);
                ret.put(entry.getKey(), pConverter.extractObject(value, paths, jsonify));
            }
            catch (AttributeExtractor.SkipAttributeException e) {
            }
            catch (ValueFaultHandler.AttributeFilteredException e) {}
        }
        if (ret.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    private Object extractWithPath(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify, String pPath, ValueFaultHandler pFaultHandler) throws AttributeNotFoundException {
        AttributeExtractor<Object> extractor = this.extractorMap.get(pPath);
        if (extractor == null) {
            return pFaultHandler.handleException(new AttributeNotFoundException("Illegal path element " + pPath + " for object " + pValue));
        }
        try {
            Object attributeValue = extractor.extract(pValue);
            return pConverter.extractObject(attributeValue, pPathParts, jsonify);
        }
        catch (AttributeExtractor.SkipAttributeException e) {
            return pFaultHandler.handleException(new AttributeNotFoundException("Illegal path element " + pPath + " for object " + pValue));
        }
    }

    @Override
    public boolean canSetValue() {
        return false;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("A simplify handler can't set a value");
    }

    protected final void addExtractors(Object[][] pAttrExtractors) {
        for (Object[] pAttrExtractor : pAttrExtractors) {
            this.extractorMap.put((String)pAttrExtractor[0], (AttributeExtractor)pAttrExtractor[1]);
        }
    }

    protected final void addExtractor(String pName, AttributeExtractor<T> pExtractor) {
        this.extractorMap.put(pName, pExtractor);
    }

    void init(Map<String, AttributeExtractor<T>> pExtractorMap) {
    }

    public static interface AttributeExtractor<T> {
        public Object extract(T var1) throws SkipAttributeException;

        public static class SkipAttributeException
        extends Exception {
        }
    }
}

