/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi.security;

import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import org.jolokia.osgi.security.AuthorizationHeaderParser;
import org.jolokia.osgi.security.BaseAuthenticator;
import org.jolokia.util.UserPasswordCallbackHandler;

public class JaasAuthenticator
extends BaseAuthenticator {
    private final String realm;

    public JaasAuthenticator(String pRealm) {
        this.realm = pRealm;
    }

    @Override
    protected boolean doAuthenticate(HttpServletRequest pRequest, AuthorizationHeaderParser.Result pAuthInfo) {
        try {
            String user = pAuthInfo.getUser();
            String password = pAuthInfo.getPassword();
            UserPasswordCallbackHandler handler = new UserPasswordCallbackHandler(user, password);
            LoginContext loginContext = new LoginContext(this.realm, handler);
            loginContext.login();
            pRequest.setAttribute("org.osgi.service.http.authentication.type", "BASIC");
            pRequest.setAttribute("org.osgi.service.http.authentication.remote.user", user);
            pRequest.setAttribute("org.jolokia.jaasSubject", loginContext.getSubject());
            return true;
        }
        catch (LoginException e) {
            return false;
        }
    }
}

