/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.ServletException;
import org.jolokia.config.ConfigKey;
import org.jolokia.osgi.security.Authenticator;
import org.jolokia.osgi.security.BasicAuthenticationHttpContext;
import org.jolokia.osgi.security.BasicAuthenticator;
import org.jolokia.osgi.security.DefaultHttpContext;
import org.jolokia.osgi.security.DelegatingRestrictor;
import org.jolokia.osgi.security.JaasAuthenticator;
import org.jolokia.osgi.servlet.JolokiaContext;
import org.jolokia.osgi.servlet.JolokiaServlet;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.NetworkUtil;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JolokiaActivator
implements BundleActivator,
JolokiaContext {
    public static final String HTTP_SERVICE_FILTER_BASE = "(objectClass=" + HttpService.class.getName() + ")";
    private BundleContext bundleContext;
    private ServiceTracker httpServiceTracker;
    private static final String CONFIG_PREFIX = "org.jolokia";
    private HttpContext jolokiaHttpContext;
    private ServiceRegistration jolokiaServiceRegistration;
    private Restrictor restrictor = null;

    public void start(BundleContext pBundleContext) {
        this.bundleContext = pBundleContext;
        if (Boolean.parseBoolean(this.getConfiguration(ConfigKey.USE_RESTRICTOR_SERVICE))) {
            this.restrictor = new DelegatingRestrictor(this.bundleContext);
        }
        if (Boolean.parseBoolean(this.getConfiguration(ConfigKey.LISTEN_FOR_HTTP_SERVICE))) {
            this.httpServiceTracker = new ServiceTracker(pBundleContext, this.buildHttpServiceFilter(pBundleContext), (ServiceTrackerCustomizer)new HttpServiceCustomizer(pBundleContext));
            this.httpServiceTracker.open();
            this.jolokiaServiceRegistration = pBundleContext.registerService(JolokiaContext.class.getCanonicalName(), (Object)this, null);
        }
    }

    public void stop(BundleContext pBundleContext) {
        assert (pBundleContext.equals(this.bundleContext));
        if (this.httpServiceTracker != null) {
            this.httpServiceTracker.close();
            this.httpServiceTracker = null;
        }
        if (this.jolokiaServiceRegistration != null) {
            this.jolokiaServiceRegistration.unregister();
            this.jolokiaServiceRegistration = null;
        }
        this.restrictor = null;
        this.bundleContext = null;
    }

    @Override
    public synchronized HttpContext getHttpContext() {
        if (this.jolokiaHttpContext == null) {
            String user = this.getConfiguration(ConfigKey.USER);
            this.jolokiaHttpContext = user == null ? new DefaultHttpContext() : new BasicAuthenticationHttpContext(this.getConfiguration(ConfigKey.REALM), this.createAuthenticator());
        }
        return this.jolokiaHttpContext;
    }

    @Override
    public String getServletAlias() {
        return this.getConfiguration(ConfigKey.AGENT_CONTEXT);
    }

    private Dictionary<String, String> getConfiguration() {
        Hashtable<String, String> config = new Hashtable<String, String>();
        for (ConfigKey key : ConfigKey.values()) {
            String value = this.getConfiguration(key);
            if (value == null) continue;
            ((Dictionary)config).put(key.getKeyValue(), value);
        }
        String jolokiaId = (String)((Dictionary)config).get(ConfigKey.AGENT_ID.getKeyValue());
        if (jolokiaId == null) {
            ((Dictionary)config).put(ConfigKey.AGENT_ID.getKeyValue(), NetworkUtil.getAgentId(this.hashCode(), "osgi"));
        }
        ((Dictionary)config).put(ConfigKey.AGENT_TYPE.getKeyValue(), "osgi");
        return config;
    }

    private String getConfiguration(ConfigKey pKey) {
        String value = this.bundleContext.getProperty("org.jolokia." + pKey.getKeyValue());
        if (value == null) {
            value = pKey.getDefaultValue();
        }
        return value;
    }

    private Filter buildHttpServiceFilter(BundleContext pBundleContext) {
        String customFilter = this.getConfiguration(ConfigKey.HTTP_SERVICE_FILTER);
        String filter = customFilter != null && customFilter.trim().length() > 0 ? "(&" + HTTP_SERVICE_FILTER_BASE + customFilter + ")" : HTTP_SERVICE_FILTER_BASE;
        try {
            return pBundleContext.createFilter(filter);
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Unable to parse filter " + filter, e);
        }
    }

    private Authenticator createAuthenticator() {
        Authenticator authenticator;
        String authMode = this.getConfiguration(ConfigKey.AUTH_MODE);
        if ("basic".equalsIgnoreCase(authMode)) {
            authenticator = new BasicAuthenticator(this.getConfiguration(ConfigKey.USER), this.getConfiguration(ConfigKey.PASSWORD));
        } else if ("jaas".equalsIgnoreCase(authMode)) {
            authenticator = new JaasAuthenticator(this.getConfiguration(ConfigKey.REALM));
        } else {
            throw new IllegalArgumentException("Unknown authentication method '" + authMode + "' configured");
        }
        return authenticator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logError(String message, Throwable throwable) {
        ServiceReference lRef = this.bundleContext.getServiceReference(LogService.class.getName());
        if (lRef != null) {
            try {
                LogService logService = (LogService)this.bundleContext.getService(lRef);
                if (logService != null) {
                    logService.log(1, message, throwable);
                    return;
                }
            }
            finally {
                this.bundleContext.ungetService(lRef);
            }
        }
        System.err.println("Jolokia-Error: " + message + " : " + throwable.getMessage());
    }

    private class HttpServiceCustomizer
    implements ServiceTrackerCustomizer {
        private final BundleContext context;

        HttpServiceCustomizer(BundleContext pContext) {
            this.context = pContext;
        }

        public Object addingService(ServiceReference reference) {
            HttpService service = (HttpService)this.context.getService(reference);
            try {
                service.registerServlet(JolokiaActivator.this.getServletAlias(), new JolokiaServlet(this.context, JolokiaActivator.this.restrictor), JolokiaActivator.this.getConfiguration(), JolokiaActivator.this.getHttpContext());
            }
            catch (ServletException e) {
                JolokiaActivator.this.logError("Servlet Exception: " + e, e);
            }
            catch (NamespaceException e) {
                JolokiaActivator.this.logError("Namespace Exception: " + e, e);
            }
            return service;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            HttpService httpService = (HttpService)service;
            httpService.unregister(JolokiaActivator.this.getServletAlias());
        }
    }
}

