/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.converter.json;

import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import org.jolokia.converter.json.Extractor;
import org.jolokia.converter.json.ObjectToJsonConverter;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.converter.object.StringToObjectConverter;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataExtractor
implements Extractor {
    @Override
    public Class getType() {
        return CompositeData.class;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pPathParts, boolean jsonify) throws AttributeNotFoundException {
        String pathPart;
        CompositeData cd = (CompositeData)pValue;
        String string = pathPart = pPathParts.isEmpty() ? null : pPathParts.pop();
        if (pathPart != null) {
            try {
                return pConverter.extractObject(cd.get(pathPart), pPathParts, jsonify);
            }
            catch (InvalidKeyException exp) {
                return pConverter.getValueFaultHandler().handleException(new AttributeNotFoundException("Invalid path '" + pathPart + "'"));
            }
        }
        return jsonify ? this.extractCompleteCdAsJson(pConverter, cd, pPathParts) : cd;
    }

    private Object extractCompleteCdAsJson(ObjectToJsonConverter pConverter, CompositeData pData, Stack<String> pPath) throws AttributeNotFoundException {
        JSONObject ret = new JSONObject();
        for (String key : pData.getCompositeType().keySet()) {
            Stack path = (Stack)pPath.clone();
            try {
                ret.put(key, pConverter.extractObject(pData.get(key), path, true));
            }
            catch (ValueFaultHandler.AttributeFilteredException exp) {}
        }
        if (ret.isEmpty()) {
            throw new ValueFaultHandler.AttributeFilteredException();
        }
        return ret;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, Object pValue) throws IllegalAccessException, InvocationTargetException {
        throw new IllegalArgumentException("CompositeData cannot be written to");
    }

    @Override
    public boolean canSetValue() {
        return false;
    }
}

