/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.io.AbstractBuffer;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.WriterOutputStream;
import org.mortbay.io.nio.DirectNIOBuffer;
import org.mortbay.io.nio.IndirectNIOBuffer;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.HttpContent;
import org.mortbay.jetty.HttpFields;
import org.mortbay.jetty.HttpHeaderValues;
import org.mortbay.jetty.HttpHeaders;
import org.mortbay.jetty.InclusiveByteRange;
import org.mortbay.jetty.MimeTypes;
import org.mortbay.jetty.ResourceCache;
import org.mortbay.jetty.Response;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.nio.NIOConnector;
import org.mortbay.jetty.servlet.PathMap;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.log.Log;
import org.mortbay.resource.FileResource;
import org.mortbay.resource.Resource;
import org.mortbay.resource.ResourceFactory;
import org.mortbay.util.IO;
import org.mortbay.util.MultiPartOutputStream;
import org.mortbay.util.TypeUtil;
import org.mortbay.util.URIUtil;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory {
    private ContextHandler.SContext _context;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _welcomeServlets = false;
    private boolean _redirectWelcome = false;
    private boolean _gzip = true;
    private Resource _resourceBase;
    private NIOResourceCache _nioCache;
    private ResourceCache _bioCache;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private boolean _aliases = false;
    private boolean _useFileMappedBuffer = false;
    ByteArrayBuffer _cacheControl;
    private ServletHandler _servletHandler;
    private ServletHolder _defaultHolder;

    public void init() throws UnavailableException {
        String t;
        ServletContext config = this.getServletContext();
        this._context = (ContextHandler.SContext)config;
        this._mimeTypes = this._context.getContextHandler().getMimeTypes();
        this._welcomes = this._context.getContextHandler().getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.jsp", "index.html"};
        }
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        this._redirectWelcome = this.getInitBoolean("redirectWelcome", this._redirectWelcome);
        this._gzip = this.getInitBoolean("gzip", this._gzip);
        this._aliases = this.getInitBoolean("aliases", this._aliases);
        if (!this._aliases && !FileResource.getCheckAliases()) {
            throw new IllegalStateException("Alias checking disabled");
        }
        if (this._aliases) {
            config.log("Aliases are enabled");
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        String rrb = this.getInitParameter("relativeResourceBase");
        if (rrb != null) {
            try {
                this._resourceBase = this._context.getContextHandler().getResource("/").addPath(rrb);
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
                throw new UnavailableException(e.toString());
            }
        }
        String rb = this.getInitParameter("resourceBase");
        if (rrb != null && rb != null) {
            throw new UnavailableException("resourceBase & relativeResourceBase");
        }
        if (rb != null) {
            try {
                this._resourceBase = Resource.newResource(rb);
            }
            catch (Exception e) {
                Log.warn("EXCEPTION ", e);
                throw new UnavailableException(e.toString());
            }
        }
        if ((t = this.getInitParameter("cacheControl")) != null) {
            this._cacheControl = new ByteArrayBuffer(t);
        }
        try {
            if (this._resourceBase == null) {
                this._resourceBase = this._context.getContextHandler().getResource("/");
            }
            String cache_type = this.getInitParameter("cacheType");
            int max_cache_size = this.getInitInt("maxCacheSize", -2);
            int max_cached_file_size = this.getInitInt("maxCachedFileSize", -2);
            int max_cached_files = this.getInitInt("maxCachedFiles", -2);
            if ((cache_type == null || "nio".equals(cache_type) || "both".equals(cache_type)) && (max_cache_size == -2 || max_cache_size > 0)) {
                this._nioCache = new NIOResourceCache(this._mimeTypes);
                if (max_cache_size > 0) {
                    this._nioCache.setMaxCacheSize(max_cache_size);
                }
                if (max_cached_file_size >= -1) {
                    this._nioCache.setMaxCachedFileSize(max_cached_file_size);
                }
                if (max_cached_files >= -1) {
                    this._nioCache.setMaxCachedFiles(max_cached_files);
                }
                this._nioCache.start();
            }
            if (("bio".equals(cache_type) || "both".equals(cache_type)) && (max_cache_size == -2 || max_cache_size > 0)) {
                this._bioCache = new ResourceCache(this._mimeTypes);
                if (max_cache_size > 0) {
                    this._bioCache.setMaxCacheSize(max_cache_size);
                }
                if (max_cached_file_size >= -1) {
                    this._bioCache.setMaxCachedFileSize(max_cached_file_size);
                }
                if (max_cached_files >= -1) {
                    this._bioCache.setMaxCachedFiles(max_cached_files);
                }
                this._bioCache.start();
            }
            if (this._nioCache == null) {
                this._bioCache = null;
            }
        }
        catch (Exception e) {
            Log.warn("EXCEPTION ", e);
            throw new UnavailableException(e.toString());
        }
        this._servletHandler = (ServletHandler)this._context.getContextHandler().getChildHandlerByClass(ServletHandler.class);
        ServletHolder[] holders = this._servletHandler.getServlets();
        int i = holders.length;
        while (i-- > 0) {
            if (holders[i].getServletInstance() != this) continue;
            this._defaultHolder = holders[i];
        }
        if (Log.isDebugEnabled()) {
            Log.debug("resource base = " + this._resourceBase);
        }
    }

    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter("org.mortbay.jetty.servlet.Default." + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = this.getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    public Resource getResource(String pathInContext) {
        if (this._resourceBase == null) {
            return null;
        }
        Resource r = null;
        try {
            r = this._resourceBase.addPath(pathInContext);
            if (!this._aliases && r.getAlias() != null) {
                if (r.exists()) {
                    Log.warn("Aliased resource: " + r + "==" + r.getAlias());
                }
                return null;
            }
            if (Log.isDebugEnabled()) {
                Log.debug("RESOURCE=" + r);
            }
        }
        catch (IOException e) {
            Log.ignore(e);
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String accept;
        String servletPath = null;
        String pathInfo = null;
        Enumeration reqRanges = null;
        Boolean included = (Boolean)request.getAttribute("org.mortbay.jetty.included");
        if (included != null && included.booleanValue()) {
            servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
            pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
            if (servletPath == null) {
                servletPath = request.getServletPath();
                pathInfo = request.getPathInfo();
            }
        } else {
            included = Boolean.FALSE;
            servletPath = request.getServletPath();
            pathInfo = request.getPathInfo();
            reqRanges = request.getHeaders("Range");
            if (reqRanges != null && !reqRanges.hasMoreElements()) {
                reqRanges = null;
            }
        }
        String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
        boolean endsWithSlash = pathInContext.endsWith("/");
        String pathInContextGz = null;
        boolean gzip = false;
        if (!included.booleanValue() && this._gzip && reqRanges == null && !endsWithSlash && (accept = request.getHeader("Accept-Encoding")) != null && accept.indexOf("gzip") >= 0) {
            gzip = true;
        }
        Resource resource = null;
        HttpContent content = null;
        Connector connector = HttpConnection.getCurrentConnection().getConnector();
        ResourceCache cache = connector instanceof NIOConnector ? this._nioCache : this._bioCache;
        try {
            block47: {
                try {
                    if (gzip) {
                        pathInContextGz = pathInContext + ".gz";
                        resource = this.getResource(pathInContextGz);
                        if (resource == null || !resource.exists() || resource.isDirectory()) {
                            gzip = false;
                            pathInContextGz = null;
                        } else if (cache != null && (content = cache.lookup(pathInContextGz, resource)) != null) {
                            resource = content.getResource();
                        }
                        if (resource == null || !resource.exists() || resource.isDirectory()) {
                            gzip = false;
                            pathInContextGz = null;
                        }
                    }
                    if (!gzip) {
                        resource = cache == null ? this.getResource(pathInContext) : ((content = cache.lookup(pathInContext, this)) != null ? content.getResource() : this.getResource(pathInContext));
                    }
                    if (Log.isDebugEnabled()) {
                        Log.debug("resource=" + resource + (content != null ? " content" : ""));
                    }
                    if (resource == null || !resource.exists()) {
                        response.sendError(404);
                        break block47;
                    }
                    if (!resource.isDirectory()) {
                        if (endsWithSlash && this._aliases && pathInContext.length() > 1) {
                            String q = request.getQueryString();
                            pathInContext = pathInContext.substring(0, pathInContext.length() - 1);
                            if (q != null && q.length() != 0) {
                                pathInContext = pathInContext + "?" + q;
                            }
                            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._context.getContextPath(), pathInContext)));
                        } else {
                            if (content == null) {
                                content = new UnCachedContent(resource);
                            }
                            if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                                if (gzip) {
                                    response.setHeader("Content-Encoding", "gzip");
                                    String mt = this._context.getMimeType(pathInContext);
                                    if (mt != null) {
                                        response.setContentType(mt);
                                    }
                                }
                                this.sendData(request, response, included, resource, content, reqRanges);
                            }
                        }
                        break block47;
                    }
                    String welcome = null;
                    if (!endsWithSlash || pathInContext.length() == 1 && request.getAttribute("org.mortbay.jetty.nullPathInfo") != null) {
                        StringBuffer buf = request.getRequestURL();
                        int param = buf.lastIndexOf(";");
                        if (param < 0) {
                            buf.append('/');
                        } else {
                            buf.insert(param, '/');
                        }
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            buf.append('?');
                            buf.append(q);
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
                        break block47;
                    }
                    welcome = this.getWelcomeFile(pathInContext);
                    if (null != welcome) {
                        if (this._redirectWelcome) {
                            response.setContentLength(0);
                            String q = request.getQueryString();
                            if (q != null && q.length() != 0) {
                                response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._context.getContextPath(), welcome) + "?" + q));
                            } else {
                                response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._context.getContextPath(), welcome)));
                            }
                        } else {
                            RequestDispatcher dispatcher = request.getRequestDispatcher(welcome);
                            if (dispatcher != null) {
                                if (included.booleanValue()) {
                                    dispatcher.include(request, response);
                                } else {
                                    request.setAttribute("org.mortbay.jetty.welcome", welcome);
                                    dispatcher.forward(request, response);
                                }
                            }
                        }
                        break block47;
                    }
                    content = new UnCachedContent(resource);
                    if (!included.booleanValue() && !this.passConditionalHeaders(request, response, resource, content)) break block47;
                    this.sendDirectory(request, response, resource, pathInContext.length() > 1);
                }
                catch (IllegalArgumentException e) {
                    Log.warn("EXCEPTION ", e);
                    if (!response.isCommitted()) {
                        response.sendError(500, e.getMessage());
                    }
                    Object var20_25 = null;
                    if (content != null) {
                        content.release();
                    } else if (resource != null) {
                        resource.release();
                    }
                }
            }
            Object var20_24 = null;
            if (content != null) {
                content.release();
            } else if (resource != null) {
                resource.release();
            }
        }
        catch (Throwable throwable) {
            Object var20_26 = null;
            if (content != null) {
                content.release();
            } else if (resource != null) {
                resource.release();
            }
            throw throwable;
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    private String getWelcomeFile(String pathInContext) throws MalformedURLException, IOException {
        if (this._welcomes == null) {
            return null;
        }
        String welcome_servlet = null;
        for (int i = 0; i < this._welcomes.length; ++i) {
            PathMap.Entry entry;
            String welcome_in_context = URIUtil.addPaths(pathInContext, this._welcomes[i]);
            Resource welcome = this.getResource(welcome_in_context);
            if (welcome != null && welcome.exists()) {
                return this._welcomes[i];
            }
            if (!this._welcomeServlets || welcome_servlet != null || (entry = this._servletHandler.getHolderEntry(welcome_in_context)) == null || entry.getValue() == this._defaultHolder) continue;
            welcome_servlet = welcome_in_context;
        }
        return welcome_servlet;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, HttpContent content) throws IOException {
        try {
            if (!request.getMethod().equals("HEAD")) {
                long date;
                String ifms = request.getHeader("If-Modified-Since");
                if (ifms != null) {
                    Buffer mdlm;
                    if (content != null && (mdlm = content.getLastModified()) != null && ifms.equals(mdlm.toString())) {
                        response.reset();
                        response.setStatus(304);
                        response.flushBuffer();
                        return false;
                    }
                    long ifmsl = request.getDateHeader("If-Modified-Since");
                    if (ifmsl != -1L && resource.lastModified() / 1000L <= ifmsl / 1000L) {
                        response.reset();
                        response.setStatus(304);
                        response.flushBuffer();
                        return false;
                    }
                }
                if ((date = request.getDateHeader("If-Unmodified-Since")) != -1L && resource.lastModified() / 1000L > date / 1000L) {
                    response.sendError(412);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            if (!response.isCommitted()) {
                response.sendError(400, iae.getMessage());
            }
            throw iae;
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, boolean parent) throws IOException {
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths(request.getRequestURI(), "/");
        String dir = resource.getListHTML(base, parent);
        if (dir == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, HttpContent content, Enumeration reqRanges) throws IOException {
        long content_length = content == null ? resource.length() : content.getContentLength();
        OutputStream out = null;
        try {
            out = response.getOutputStream();
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
        }
        if (reqRanges == null || !reqRanges.hasMoreElements() || content_length < 0L) {
            if (include) {
                resource.writeTo(out, 0L, content_length);
            } else if (out instanceof HttpConnection.Output) {
                if (response instanceof Response) {
                    this.writeOptionHeaders(((Response)response).getHttpFields());
                    ((HttpConnection.Output)out).sendContent(content);
                } else if (content.getBuffer() != null) {
                    this.writeHeaders(response, content, content_length);
                    ((HttpConnection.Output)out).sendContent(content.getBuffer());
                } else {
                    this.writeHeaders(response, content, content_length);
                    resource.writeTo(out, 0L, content_length);
                }
            } else {
                this.writeHeaders(response, content, content_length);
                resource.writeTo(out, 0L, content_length);
            }
        } else {
            InclusiveByteRange ibr;
            int i;
            List ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length);
            if (ranges == null || ranges.size() == 0) {
                this.writeHeaders(response, content, content_length);
                response.setStatus(416);
                response.setHeader("Content-Range", InclusiveByteRange.to416HeaderRangeString(content_length));
                resource.writeTo(out, 0L, content_length);
                return;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = (InclusiveByteRange)ranges.get(0);
                long singleLength = singleSatisfiableRange.getSize(content_length);
                this.writeHeaders(response, content, singleLength);
                response.setStatus(206);
                response.setHeader("Content-Range", singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo(out, singleSatisfiableRange.getFirst(content_length), singleLength);
                return;
            }
            this.writeHeaders(response, content, -1L);
            String mimetype = content.getContentType().toString();
            MultiPartOutputStream multi = new MultiPartOutputStream(out);
            response.setStatus(206);
            String ctp = request.getHeader("Request-Range") != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            int length = 0;
            String[] header = new String[ranges.size()];
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                header[i] = ibr.toHeaderRangeString(content_length);
                length = (int)((long)length + ((long)((i > 0 ? 2 : 0) + 2 + multi.getBoundary().length() + 2 + "Content-Type".length() + 2 + mimetype.length() + 2 + "Content-Range".length() + 2 + header[i].length() + 2 + 2) + (ibr.getLast(content_length) - ibr.getFirst(content_length)) + 1L));
            }
            response.setContentLength(length += 4 + multi.getBoundary().length() + 2 + 2);
            for (i = 0; i < ranges.size(); ++i) {
                ibr = (InclusiveByteRange)ranges.get(i);
                multi.startPart(mimetype, new String[]{"Content-Range: " + header[i]});
                long start = ibr.getFirst(content_length);
                long size = ibr.getSize(content_length);
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    IO.copy(in, multi, size);
                    pos += size;
                    continue;
                }
                resource.writeTo(multi, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
    }

    protected void writeHeaders(HttpServletResponse response, HttpContent content, long count) throws IOException {
        if (content.getContentType() != null && response.getContentType() == null) {
            response.setContentType(content.getContentType().toString());
        }
        if (response instanceof Response) {
            long lml;
            Response r = (Response)response;
            HttpFields fields = r.getHttpFields();
            if (content.getLastModified() != null) {
                fields.put(HttpHeaders.LAST_MODIFIED_BUFFER, content.getLastModified(), content.getResource().lastModified());
            } else if (content.getResource() != null && (lml = content.getResource().lastModified()) != -1L) {
                fields.putDateField(HttpHeaders.LAST_MODIFIED_BUFFER, lml);
            }
            if (count != -1L) {
                r.setLongContentLength(count);
            }
            this.writeOptionHeaders(fields);
        } else {
            long lml = content.getResource().lastModified();
            if (lml >= 0L) {
                response.setDateHeader("Last-Modified", lml);
            }
            if (count != -1L) {
                if (count < Integer.MAX_VALUE) {
                    response.setContentLength((int)count);
                } else {
                    response.setHeader("Content-Length", TypeUtil.toString(count));
                }
            }
            this.writeOptionHeaders(response);
        }
    }

    protected void writeOptionHeaders(HttpFields fields) throws IOException {
        if (this._acceptRanges) {
            fields.put(HttpHeaders.ACCEPT_RANGES_BUFFER, HttpHeaderValues.BYTES_BUFFER);
        }
        if (this._cacheControl != null) {
            fields.put(HttpHeaders.CACHE_CONTROL_BUFFER, this._cacheControl);
        }
    }

    protected void writeOptionHeaders(HttpServletResponse response) throws IOException {
        if (this._acceptRanges) {
            response.setHeader("Accept-Ranges", "bytes");
        }
        if (this._cacheControl != null) {
            response.setHeader("Cache-Control", this._cacheControl.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void destroy() {
        block14: {
            block12: {
                if (this._nioCache == null) break block12;
                this._nioCache.stop();
            }
            Object var3_1 = null;
            try {
                block13: {
                    if (this._bioCache == null) break block13;
                    this._bioCache.stop();
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                super.destroy();
                throw throwable;
            }
            super.destroy();
            {
                break block14;
                catch (Exception e2) {
                    Log.warn("EXCEPTION ", e2);
                    Object var6_5 = null;
                    super.destroy();
                    break block14;
                }
            }
            {
                catch (Exception e) {
                    Log.warn("EXCEPTION ", e);
                    Object var3_2 = null;
                    try {
                        block15: {
                            if (this._bioCache == null) break block15;
                            this._bioCache.stop();
                        }
                        Object var6_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        super.destroy();
                        throw throwable;
                    }
                    super.destroy();
                    {
                        break block14;
                        catch (Exception e2) {
                            Log.warn("EXCEPTION ", e2);
                            Object var6_8 = null;
                            super.destroy();
                            break block14;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block17: {
                    Object var3_3 = null;
                    try {
                        block16: {
                            if (this._bioCache == null) break block16;
                            this._bioCache.stop();
                        }
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable2) {
                        Object var6_12 = null;
                        super.destroy();
                        throw throwable2;
                    }
                    super.destroy();
                    {
                        break block17;
                        catch (Exception e2) {
                            Log.warn("EXCEPTION ", e2);
                            Object var6_11 = null;
                            super.destroy();
                        }
                    }
                }
                throw throwable;
            }
        }
    }

    class NIOResourceCache
    extends ResourceCache {
        public NIOResourceCache(MimeTypes mimeTypes) {
            super(mimeTypes);
        }

        protected void fill(ResourceCache.Content content) throws IOException {
            AbstractBuffer buffer = null;
            Resource resource = content.getResource();
            long length = resource.length();
            if (DefaultServlet.this._useFileMappedBuffer && resource.getFile() != null) {
                buffer = new DirectNIOBuffer(resource.getFile());
            } else {
                InputStream is = resource.getInputStream();
                try {
                    Connector connector = HttpConnection.getCurrentConnection().getConnector();
                    buffer = ((NIOConnector)((Object)connector)).getUseDirectBuffers() ? new DirectNIOBuffer((int)length) : new IndirectNIOBuffer((int)length);
                }
                catch (OutOfMemoryError e) {
                    Log.warn(e.toString());
                    Log.debug(e);
                    buffer = new IndirectNIOBuffer((int)length);
                }
                buffer.readFrom(is, (int)length);
                is.close();
            }
            content.setBuffer(buffer);
        }
    }

    private class UnCachedContent
    implements HttpContent {
        Resource _resource;

        UnCachedContent(Resource resource) {
            this._resource = resource;
        }

        public Buffer getContentType() {
            return DefaultServlet.this._mimeTypes.getMimeByExtension(this._resource.toString());
        }

        public Buffer getLastModified() {
            return null;
        }

        public Buffer getBuffer() {
            return null;
        }

        public long getContentLength() {
            return this._resource.length();
        }

        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        public Resource getResource() {
            return this._resource;
        }

        public void release() {
            this._resource.release();
            this._resource = null;
        }
    }
}

