/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.request.JmxReadRequest;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.RequestType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadHandler
extends JsonRequestHandler<JmxReadRequest> {
    private static final MBeanServerExecutor.MBeanAction<MBeanInfo> MBEAN_INFO_HANDLER = new MBeanServerExecutor.MBeanAction<MBeanInfo>(){

        @Override
        public MBeanInfo execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException {
            try {
                return pConn.getMBeanInfo(pName);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Cannot inspect " + pName + ": " + e, e);
            }
        }
    };
    private static final MBeanServerExecutor.MBeanAction<Object> MBEAN_ATTRIBUTE_READ_HANDLER = new MBeanServerExecutor.MBeanAction<Object>(){

        @Override
        public Object execute(MBeanServerConnection pConn, ObjectName pName, Object ... extraArgs) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException, AttributeNotFoundException {
            String attribute = (String)extraArgs[0];
            return pConn.getAttribute(pName, attribute);
        }
    };

    public ReadHandler(Restrictor pRestrictor) {
        super(pRestrictor);
    }

    @Override
    public RequestType getType() {
        return RequestType.READ;
    }

    @Override
    public boolean handleAllServersAtOnce(JmxReadRequest pRequest) {
        return pRequest.getObjectName().isPattern() || pRequest.isMultiAttributeMode() || !pRequest.hasAttribute();
    }

    @Override
    public Object doHandleRequest(MBeanServerConnection pServer, JmxReadRequest pRequest) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        this.checkRestriction(pRequest.getObjectName(), pRequest.getAttributeName());
        return pServer.getAttribute(pRequest.getObjectName(), pRequest.getAttributeName());
    }

    @Override
    public Object doHandleRequest(MBeanServerExecutor pServerManager, JmxReadRequest pRequest) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        ObjectName oName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        if (oName.isPattern()) {
            return this.fetchAttributesForMBeanPattern(pServerManager, pRequest);
        }
        return this.fetchAttributes(pServerManager, oName, pRequest.getAttributeNames(), faultHandler);
    }

    private Object fetchAttributesForMBeanPattern(MBeanServerExecutor pServerManager, JmxReadRequest pRequest) throws IOException, InstanceNotFoundException, ReflectionException, AttributeNotFoundException, MBeanException {
        ObjectName objectName = pRequest.getObjectName();
        ValueFaultHandler faultHandler = pRequest.getValueFaultHandler();
        Set<ObjectName> names = this.searchMBeans(pServerManager, objectName);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        List<String> attributeNames = pRequest.getAttributeNames();
        for (ObjectName name : names) {
            if (!pRequest.hasAttribute()) {
                Map values = (Map)this.fetchAttributes(pServerManager, name, null, faultHandler);
                if (values == null || values.size() <= 0) continue;
                ret.put(pRequest.getOrderedObjectName(name), values);
                continue;
            }
            List<String> filteredAttributeNames = this.filterAttributeNames(pServerManager, name, attributeNames);
            if (filteredAttributeNames.size() == 0) continue;
            ret.put(pRequest.getOrderedObjectName(name), this.fetchAttributes(pServerManager, name, filteredAttributeNames, faultHandler));
        }
        if (ret.size() == 0) {
            throw new IllegalArgumentException("No matching attributes " + pRequest.getAttributeNames() + " found on MBeans " + names);
        }
        return ret;
    }

    private Set<ObjectName> searchMBeans(MBeanServerExecutor pServerManager, ObjectName pObjectName) throws IOException, InstanceNotFoundException {
        Set<ObjectName> names = pServerManager.queryNames(pObjectName);
        if (names.size() == 0) {
            throw new InstanceNotFoundException("No MBean with pattern " + pObjectName + " found for reading attributes");
        }
        return names;
    }

    private List<String> filterAttributeNames(MBeanServerExecutor pSeverManager, ObjectName pName, List<String> pNames) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        HashSet<String> attrs = new HashSet<String>(this.getAllAttributesNames(pSeverManager, pName));
        ArrayList<String> ret = new ArrayList<String>();
        for (String name : pNames) {
            if (!attrs.contains(name)) continue;
            ret.add(name);
        }
        return ret;
    }

    private Object fetchAttributes(MBeanServerExecutor pServerManager, ObjectName pMBeanName, List<String> pAttributeNames, ValueFaultHandler pFaultHandler) throws InstanceNotFoundException, IOException, ReflectionException, AttributeNotFoundException, MBeanException {
        List<String> attributes = this.resolveAttributes(pServerManager, pMBeanName, pAttributeNames);
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (String attribute : attributes) {
            try {
                this.checkRestriction(pMBeanName, attribute);
                ret.put(attribute, this.getAttribute(pServerManager, pMBeanName, attribute));
            }
            catch (MBeanException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (IllegalArgumentException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (ReflectionException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (IOException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
            catch (RuntimeException e) {
                ret.put(attribute, pFaultHandler.handleException(e));
            }
        }
        return ret;
    }

    private List<String> resolveAttributes(MBeanServerExecutor pServers, ObjectName pMBeanName, List<String> pAttributeNames) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        List<String> attributes = pAttributeNames;
        if (this.shouldAllAttributesBeFetched(pAttributeNames)) {
            attributes = this.getAllAttributesNames(pServers, pMBeanName);
        }
        return attributes;
    }

    private boolean shouldAllAttributesBeFetched(List<String> pAttributeNames) {
        if (pAttributeNames == null || pAttributeNames.size() == 0) {
            return true;
        }
        return pAttributeNames.size() == 1 && pAttributeNames.get(0) == null;
    }

    private MBeanInfo getMBeanInfo(MBeanServerExecutor pServerManager, ObjectName pObjectName) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        return pServerManager.call(pObjectName, MBEAN_INFO_HANDLER, new Object[0]);
    }

    private Object getAttribute(MBeanServerExecutor pServerManager, ObjectName pMBeanName, String attribute) throws MBeanException, ReflectionException, IOException, AttributeNotFoundException, InstanceNotFoundException {
        return pServerManager.call(pMBeanName, MBEAN_ATTRIBUTE_READ_HANDLER, attribute);
    }

    private List<String> getAllAttributesNames(MBeanServerExecutor pServerManager, ObjectName pObjectName) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        MBeanInfo mBeanInfo = this.getMBeanInfo(pServerManager, pObjectName);
        ArrayList<String> ret = new ArrayList<String>();
        for (MBeanAttributeInfo attrInfo : mBeanInfo.getAttributes()) {
            if (!attrInfo.isReadable()) continue;
            ret.add(attrInfo.getName());
        }
        return ret;
    }

    private void checkRestriction(ObjectName mBeanName, String attribute) {
        if (!this.getRestrictor().isAttributeReadAllowed(mBeanName, attribute)) {
            throw new SecurityException("Reading attribute " + attribute + " is forbidden for MBean " + mBeanName.getCanonicalName());
        }
    }

    @Override
    protected void checkForRestriction(JmxReadRequest pRequest) {
    }
}

