/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.backend.executor;

import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.backend.executor.MBeanServerExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMBeanServerExecutor
implements MBeanServerExecutor {
    protected abstract Set<MBeanServerConnection> getMBeanServers();

    protected MBeanServerConnection getJolokiaMBeanServer() {
        return null;
    }

    @Override
    public void each(ObjectName pObjectName, MBeanServerExecutor.MBeanEachCallback pCallback) throws IOException, ReflectionException, MBeanException {
        try {
            HashSet<ObjectName> visited = new HashSet<ObjectName>();
            for (MBeanServerConnection server : this.getMBeanServers()) {
                for (ObjectName nameObject : server.queryNames(pObjectName, null)) {
                    if (visited.contains(nameObject)) continue;
                    pCallback.callback(server, nameObject);
                    visited.add(nameObject);
                }
            }
        }
        catch (InstanceNotFoundException exp) {
            throw new IllegalArgumentException("Cannot find MBean " + (pObjectName != null ? "(MBean " + pObjectName + ")" : "") + ": " + exp, exp);
        }
    }

    public <T> T call(ObjectName pObjectName, MBeanServerExecutor.MBeanAction<T> pMBeanAction, Object ... pExtraArgs) throws IOException, ReflectionException, MBeanException, AttributeNotFoundException, InstanceNotFoundException {
        InstanceNotFoundException objNotFoundException = null;
        for (MBeanServerConnection server : this.getMBeanServers()) {
            try {
                return pMBeanAction.execute(server, pObjectName, pExtraArgs);
            }
            catch (InstanceNotFoundException exp) {
                objNotFoundException = exp;
            }
        }
        throw objNotFoundException;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName pObjectName) throws IOException {
        LinkedHashSet<ObjectName> names = new LinkedHashSet<ObjectName>();
        for (MBeanServerConnection server : this.getMBeanServers()) {
            names.addAll(server.queryNames(pObjectName, null));
        }
        return names;
    }
}

