/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConfigKey {
    HISTORY_MAX_ENTRIES("historyMaxEntries", true, false, "10"),
    DEBUG("debug", true, false, "false"),
    DEBUG_MAX_ENTRIES("debugMaxEntries", true, false, "100"),
    DISPATCHER_CLASSES("dispatcherClasses", true, false),
    MAX_DEPTH("maxDepth", true, true, null),
    MAX_COLLECTION_SIZE("maxCollectionSize", true, true, null),
    MAX_OBJECTS("maxObjects", true, true, null),
    POLICY_LOCATION("policyLocation", true, false, "classpath:/jolokia-access.xml"),
    IGNORE_ERRORS("ignoreErrors", false, true),
    MBEAN_QUALIFIER("mbeanQualifier", true, false),
    CALLBACK("callback", false, true),
    MIME_TYPE("mimeType", true, true, "text/plain"),
    USER("user", false, true),
    PASSWORD("password", false, true),
    AGENT_CONTEXT("agentContext", true, false, "/jolokia"),
    USE_RESTRICTOR_SERVICE("useRestrictorService", true, false, "false"),
    LISTEN_FOR_HTTP_SERVICE("listenForHttpService", true, false, "true"),
    HTTP_SERVICE_FILTER("httpServiceFilter", true, false, "");

    private String key;
    private String defaultValue;
    private boolean globalConfig;
    private boolean requestConfig;
    private static Map<String, ConfigKey> keyByName;
    private static Map<String, ConfigKey> globalKeyByName;
    private static Map<String, ConfigKey> requestKeyByName;

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig) {
        this(pValue, pIsGlobalConfig, pIsRequestConfig, null);
    }

    private ConfigKey(String pValue, boolean pIsGlobalConfig, boolean pIsRequestConfig, String pDefault) {
        this.key = pValue;
        this.defaultValue = pDefault;
        this.globalConfig = pIsGlobalConfig;
        this.requestConfig = pIsRequestConfig;
    }

    public String toString() {
        return this.key;
    }

    public static ConfigKey getGlobalConfigKey(String pKeyS) {
        return globalKeyByName.get(pKeyS);
    }

    public static ConfigKey getRequestConfigKey(String pKeyS) {
        return requestKeyByName.get(pKeyS);
    }

    public String getKeyValue() {
        return this.key;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isGlobalConfig() {
        return this.globalConfig;
    }

    public boolean isRequestConfig() {
        return this.requestConfig;
    }

    public String getValue(Map<ConfigKey, String> pConfig) {
        String value = pConfig.get((Object)this);
        if (value == null) {
            value = this.getDefaultValue();
        }
        return value;
    }

    public static Map<ConfigKey, String> extractConfig(Map<String, String> pMap) {
        HashMap<ConfigKey, String> ret = new HashMap<ConfigKey, String>();
        for (ConfigKey c : ConfigKey.values()) {
            String value = pMap.get(c.getKeyValue());
            if (value == null) continue;
            ret.put(c, value);
        }
        return ret;
    }

    static {
        keyByName = new HashMap<String, ConfigKey>();
        globalKeyByName = new HashMap<String, ConfigKey>();
        requestKeyByName = new HashMap<String, ConfigKey>();
        for (ConfigKey ck : ConfigKey.values()) {
            keyByName.put(ck.getKeyValue(), ck);
            if (ck.isGlobalConfig()) {
                globalKeyByName.put(ck.getKeyValue(), ck);
            }
            if (!ck.isRequestConfig()) continue;
            requestKeyByName.put(ck.getKeyValue(), ck);
        }
    }
}

