/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.mule;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.util.security.Credential;
import org.jolokia.http.AgentServlet;
import org.jolokia.mule.MuleAgentConfig;
import org.jolokia.mule.MuleAgentHttpServer;
import org.jolokia.util.ClassUtil;
import org.jolokia.util.NetworkUtil;
import org.mule.api.agent.Agent;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.StopException;
import org.mule.api.lifecycle.Stoppable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EclipseMuleAgentHttpServer
implements MuleAgentHttpServer {
    private Agent parent;
    private Server server;

    EclipseMuleAgentHttpServer(Agent pParent, MuleAgentConfig pConfig) {
        this.parent = pParent;
        this.server = this.getServer(pConfig);
        ServletContextHandler root = this.getContext((HandlerContainer)this.server, pConfig);
        ServletHolder servletHolder = this.getServletHolder(pConfig);
        root.addServlet(servletHolder, "/*");
    }

    @Override
    public void start() throws StartException {
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e, (Startable)this.parent);
        }
    }

    @Override
    public void stop() throws StopException {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new StopException((Throwable)e, (Stoppable)this.parent);
        }
    }

    protected Server getServer(MuleAgentConfig pConfig) {
        Server newServer = new Server();
        Connector connector = this.createConnector(newServer);
        if (pConfig.getHost() != null) {
            ClassUtil.applyMethod((Object)connector, (String)"setHost", (Object[])new Object[]{pConfig.getHost()});
        }
        ClassUtil.applyMethod((Object)connector, (String)"setPort", (Object[])new Object[]{pConfig.getPort()});
        newServer.setConnectors(new Connector[]{connector});
        return newServer;
    }

    protected abstract Connector createConnector(Server var1);

    private ServletHolder getServletHolder(MuleAgentConfig pConfig) {
        ServletHolder holder = new ServletHolder((Servlet)new AgentServlet());
        holder.setInitParameters(this.getInitParameters(pConfig));
        holder.setInitOrder(1);
        return holder;
    }

    private ServletContextHandler getContext(HandlerContainer pContainer, MuleAgentConfig pConfig) {
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/jolokia");
        this.server.setHandler((Handler)context);
        if (pConfig.getUser() != null && pConfig.getPassword() != null) {
            context.setSecurityHandler(this.getSecurityHandler(pConfig.getUser(), pConfig.getPassword(), "jolokia-role"));
        }
        return context;
    }

    private SecurityHandler getSecurityHandler(String pUser, String pPassword, String pRole) {
        HashLoginService loginService = this.getLoginService(pUser, pPassword, pRole);
        this.server.addBean((Object)loginService);
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.setConstraintMappings(this.getConstraintMappings(pRole));
        securityHandler.setAuthenticator((Authenticator)new BasicAuthenticator());
        securityHandler.addBean((Object)loginService);
        return securityHandler;
    }

    private HashLoginService getLoginService(String pUser, String pPassword, String pRole) {
        Credential credential = Credential.getCredential((String)pPassword);
        HashLoginService loginService = new HashLoginService("jolokia Realm");
        loginService.putUser(pUser, credential, new String[]{pRole});
        return loginService;
    }

    private ConstraintMapping[] getConstraintMappings(String ... pRoles) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(pRoles);
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        return new ConstraintMapping[]{cm};
    }

    private Map<String, String> getInitParameters(MuleAgentConfig pConfig) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("debugMaxEntries", "" + pConfig.getDebugMaxEntries());
        ret.put("historyMaxEntries", "" + pConfig.getHistoryMaxEntries());
        ret.put("maxCollectionsSize", "" + pConfig.getMaxCollectionSize());
        ret.put("maxDepth", "" + pConfig.getMaxDepth());
        ret.put("maxObjects", "" + pConfig.getMaxObjects());
        ret.put("debug", "" + pConfig.isDebug());
        ret.put("agentType", "mule");
        ret.put("agentId", NetworkUtil.getAgentId((int)this.hashCode(), (String)"mule"));
        return ret;
    }
}

