/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.mule;

import java.io.IOException;
import org.jolokia.mule.MuleAgentConfig;
import org.jolokia.mule.MuleAgentHttpServer;
import org.jolokia.mule.MuleAgentHttpServerFactory;
import org.jolokia.util.NetworkUtil;
import org.mule.AbstractAgent;
import org.mule.api.MuleException;
import org.mule.api.agent.Agent;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.StartException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.StopException;
import org.mule.api.lifecycle.Stoppable;

public class JolokiaMuleAgent
extends AbstractAgent
implements MuleAgentConfig {
    protected MuleAgentHttpServer server;
    private String user;
    private String password;
    private String host = null;
    private int port = 8888;
    private boolean debug = false;
    private int historyMaxEntries = 10;
    private int debugMaxEntries = 100;
    private int maxDepth = 5;
    private int maxCollectionSize = 0;
    private int maxObjects = 10000;

    protected JolokiaMuleAgent() {
        super("jolokia-agent");
    }

    public void start() throws MuleException {
        if (this.server == null) {
            throw new StartException((Throwable)new IllegalStateException("Cannot start the HTTP server since this context is not initialized"), (Startable)this);
        }
        this.server.start();
    }

    public void stop() throws MuleException {
        if (this.server == null) {
            throw new StopException((Throwable)new IllegalStateException("Cannot stop the HTTP server since this context is not initialized"), (Stoppable)this);
        }
        this.server.stop();
    }

    public String getDescription() {
        String hostDescr = this.host;
        try {
            if (hostDescr == null) {
                hostDescr = NetworkUtil.getLocalAddress().getHostName();
            }
        }
        catch (IOException e) {
            hostDescr = "localhost";
        }
        return "Jolokia Agent: http://" + hostDescr + ":" + this.getPort() + "/jolokia";
    }

    public void dispose() {
    }

    public void registered() {
    }

    public void unregistered() {
    }

    public void initialise() throws InitialisationException {
        this.server = MuleAgentHttpServerFactory.create((Agent)this, this);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String pHost) {
        this.host = pHost;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int pPort) {
        this.port = pPort;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String pUser) {
        this.user = pUser;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String pPassword) {
        this.password = pPassword;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean pDebug) {
        this.debug = pDebug;
    }

    public int getHistoryMaxEntries() {
        return this.historyMaxEntries;
    }

    public void setHistoryMaxEntries(int pHistoryMaxEntries) {
        this.historyMaxEntries = pHistoryMaxEntries;
    }

    public int getDebugMaxEntries() {
        return this.debugMaxEntries;
    }

    public void setDebugMaxEntries(int pDebugMaxEntries) {
        this.debugMaxEntries = pDebugMaxEntries;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int pMaxDepth) {
        this.maxDepth = pMaxDepth;
    }

    public int getMaxCollectionSize() {
        return this.maxCollectionSize;
    }

    public void setMaxCollectionSize(int pMaxCollectionSize) {
        this.maxCollectionSize = pMaxCollectionSize;
    }

    public int getMaxObjects() {
        return this.maxObjects;
    }

    public void setMaxObjects(int pMaxObjects) {
        this.maxObjects = pMaxObjects;
    }
}

