/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.kubernetes.client;

import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.base.OperationSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jolokia.util.Base64Util;
import org.json.simple.JSONObject;

public class MinimalHttpClientAdapter
implements HttpClient {
    private final BaseClient client;
    private final String urlPath;
    private String user;
    private String password;

    public MinimalHttpClientAdapter(BaseClient client, String urlPath, Map<String, Object> env) {
        this.client = client;
        this.urlPath = urlPath;
        String[] credentials = (String[])env.get("jmx.remote.credentials");
        if (credentials != null) {
            this.user = credentials[0];
            this.password = credentials[1];
        }
    }

    static void authenticate(Map<String, String> headers, String username, String password) {
        if (username != null) {
            headers.put("X-jolokia-authorization", "Basic " + Base64Util.encode((byte[])(username + ":" + password).getBytes()));
        }
    }

    public HttpParams getParams() {
        throw new UnsupportedOperationException();
    }

    public ClientConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        try {
            Response response = MinimalHttpClientAdapter.performRequest(this.client, this.urlPath, this.extractBody((HttpRequest)httpUriRequest), httpUriRequest.getURI().getQuery(), this.allHeaders(httpUriRequest));
            return this.convertResponse(response);
        }
        catch (KubernetesClientException e) {
            throw new ClientProtocolException((Throwable)e);
        }
    }

    private Map<String, String> allHeaders(HttpUriRequest httpUriRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : httpUriRequest.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        MinimalHttpClientAdapter.authenticate(headers, this.user, this.password);
        return headers;
    }

    public static Response performRequest(BaseClient client, String path, byte[] body, String query, Map<String, String> headers) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])body)).url(MinimalHttpClientAdapter.buildHttpUri(client, path, query));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            requestBuilder.addHeader(header.getKey(), header.getValue());
        }
        return client.getHttpClient().newCall(requestBuilder.build()).execute();
    }

    private static URL buildHttpUri(BaseClient client, String resourcePath, String query) {
        URL masterUrl = client.getMasterUrl();
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(masterUrl.getProtocol()).host(masterUrl.getHost()).query(query);
        builder.encodedPath(resourcePath);
        if (masterUrl.getPort() != -1) {
            builder.port(masterUrl.getPort());
        }
        return builder.build().url();
    }

    protected HttpResponse convertResponse(Response response) throws IOException {
        int responseCode = response.code();
        BasicHttpResponse convertedResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine(this.convertProtocol(response.protocol()), responseCode, response.message()));
        for (String header : response.headers().names()) {
            convertedResponse.setHeader(header, response.header(header));
        }
        if (response.body() != null) {
            BasicHttpEntity responseEntity = new BasicHttpEntity();
            byte[] responseBytes = null;
            if (responseCode >= 400) {
                JSONObject errorResponse = new JSONObject();
                Object syntethicException = new ClientProtocolException("Failure calling Jolokia in kubernetes");
                errorResponse.put((Object)"status", (Object)responseCode);
                try {
                    syntethicException = new KubernetesClientException(OperationSupport.createStatus((Response)response));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                errorResponse.put((Object)"error_type", (Object)syntethicException.getClass().getName());
                errorResponse.put((Object)"error", (Object)((Throwable)syntethicException).getMessage());
                StringWriter stacktrace = new StringWriter();
                ((Throwable)syntethicException).printStackTrace(new PrintWriter(stacktrace));
                errorResponse.put((Object)"stacktrace", (Object)stacktrace.getBuffer().toString());
                responseBytes = errorResponse.toJSONString().getBytes();
            } else {
                responseBytes = response.body().bytes();
            }
            responseEntity.setContentLength((long)responseBytes.length);
            responseEntity.setContent((InputStream)new ByteArrayInputStream(responseBytes));
            responseEntity.setContentType(response.header("Content-Type"));
            convertedResponse.setEntity((HttpEntity)responseEntity);
            convertedResponse.setHeader("Content-Length", String.valueOf(responseBytes.length));
        }
        return convertedResponse;
    }

    protected byte[] extractBody(HttpRequest httpUriRequest) throws IOException {
        if (httpUriRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)httpUriRequest).getEntity();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)buffer);
            return buffer.toByteArray();
        }
        return null;
    }

    private ProtocolVersion convertProtocol(Protocol protocol) {
        StringTokenizer parser = new StringTokenizer(protocol.name(), "_", false);
        return new ProtocolVersion(parser.nextToken(), Integer.parseInt(parser.nextToken()), parser.hasMoreTokens() ? Integer.parseInt(parser.nextToken()) : 0);
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

