/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.kubernetes.client;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.BaseClient;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.remote.JMXServiceURL;
import okhttp3.Response;
import org.apache.http.client.HttpClient;
import org.jolokia.client.J4pClient;
import org.jolokia.client.jmxadapter.JolokiaJmxConnector;
import org.jolokia.client.jmxadapter.RemoteJmxAdapter;
import org.jolokia.kubernetes.client.MinimalHttpClientAdapter;

public class KubernetesJmxConnector
extends JolokiaJmxConnector {
    private static Pattern POD_PATTERN = Pattern.compile("/?(?<namespace>[^/]+)/(?<protocol>https?:)?(?<podPattern>[^/^:]+)(?<port>:[^/]+)?/(?<path>.+)");
    private static Map<String, KubernetesClient> apiClients = Collections.synchronizedMap(new HashMap());
    public static String KUBERNETES_CLIENT_CONTEXT = "kubernetes.client.context";

    public KubernetesJmxConnector(JMXServiceURL serviceURL, Map<String, ?> environment) {
        super(serviceURL, environment);
    }

    public void connect(Map<String, ?> env) throws IOException {
        if (!"kubernetes".equals(this.serviceUrl.getProtocol())) {
            throw new MalformedURLException(String.format("Invalid URL %s : Only protocol \"kubernetes\" is supported (not %s)", this.serviceUrl, this.serviceUrl.getProtocol()));
        }
        Map mergedEnvironment = this.mergedEnvironment(env);
        KubernetesClient client = KubernetesJmxConnector.getApiClient((String)env.get(KUBERNETES_CLIENT_CONTEXT));
        this.adapter = this.createAdapter(this.expandAndProbeUrl(client, mergedEnvironment));
        this.postCreateAdapter();
    }

    protected RemoteJmxAdapter createAdapter(J4pClient client) throws IOException {
        return new RemoteJmxAdapter(client);
    }

    public static KubernetesClient getApiClient(String context) {
        String key = String.valueOf(context);
        KubernetesClient client = apiClients.get(key);
        if (client == null) {
            client = new DefaultKubernetesClient(Config.autoConfigure((String)context));
            apiClients.put(key, client);
        }
        return client;
    }

    public static void resetKubernetesConfig() {
        apiClients.clear();
    }

    protected J4pClient expandAndProbeUrl(KubernetesClient client, Map<String, Object> env) throws MalformedURLException {
        String proxyPath = this.serviceUrl.getURLPath();
        HashMap<String, String> headersForProbe = KubernetesJmxConnector.createHeadersForProbe(env);
        try {
            Matcher matcher;
            if (POD_PATTERN.matcher(proxyPath).matches() && (matcher = POD_PATTERN.matcher(proxyPath)).find()) {
                J4pClient connection;
                String namespace = matcher.group("namespace");
                String podPattern = matcher.group("podPattern");
                String path = matcher.group("path");
                String protocol = matcher.group("protocol");
                String port = matcher.group("port");
                Pod exactPod = (Pod)((PodResource)((NonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podPattern)).get();
                if (exactPod != null && (connection = KubernetesJmxConnector.probeProxyPath(env, client, this.buildProxyPath(exactPod, protocol, port, path), headersForProbe)) != null) {
                    return connection;
                }
                for (Pod pod : ((PodList)((NonNamespaceOperation)client.pods().inNamespace(namespace)).list()).getItems()) {
                    if (!pod.getMetadata().getName().matches(podPattern) || (connection = KubernetesJmxConnector.probeProxyPath(env, client, this.buildProxyPath(pod, protocol, port, path), headersForProbe)) == null) continue;
                    return connection;
                }
            }
        }
        catch (KubernetesClientException kubernetesClientException) {
            // empty catch block
        }
        throw new MalformedURLException("Unable to connect to proxypath " + proxyPath);
    }

    private StringBuilder buildProxyPath(Pod pod, String protocol, String port, String path) {
        int index;
        StringBuilder url = new StringBuilder(pod.getMetadata().getSelfLink());
        if (protocol != null && !protocol.equals("http:") && (index = url.lastIndexOf(pod.getMetadata().getName())) > -1) {
            url.insert(index, protocol);
        }
        if (port != null) {
            url.append(port);
        }
        url.append("/proxy");
        if (!path.startsWith("/")) {
            url.append('/');
        }
        url.append(path);
        return url;
    }

    private static HashMap<String, String> createHeadersForProbe(Map<String, Object> env) {
        HashMap<String, String> headers = new HashMap<String, String>();
        String[] credentials = (String[])env.get("jmx.remote.credentials");
        if (credentials != null) {
            MinimalHttpClientAdapter.authenticate(headers, credentials[0], credentials[1]);
        }
        return headers;
    }

    public static J4pClient probeProxyPath(Map<String, Object> env, KubernetesClient client, StringBuilder url, HashMap<String, String> headers) {
        try {
            String proxyPath = url.toString();
            Response response = MinimalHttpClientAdapter.performRequest((BaseClient)client, proxyPath, "{\"type\":\"version\"}".getBytes(), null, headers);
            if (response.body() != null) {
                response.body().close();
            }
            if (response.isSuccessful()) {
                return new J4pClient(proxyPath, (HttpClient)new MinimalHttpClientAdapter((BaseClient)client, proxyPath, env));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

