/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.security;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Date;
import org.jolokia.Version;
import org.jolokia.jvmagent.security.PKCS1Util;
import org.jolokia.util.Base64Util;
import org.jolokia.util.ClassUtil;
import sun.security.x509.X500Name;

public class KeyStoreUtil {
    private static final String KEYGEN_CLASS_JDK8 = "sun.security.tools.keytool.CertAndKeyGen";
    private static final String KEYGEN_CLASS_JDK7 = "sun.security.x509.CertAndKeyGen";

    private KeyStoreUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWithCaPem(KeyStore pTrustStore, File pCaCert) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        FileInputStream is = new FileInputStream(pCaCert);
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
            String alias = cert.getSubjectX500Principal().getName();
            pTrustStore.setCertificateEntry(alias, cert);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateWithServerPems(KeyStore pKeyStore, File pServerCert, File pServerKey, String pKeyAlgo, char[] pPassword) throws IOException, CertificateException, NoSuchAlgorithmException, InvalidKeySpecException, KeyStoreException {
        FileInputStream is = new FileInputStream(pServerCert);
        try {
            PrivateKey privateKey;
            CertificateFactory certFactory = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(is);
            byte[] keyBytes = KeyStoreUtil.decodePem(pServerKey);
            KeyFactory keyFactory = KeyFactory.getInstance(pKeyAlgo);
            try {
                privateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(keyBytes));
            }
            catch (InvalidKeySpecException e) {
                RSAPrivateCrtKeySpec keySpec = PKCS1Util.decodePKCS1(keyBytes);
                privateKey = keyFactory.generatePrivate(keySpec);
            }
            String alias = cert.getSubjectX500Principal().getName();
            pKeyStore.setKeyEntry(alias, privateKey, pPassword, new Certificate[]{cert});
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static void updateWithSelfSignedServerCertificate(KeyStore pKeyStore) throws NoSuchProviderException, NoSuchAlgorithmException, IOException, InvalidKeyException, CertificateException, SignatureException, KeyStoreException {
        X500Name x500Name = new X500Name("Jolokia Agent " + Version.getAgentVersion(), "JVM", "jolokia.org", "Pegnitz", "Franconia", "DE");
        Object keypair = KeyStoreUtil.createKeyPair();
        PrivateKey privKey = KeyStoreUtil.getPrivateKey(keypair);
        Certificate[] chain = new X509Certificate[]{KeyStoreUtil.getSelfCertificate(keypair, x500Name, new Date(), 315360000L)};
        pKeyStore.setKeyEntry("jolokia-agent", privKey, new char[0], chain);
    }

    private static Object createKeyPair() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
        Class keyGenClass = KeyStoreUtil.lookupKeyGenClass();
        Object keypair = ClassUtil.newInstance((Class)keyGenClass, (Object[])new Object[]{"RSA", "SHA1WithRSA"});
        ClassUtil.applyMethod((Object)keypair, (String)"generate", (Object[])new Object[]{2048});
        return keypair;
    }

    private static X509Certificate getSelfCertificate(Object keypair, X500Name x500Name, Date date, long l) {
        return (X509Certificate)ClassUtil.applyMethod((Object)keypair, (String)"getSelfCertificate", (Object[])new Object[]{x500Name, date, l});
    }

    private static PrivateKey getPrivateKey(Object keypair) {
        return (PrivateKey)ClassUtil.applyMethod((Object)keypair, (String)"getPrivateKey", (Object[])new Object[0]);
    }

    private static Class lookupKeyGenClass() {
        Class keyGenClass = ClassUtil.classForName((String)KEYGEN_CLASS_JDK8, (ClassLoader[])new ClassLoader[0]);
        if (keyGenClass == null) {
            keyGenClass = ClassUtil.classForName((String)KEYGEN_CLASS_JDK7, (ClassLoader[])new ClassLoader[0]);
        }
        if (keyGenClass == null) {
            throw new IllegalStateException("Cannot lookup key-generator class: Neither Java8's sun.security.tools.keytool.CertAndKeyGen nor sun.security.x509.CertAndKeyGen can be looked up with the context class loader");
        }
        return keyGenClass;
    }

    private static byte[] decodePem(File pemFile) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(pemFile));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("-----BEGIN ")) continue;
                byte[] byArray = KeyStoreUtil.readBytes(pemFile, reader, line.trim().replace("BEGIN", "END"));
                return byArray;
            }
            throw new IOException("PEM " + pemFile + " is invalid: no begin marker");
        }
        finally {
            reader.close();
        }
    }

    private static byte[] readBytes(File pemFile, BufferedReader reader, String endMarker) throws IOException {
        String line;
        StringBuffer buf = new StringBuffer();
        while ((line = reader.readLine()) != null) {
            if (line.indexOf(endMarker) != -1) {
                return Base64Util.decode((String)buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException(pemFile + " is invalid : No end marker");
    }
}

