/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.handler;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.RuntimeMBeanException;
import javax.security.auth.Subject;
import org.jolokia.backend.BackendManager;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.discovery.AgentDetails;
import org.jolokia.discovery.AgentDetailsHolder;
import org.jolokia.discovery.DiscoveryMulticastResponder;
import org.jolokia.http.HttpRequestHandler;
import org.jolokia.jvmagent.ParsedUri;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.RestrictorFactory;
import org.jolokia.util.ChunkedWriter;
import org.jolokia.util.ClassUtil;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;
import org.json.simple.JSONStreamAware;

public class JolokiaHttpHandler
implements HttpHandler {
    private BackendManager backendManager;
    private HttpRequestHandler requestHandler;
    private String context;
    private Pattern contentTypePattern = Pattern.compile(".*;\\s*charset=([^;,]+)\\s*.*");
    private Configuration configuration;
    private final LogHandler logHandler;
    private DiscoveryMulticastResponder discoveryMulticastResponder;

    public JolokiaHttpHandler(Configuration pConfig) {
        this(pConfig, null);
    }

    public JolokiaHttpHandler(Configuration pConfig, LogHandler pLogHandler) {
        this.configuration = pConfig;
        this.context = pConfig.get(ConfigKey.AGENT_CONTEXT);
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.logHandler = pLogHandler != null ? pLogHandler : this.createLogHandler(pConfig.get(ConfigKey.LOGHANDLER_CLASS), pConfig.get(ConfigKey.DEBUG));
    }

    public void start(boolean pLazy) {
        Restrictor restrictor = RestrictorFactory.createRestrictor((Configuration)this.configuration, (LogHandler)this.logHandler);
        this.backendManager = new BackendManager(this.configuration, this.logHandler, restrictor, pLazy);
        this.requestHandler = new HttpRequestHandler(this.configuration, this.backendManager, this.logHandler);
        if (this.listenForDiscoveryMcRequests(this.configuration)) {
            try {
                this.discoveryMulticastResponder = new DiscoveryMulticastResponder((AgentDetailsHolder)this.backendManager, restrictor, this.logHandler);
                this.discoveryMulticastResponder.start();
            }
            catch (IOException e) {
                this.logHandler.error("Cannot start discovery multicast handler: " + e, (Throwable)e);
            }
        }
    }

    private boolean listenForDiscoveryMcRequests(Configuration pConfig) {
        String enable = pConfig.get(ConfigKey.DISCOVERY_ENABLED);
        String url = pConfig.get(ConfigKey.DISCOVERY_AGENT_URL);
        return url != null || enable == null || Boolean.valueOf(enable) != false;
    }

    public void start(boolean pLazy, String pUrl, boolean pSecured) {
        this.start(pLazy);
        AgentDetails details = this.backendManager.getAgentDetails();
        details.setUrl(pUrl);
        details.setSecured(Boolean.valueOf(pSecured));
    }

    public void stop() {
        if (this.discoveryMulticastResponder != null) {
            this.discoveryMulticastResponder.stop();
            this.discoveryMulticastResponder = null;
        }
        this.backendManager.destroy();
        this.backendManager = null;
        this.requestHandler = null;
    }

    @Override
    public void handle(HttpExchange pHttpExchange) throws IOException {
        try {
            this.checkAuthentication(pHttpExchange);
            Subject subject = (Subject)pHttpExchange.getAttribute("org.jolokia.jaasSubject");
            if (subject != null) {
                this.doHandleAs(subject, pHttpExchange);
            } else {
                this.doHandle(pHttpExchange);
            }
        }
        catch (SecurityException exp) {
            this.sendForbidden(pHttpExchange, exp);
        }
    }

    private void doHandleAs(Subject subject, final HttpExchange pHttpExchange) {
        try {
            Subject.doAs(subject, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws IOException {
                    JolokiaHttpHandler.this.doHandle(pHttpExchange);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new SecurityException("Security exception: " + e.getCause(), e.getCause());
        }
    }

    protected void checkAuthentication(HttpExchange pHttpExchange) throws SecurityException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandle(HttpExchange pExchange) throws IOException {
        ParsedUri parsedUri;
        JSONObject json;
        block8: {
            if (this.requestHandler == null) {
                throw new IllegalStateException("Handler not yet started");
            }
            json = null;
            URI uri = pExchange.getRequestURI();
            parsedUri = new ParsedUri(uri, this.context);
            try {
                InetSocketAddress address = pExchange.getRemoteAddress();
                this.requestHandler.checkAccess(this.getHostName(address), address.getAddress().getHostAddress(), this.extractOriginOrReferer(pExchange));
                String method = pExchange.getRequestMethod();
                if ("GET".equalsIgnoreCase(method)) {
                    this.setHeaders(pExchange);
                    json = this.executeGetRequest(parsedUri);
                    break block8;
                }
                if ("POST".equalsIgnoreCase(method)) {
                    this.setHeaders(pExchange);
                    json = this.executePostRequest(pExchange, parsedUri);
                    break block8;
                }
                if ("OPTIONS".equalsIgnoreCase(method)) {
                    this.performCorsPreflightCheck(pExchange);
                    break block8;
                }
                throw new IllegalArgumentException("HTTP Method " + method + " is not supported.");
            }
            catch (Throwable exp) {
                try {
                    json = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
                }
                catch (Throwable throwable) {
                    this.sendResponse(pExchange, parsedUri, (JSONAware)json);
                    throw throwable;
                }
                this.sendResponse(pExchange, parsedUri, (JSONAware)json);
            }
        }
        this.sendResponse(pExchange, parsedUri, (JSONAware)json);
    }

    private String extractOriginOrReferer(HttpExchange pExchange) {
        Headers headers = pExchange.getRequestHeaders();
        String origin = headers.getFirst("Origin");
        if (origin == null) {
            origin = headers.getFirst("Referer");
        }
        return origin != null ? origin.replaceAll("[\\n\\r]*", "") : null;
    }

    private String getHostName(InetSocketAddress address) {
        return this.configuration.getAsBoolean(ConfigKey.ALLOW_DNS_REVERSE_LOOKUP) ? address.getHostName() : null;
    }

    private JSONAware executeGetRequest(ParsedUri parsedUri) {
        return this.requestHandler.handleGetRequest(parsedUri.getUri().toString(), parsedUri.getPathInfo(), parsedUri.getParameterMap());
    }

    private JSONAware executePostRequest(HttpExchange pExchange, ParsedUri pUri) throws MalformedObjectNameException, IOException {
        Matcher matcher;
        String encoding = null;
        Headers headers = pExchange.getRequestHeaders();
        String cType = headers.getFirst("Content-Type");
        if (cType != null && (matcher = this.contentTypePattern.matcher(cType)).matches()) {
            encoding = matcher.group(1);
        }
        InputStream is = pExchange.getRequestBody();
        return this.requestHandler.handlePostRequest(pUri.toString(), is, encoding, pUri.getParameterMap());
    }

    private void performCorsPreflightCheck(HttpExchange pExchange) {
        Headers requestHeaders = pExchange.getRequestHeaders();
        Map respHeaders = this.requestHandler.handleCorsPreflightRequest(requestHeaders.getFirst("Origin"), requestHeaders.getFirst("Access-Control-Request-Headers"));
        Headers responseHeaders = pExchange.getResponseHeaders();
        for (Map.Entry entry : respHeaders.entrySet()) {
            responseHeaders.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setHeaders(HttpExchange pExchange) {
        String origin = this.requestHandler.extractCorsOrigin(pExchange.getRequestHeaders().getFirst("Origin"));
        Headers headers = pExchange.getResponseHeaders();
        if (origin != null) {
            headers.set("Access-Control-Allow-Origin", origin);
            headers.set("Access-Control-Allow-Credentials", "true");
        }
        headers.set("Cache-Control", "no-cache");
        headers.set("Pragma", "no-cache");
        Calendar cal = Calendar.getInstance();
        headers.set("Date", this.formatHeaderDate(cal.getTime()));
        cal.add(10, -1);
        headers.set("Expires", this.formatHeaderDate(cal.getTime()));
    }

    private void sendForbidden(HttpExchange pExchange, SecurityException securityException) throws IOException {
        String response = "403 (Forbidden)\n";
        if (securityException != null && securityException.getMessage() != null) {
            response = response + "\n" + securityException.getMessage() + "\n";
        }
        pExchange.sendResponseHeaders(403, response.length());
        OutputStream os = pExchange.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }

    private void sendResponse(HttpExchange pExchange, ParsedUri pParsedUri, JSONAware pJson) throws IOException {
        boolean streaming = this.configuration.getAsBoolean(ConfigKey.STREAMING);
        if (streaming) {
            JSONStreamAware jsonStream = (JSONStreamAware)pJson;
            this.sendStreamingResponse(pExchange, pParsedUri, jsonStream);
        } else {
            this.sendAllJSON(pExchange, pParsedUri, pJson);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendStreamingResponse(HttpExchange pExchange, ParsedUri pParsedUri, JSONStreamAware pJson) throws IOException {
        ChunkedWriter writer = null;
        try {
            Headers headers = pExchange.getResponseHeaders();
            if (pJson != null) {
                headers.set("Content-Type", this.getMimeType(pParsedUri) + "; charset=utf-8");
                String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
                pExchange.sendResponseHeaders(200, 0L);
                writer = new ChunkedWriter(pExchange.getResponseBody(), "UTF-8");
                if (callback == null) {
                    pJson.writeJSONString((Writer)writer);
                } else {
                    writer.write(callback);
                    writer.write("(");
                    pJson.writeJSONString((Writer)writer);
                    writer.write(");");
                }
            } else {
                headers.set("Content-Type", "text/plain");
                pExchange.sendResponseHeaders(200, -1L);
            }
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAllJSON(HttpExchange pExchange, ParsedUri pParsedUri, JSONAware pJson) throws IOException {
        OutputStream out = null;
        try {
            Headers headers = pExchange.getResponseHeaders();
            if (pJson != null) {
                headers.set("Content-Type", this.getMimeType(pParsedUri) + "; charset=utf-8");
                String json = pJson.toJSONString();
                String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
                String content = callback == null ? json : callback + "(" + json + ");";
                byte[] response = content.getBytes("UTF8");
                pExchange.sendResponseHeaders(200, response.length);
                out = pExchange.getResponseBody();
                out.write(response);
            } else {
                headers.set("Content-Type", "text/plain");
                pExchange.sendResponseHeaders(200, -1L);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private String getMimeType(ParsedUri pParsedUri) {
        if (pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue()) != null) {
            return "text/javascript";
        }
        String mimeType = pParsedUri.getParameter(ConfigKey.MIME_TYPE.getKeyValue());
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = this.configuration.get(ConfigKey.MIME_TYPE);
        return mimeType != null ? mimeType : ConfigKey.MIME_TYPE.getDefaultValue();
    }

    private LogHandler createLogHandler(String pLogHandlerClass, String pDebug) {
        if (pLogHandlerClass != null) {
            return (LogHandler)ClassUtil.newInstance((String)pLogHandlerClass, (Object[])new Object[0]);
        }
        boolean debug = Boolean.valueOf(pDebug);
        return new LogHandler.StdoutLogHandler(debug);
    }

    private String formatHeaderDate(Date date) {
        SimpleDateFormat rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        rfc1123Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return rfc1123Format.format(date);
    }
}

