/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;
import org.jolokia.config.ConfigKey;
import org.jolokia.jvmagent.CleanupThread;
import org.jolokia.jvmagent.JolokiaServerConfig;
import org.jolokia.jvmagent.handler.JolokiaHttpHandler;
import org.jolokia.jvmagent.security.KeyStoreUtil;
import org.jolokia.util.NetworkUtil;

public class JolokiaServer {
    private JolokiaServerConfig config;
    private boolean lazy;
    private CleanupThread cleaner = null;
    private HttpServer httpServer;
    private InetSocketAddress serverAddress;
    private String url;
    private JolokiaHttpHandler jolokiaHttpHandler;
    private ThreadFactory daemonThreadFactory = new DaemonThreadFactory();

    public JolokiaServer(JolokiaServerConfig pConfig, boolean pLazy) throws IOException {
        this.init(pConfig, pLazy);
    }

    public JolokiaServer(HttpServer pServer, JolokiaServerConfig pConfig, boolean pLazy) {
        this.init(pServer, pConfig, pLazy);
    }

    protected JolokiaServer() {
    }

    public void start() {
        String configUrl = NetworkUtil.replaceExpression((String)this.config.getJolokiaConfig().get(ConfigKey.DISCOVERY_AGENT_URL));
        this.jolokiaHttpHandler.start(this.lazy, configUrl != null ? configUrl : this.url, this.config.getAuthenticator() != null);
        if (this.httpServer != null) {
            ThreadGroup threadGroup = new ThreadGroup("jolokia");
            threadGroup.setDaemon(false);
            Thread starterThread = new Thread(threadGroup, new Runnable(){

                @Override
                public void run() {
                    JolokiaServer.this.httpServer.start();
                }
            });
            starterThread.start();
            this.cleaner = new CleanupThread(this.httpServer, threadGroup);
            this.cleaner.start();
        }
    }

    public void stop() {
        this.jolokiaHttpHandler.stop();
        if (this.cleaner != null) {
            this.cleaner.stopServer();
        }
    }

    public String getUrl() {
        return this.url;
    }

    public JolokiaServerConfig getServerConfig() {
        return this.config;
    }

    protected final void init(JolokiaServerConfig pConfig, boolean pLazy) throws IOException {
        this.httpServer = this.createHttpServer(pConfig);
        this.init(this.httpServer, pConfig, pLazy);
    }

    protected final void init(HttpServer pServer, JolokiaServerConfig pConfig, boolean pLazy) {
        this.config = pConfig;
        this.lazy = pLazy;
        String contextPath = pConfig.getContextPath();
        this.jolokiaHttpHandler = new JolokiaHttpHandler(pConfig.getJolokiaConfig());
        HttpContext context = pServer.createContext(contextPath, this.jolokiaHttpHandler);
        Authenticator authenticator = pConfig.getAuthenticator();
        if (authenticator != null) {
            context.setAuthenticator(authenticator);
        }
        this.url = this.detectAgentUrl(pServer, pConfig, contextPath);
    }

    private String detectAgentUrl(HttpServer pServer, JolokiaServerConfig pConfig, String pContextPath) {
        int port;
        InetAddress realAddress;
        this.serverAddress = pServer.getAddress();
        if (this.serverAddress != null) {
            realAddress = this.serverAddress.getAddress();
            if (realAddress.isAnyLocalAddress()) {
                try {
                    realAddress = NetworkUtil.getLocalAddress();
                }
                catch (IOException e) {
                    try {
                        realAddress = InetAddress.getLocalHost();
                    }
                    catch (UnknownHostException e1) {
                        realAddress = this.serverAddress.getAddress();
                    }
                }
            }
            port = this.serverAddress.getPort();
        } else {
            realAddress = pConfig.getAddress();
            port = pConfig.getPort();
        }
        return String.format("%s://%s:%d%s", pConfig.getProtocol(), realAddress.getHostAddress(), port, pContextPath);
    }

    private HttpServer createHttpServer(JolokiaServerConfig pConfig) throws IOException {
        int port = pConfig.getPort();
        InetAddress address = pConfig.getAddress();
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        HttpServer server = pConfig.useHttps() ? this.createHttpsServer(socketAddress, pConfig) : HttpServer.create(socketAddress, pConfig.getBacklog());
        String mode = pConfig.getExecutor();
        ExecutorService executor = "fixed".equalsIgnoreCase(mode) ? Executors.newFixedThreadPool(pConfig.getThreadNr(), this.daemonThreadFactory) : ("cached".equalsIgnoreCase(mode) ? Executors.newCachedThreadPool(this.daemonThreadFactory) : Executors.newSingleThreadExecutor(this.daemonThreadFactory));
        server.setExecutor(executor);
        return server;
    }

    private HttpServer createHttpsServer(InetSocketAddress pSocketAddress, JolokiaServerConfig pConfig) {
        try {
            HttpsServer server = HttpsServer.create(pSocketAddress, pConfig.getBacklog());
            SSLContext sslContext = SSLContext.getInstance(pConfig.getSecureSocketProtocol());
            KeyStore ks = this.getKeyStore(pConfig);
            KeyManagerFactory kmf = this.getKeyManagerFactory(pConfig);
            kmf.init(ks, pConfig.getKeystorePassword());
            TrustManagerFactory tmf = this.getTrustManagerFactory(pConfig);
            tmf.init(ks);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            pConfig.updateHTTPSSettingsFromContext(sslContext);
            server.setHttpsConfigurator(new JolokiaHttpsConfigurator(sslContext, pConfig));
            return server;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Cannot use keystore for https communication: " + e, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot open keystore for https communication: " + e, e);
        }
    }

    private TrustManagerFactory getTrustManagerFactory(JolokiaServerConfig pConfig) throws NoSuchAlgorithmException {
        String algo = pConfig.getTrustManagerAlgorithm();
        return TrustManagerFactory.getInstance(algo != null ? algo : TrustManagerFactory.getDefaultAlgorithm());
    }

    private KeyManagerFactory getKeyManagerFactory(JolokiaServerConfig pConfig) throws NoSuchAlgorithmException {
        String algo = pConfig.getKeyManagerAlgorithm();
        return KeyManagerFactory.getInstance(algo != null ? algo : KeyManagerFactory.getDefaultAlgorithm());
    }

    private KeyStore getKeyStore(JolokiaServerConfig pConfig) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, InvalidKeySpecException, InvalidKeyException, NoSuchProviderException, SignatureException {
        char[] password = pConfig.getKeystorePassword();
        String keystoreFile = pConfig.getKeystore();
        KeyStore keystore = KeyStore.getInstance(pConfig.getKeyStoreType());
        if (keystoreFile != null) {
            this.loadKeyStoreFromFile(keystore, keystoreFile, password);
        } else {
            keystore.load(null);
            this.updateKeyStoreFromPEM(keystore, pConfig);
            if (pConfig.getServerCert() == null) {
                KeyStoreUtil.updateWithSelfSignedServerCertificate(keystore);
            }
        }
        return keystore;
    }

    private void updateKeyStoreFromPEM(KeyStore keystore, JolokiaServerConfig pConfig) throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, InvalidKeySpecException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (pConfig.getCaCert() != null) {
            File caCert = this.getAndValidateFile(pConfig.getCaCert(), "CA cert");
            KeyStoreUtil.updateWithCaPem(keystore, caCert);
        } else if (pConfig.useSslClientAuthentication()) {
            throw new IllegalArgumentException("Cannot use client cert authentication if no CA is given with 'caCert'");
        }
        if (pConfig.getServerCert() != null) {
            File serverCert = this.getAndValidateFile(pConfig.getServerCert(), "server cert");
            if (pConfig.getServerKey() == null) {
                throw new IllegalArgumentException("Cannot use server cert from " + pConfig.getServerCert() + " without a provided a key given with 'serverKey'");
            }
            File serverKey = this.getAndValidateFile(pConfig.getServerKey(), "server key");
            KeyStoreUtil.updateWithServerPems(keystore, serverCert, serverKey, pConfig.getServerKeyAlgorithm(), pConfig.getKeystorePassword());
        }
    }

    private File getAndValidateFile(String pFile, String pWhat) throws IOException {
        File ret = new File(pFile);
        if (!ret.exists()) {
            throw new FileNotFoundException("No such " + pWhat + " " + pFile);
        }
        if (!ret.canRead()) {
            throw new IOException(pWhat.substring(0, 1).toUpperCase() + pWhat.substring(1) + " " + pFile + " is not readable");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyStoreFromFile(KeyStore pKeyStore, String pFile, char[] pPassword) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.getAndValidateFile(pFile, "keystore"));
            pKeyStore.load(fis, pPassword);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public InetSocketAddress getAddress() {
        return this.serverAddress;
    }

    private static final class JolokiaHttpsConfigurator
    extends HttpsConfigurator {
        private JolokiaServerConfig serverConfig;
        private SSLContext context;

        private JolokiaHttpsConfigurator(SSLContext pSSLContext, JolokiaServerConfig pConfig) {
            super(pSSLContext);
            this.context = pSSLContext;
            this.serverConfig = pConfig;
        }

        @Override
        public void configure(HttpsParameters params) {
            SSLEngine engine = this.context.createSSLEngine();
            SSLParameters defaultSSLParameters = this.context.getDefaultSSLParameters();
            params.setWantClientAuth(this.serverConfig.useSslClientAuthentication());
            defaultSSLParameters.setWantClientAuth(this.serverConfig.useSslClientAuthentication());
            params.setCipherSuites(this.serverConfig.getSSLCipherSuites());
            defaultSSLParameters.setCipherSuites(this.serverConfig.getSSLCipherSuites());
            params.setProtocols(this.serverConfig.getSSLProtocols());
            defaultSSLParameters.setProtocols(this.serverConfig.getSSLProtocols());
            params.setSSLParameters(defaultSSLParameters);
        }
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

