/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.RuntimeMBeanException;
import org.jolokia.backend.BackendManager;
import org.jolokia.config.ConfigKey;
import org.jolokia.config.Configuration;
import org.jolokia.http.HttpRequestHandler;
import org.jolokia.jvmagent.ParsedUri;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.DenyAllRestrictor;
import org.jolokia.restrictor.PolicyRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.RestrictorFactory;
import org.jolokia.util.ClassUtil;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class JolokiaHttpHandler
implements HttpHandler {
    private BackendManager backendManager;
    private HttpRequestHandler requestHandler;
    private String context;
    private Pattern contentTypePattern = Pattern.compile(".*;\\s*charset=([^;,]+)\\s*.*");
    private Configuration configuration;
    private final SimpleDateFormat rfc1123Format;
    private final LogHandler logHandler;

    public JolokiaHttpHandler(Configuration pConfig) {
        this(pConfig, null);
    }

    public JolokiaHttpHandler(Configuration pConfig, LogHandler pLogHandler) {
        this.configuration = pConfig;
        this.context = pConfig.get(ConfigKey.AGENT_CONTEXT);
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.rfc1123Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        this.rfc1123Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.logHandler = pLogHandler != null ? pLogHandler : this.createLogHandler(pConfig.get(ConfigKey.LOGHANDLER_CLASS));
    }

    public void start(boolean pLazy) {
        this.backendManager = new BackendManager(this.configuration, this.logHandler, this.createRestrictor(this.configuration), pLazy);
        this.requestHandler = new HttpRequestHandler(this.configuration, this.backendManager, this.logHandler);
    }

    public void stop() {
        this.backendManager.destroy();
        this.backendManager = null;
        this.requestHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange pExchange) throws IOException {
        ParsedUri parsedUri;
        JSONObject json;
        block11: {
            if (this.requestHandler == null) {
                throw new IllegalStateException("Handler not yet started");
            }
            json = null;
            URI uri = pExchange.getRequestURI();
            parsedUri = new ParsedUri(uri, this.context);
            try {
                InetSocketAddress address = pExchange.getRemoteAddress();
                this.requestHandler.checkClientIPAccess(address.getHostName(), address.getAddress().getHostAddress());
                String method = pExchange.getRequestMethod();
                if ("GET".equalsIgnoreCase(method)) {
                    this.setHeaders(pExchange);
                    json = this.executeGetRequest(parsedUri);
                } else if ("POST".equalsIgnoreCase(method)) {
                    this.setHeaders(pExchange);
                    json = this.executePostRequest(pExchange, parsedUri);
                } else if ("OPTIONS".equalsIgnoreCase(method)) {
                    this.performCorsPreflightCheck(pExchange);
                } else {
                    throw new IllegalArgumentException("HTTP Method " + method + " is not supported.");
                }
                if (!this.backendManager.isDebug()) break block11;
                this.backendManager.info("Response: " + json);
            }
            catch (Throwable exp) {
                try {
                    json = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
                }
                catch (Throwable throwable) {
                    this.sendResponse(pExchange, parsedUri, (JSONAware)json);
                    throw throwable;
                }
                this.sendResponse(pExchange, parsedUri, (JSONAware)json);
            }
        }
        this.sendResponse(pExchange, parsedUri, (JSONAware)json);
    }

    private Restrictor createRestrictor(Configuration pConfig) {
        String location = pConfig.get(ConfigKey.POLICY_LOCATION);
        try {
            PolicyRestrictor ret = RestrictorFactory.lookupPolicyRestrictor((String)location);
            if (ret != null) {
                this.logHandler.info("Using access restrictor " + location);
                return ret;
            }
            this.logHandler.info("No access restrictor found, access to all MBean is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            this.logHandler.error("Error while accessing access restrictor at " + location + ". Denying all access to MBeans for security reasons. Exception: " + e, (Throwable)e);
            return new DenyAllRestrictor();
        }
    }

    private JSONAware executeGetRequest(ParsedUri parsedUri) {
        return this.requestHandler.handleGetRequest(parsedUri.getUri().toString(), parsedUri.getPathInfo(), parsedUri.getParameterMap());
    }

    private JSONAware executePostRequest(HttpExchange pExchange, ParsedUri pUri) throws MalformedObjectNameException, IOException {
        Matcher matcher;
        String encoding = null;
        Headers headers = pExchange.getRequestHeaders();
        String cType = headers.getFirst("Content-Type");
        if (cType != null && (matcher = this.contentTypePattern.matcher(cType)).matches()) {
            encoding = matcher.group(1);
        }
        InputStream is = pExchange.getRequestBody();
        return this.requestHandler.handlePostRequest(pUri.toString(), is, encoding, pUri.getParameterMap());
    }

    private void performCorsPreflightCheck(HttpExchange pExchange) {
        Headers requestHeaders = pExchange.getRequestHeaders();
        Map respHeaders = this.requestHandler.handleCorsPreflightRequest(requestHeaders.getFirst("Origin"), requestHeaders.getFirst("Access-Control-Request-Headers"));
        Headers responseHeaders = pExchange.getResponseHeaders();
        for (Map.Entry entry : respHeaders.entrySet()) {
            responseHeaders.set((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private void setHeaders(HttpExchange pExchange) {
        String origin = this.requestHandler.extractCorsOrigin(pExchange.getRequestHeaders().getFirst("Origin"));
        Headers headers = pExchange.getResponseHeaders();
        if (origin != null) {
            headers.set("Access-Control-Allow-Origin", origin);
            headers.set("Access-Control-Allow-Credentials", "true");
        }
        headers.set("Cache-Control", "no-cache");
        headers.set("Pragma", "no-cache");
        Calendar cal = Calendar.getInstance();
        headers.set("Date", this.rfc1123Format.format(cal.getTime()));
        cal.add(10, -1);
        headers.set("Expires", this.rfc1123Format.format(cal.getTime()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpExchange pExchange, ParsedUri pParsedUri, JSONAware pJson) throws IOException {
        OutputStream out = null;
        try {
            Headers headers = pExchange.getResponseHeaders();
            if (pJson != null) {
                headers.set("Content-Type", this.getMimeType(pParsedUri) + "; charset=utf-8");
                String json = pJson.toJSONString();
                String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
                String content = callback == null ? json : callback + "(" + json + ");";
                byte[] response = content.getBytes();
                pExchange.sendResponseHeaders(200, response.length);
                out = pExchange.getResponseBody();
                out.write(response);
            } else {
                headers.set("Content-Type", "text/plain");
                pExchange.sendResponseHeaders(200, -1L);
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private String getMimeType(ParsedUri pParsedUri) {
        if (pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue()) != null) {
            return "text/javascript";
        }
        String mimeType = pParsedUri.getParameter(ConfigKey.MIME_TYPE.getKeyValue());
        if (mimeType != null) {
            return mimeType;
        }
        mimeType = this.configuration.get(ConfigKey.MIME_TYPE);
        return mimeType != null ? mimeType : ConfigKey.MIME_TYPE.getDefaultValue();
    }

    private LogHandler createLogHandler(String pLogHandlerClass) {
        if (pLogHandlerClass != null) {
            return (LogHandler)ClassUtil.newInstance((String)pLogHandlerClass);
        }
        return new LogHandler(){

            public final void debug(String message) {
                System.err.println("DEBUG: " + message);
            }

            public final void info(String message) {
                System.err.println("INFO: " + message);
            }

            public final void error(String message, Throwable t) {
                System.err.println("ERROR: " + message);
            }
        };
    }
}

