/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.EscapeUtil;

public class ServerConfig {
    private Map<String, String> agentConfig;
    private Map<ConfigKey, String> jolokiaConfig;
    private boolean isStopMode;
    private String protocol;
    private int port;
    private int backlog;
    private InetAddress address;
    private String executor;
    private int threadNr;
    private String keystore;
    private String context;

    public ServerConfig(String pArgs) {
        this.agentConfig = this.parseArgs(pArgs);
        this.jolokiaConfig = ConfigKey.extractConfig(this.agentConfig);
        this.initialiseAndValidate();
    }

    public Map<ConfigKey, String> getJolokiaConfig() {
        return this.jolokiaConfig;
    }

    public boolean isModeStop() {
        return this.isStopMode;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String getUser() {
        return this.jolokiaConfig.get(ConfigKey.USER);
    }

    public String getPassword() {
        return this.jolokiaConfig.get(ConfigKey.PASSWORD);
    }

    public int getBacklog() {
        return this.backlog;
    }

    public String getContextPath() {
        return this.context;
    }

    public String getExecutor() {
        return this.executor;
    }

    public int getThreadNr() {
        return this.threadNr;
    }

    public boolean useClientAuthentication() {
        String auth = this.agentConfig.get("useSslClientAuthentication");
        return auth != null && Boolean.getBoolean(auth);
    }

    public String getKeystore() {
        return this.keystore;
    }

    public char[] getKeystorePassword() {
        String password = this.agentConfig.get("keystorePassword");
        return password != null ? password.toCharArray() : new char[]{};
    }

    private void initialiseAndValidate() {
        this.initMode();
        this.initContext();
        this.initProtocol();
        this.initAddress();
        this.port = Integer.parseInt(this.agentConfig.get("port"));
        this.backlog = Integer.parseInt(this.agentConfig.get("backlog"));
        this.initExecutor();
        this.initThreadNr();
        this.initKeystore();
    }

    private void initMode() {
        String mode = this.agentConfig.get("mode");
        if (mode != null && !mode.equals("start") && !mode.equals("stop")) {
            throw new IllegalArgumentException("Invalid running mode '" + mode + "'. Must be either 'start' or 'stop'");
        }
        this.isStopMode = "stop".equals(mode);
    }

    private void initProtocol() {
        String string = this.protocol = this.agentConfig.containsKey("protocol") ? this.agentConfig.get("protocol") : "http";
        if (!this.protocol.equals("http") && !this.protocol.equals("https")) {
            throw new IllegalArgumentException("Invalid protocol '" + this.protocol + "'. Must be either 'http' or 'https'");
        }
    }

    private void initContext() {
        this.context = this.jolokiaConfig.get(ConfigKey.AGENT_CONTEXT);
        if (this.context == null) {
            this.context = ConfigKey.AGENT_CONTEXT.getDefaultValue();
        }
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
    }

    private void initKeystore() {
        this.keystore = this.agentConfig.get("keystore");
        if (this.protocol.equals("https") && this.keystore == null) {
            throw new IllegalArgumentException("No keystore defined for HTTPS protocol. Please use the 'keystore' option to point to a valid keystore");
        }
    }

    private void initThreadNr() {
        String threadNrS = this.agentConfig.get("threadNr");
        this.threadNr = threadNrS != null ? Integer.parseInt(threadNrS) : 5;
    }

    private void initExecutor() {
        String string = this.executor = this.agentConfig.containsKey("executor") ? this.agentConfig.get("executor") : "single";
        if (!("single".equalsIgnoreCase(this.executor) || "fixed".equalsIgnoreCase(this.executor) || "cached".equalsIgnoreCase(this.executor))) {
            throw new IllegalArgumentException("Executor model can be '" + this.executor + "' but most be either 'single', 'fixed' or 'cached'");
        }
    }

    private void initAddress() {
        String host = this.agentConfig.get("host");
        try {
            this.address = host != null ? InetAddress.getByName(host) : InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Can not lookup " + (host != null ? host : "localhost") + ": " + e, e);
        }
    }

    private Map<String, String> parseArgs(String pAgentArgs) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pAgentArgs != null && pAgentArgs.length() > 0) {
            for (String arg : EscapeUtil.splitAsArray((String)pAgentArgs, (String)"\\\\", (String)",")) {
                String[] prop = EscapeUtil.splitAsArray((String)arg, (String)"\\\\", (String)"=");
                if (prop == null || prop.length != 2) {
                    throw new IllegalArgumentException("jolokia: Invalid option '" + arg + "'. Ignoring");
                }
                ret.put(prop[0], prop[1]);
            }
        }
        Map<String, String> config = this.getDefaultConfig();
        if (ret.containsKey("config")) {
            Map<String, String> userConfig = this.readConfig((String)ret.get("config"));
            config.putAll(userConfig);
            config.putAll(ret);
            return config;
        }
        config.putAll(ret);
        return config;
    }

    private Map<String, String> readConfig(String pFilename) {
        File file = new File(pFilename);
        try {
            FileInputStream is = new FileInputStream(file);
            return this.readPropertiesFromInputStream(is, pFilename);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("jolokia: Can not find configuration file " + pFilename, e);
        }
    }

    private Map<String, String> getDefaultConfig() {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("jolokia-agent.properties");
        return this.readPropertiesFromInputStream(is, "jolokia-agent.properties");
    }

    private Map<String, String> readPropertiesFromInputStream(InputStream pIs, String pLabel) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (pIs == null) {
            return ret;
        }
        Properties props = new Properties();
        try {
            props.load(pIs);
            ret.putAll(props);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("jolokia: Cannot load default properties " + pLabel + " : " + e, e);
        }
        return ret;
    }
}

