/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.jolokia.jvmagent.client.AgentLauncher;
import org.jolokia.jvmagent.client.OptionsAndArgs;
import org.jolokia.jvmagent.client.ProcessingException;

public class VirtualMachineHandler {
    private OptionsAndArgs options;

    public VirtualMachineHandler(OptionsAndArgs pOptions) {
        this.options = pOptions;
    }

    public Object attachVirtualMachine() {
        if (this.options.getPid() == null) {
            return null;
        }
        Class vmClass = this.lookupVirtualMachineClass();
        try {
            Method method = vmClass.getMethod("attach", String.class);
            return method.invoke(null, this.options.getPid());
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Internal: No method 'attach' found on " + vmClass, e, this.options);
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("InvocationTarget " + vmClass, e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("IllegalAccess to " + vmClass, e, this.options);
        }
    }

    public void detachAgent(Object pVm) {
        try {
            if (pVm != null) {
                Class<?> clazz = pVm.getClass();
                Method method = clazz.getMethod("detach", new Class[0]);
                method.invoke(pVm, new Object[0]);
            }
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("Error while detaching", e, this.options);
        }
    }

    public List<ProcessDesc> listProcesses() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ArrayList<ProcessDesc> ret = new ArrayList<ProcessDesc>();
        Class vmClass = this.lookupVirtualMachineClass();
        Method method = vmClass.getMethod("list", new Class[0]);
        List vmDescriptors = (List)method.invoke(null, new Object[0]);
        for (Object descriptor : vmDescriptors) {
            Method idMethod = descriptor.getClass().getMethod("id", new Class[0]);
            String id = (String)idMethod.invoke(descriptor, new Object[0]);
            Method displayMethod = descriptor.getClass().getMethod("displayName", new Class[0]);
            String display = (String)displayMethod.invoke(descriptor, new Object[0]);
            ret.add(new ProcessDesc(id, display));
        }
        return ret;
    }

    Class lookupVirtualMachineClass() {
        try {
            String vmClassName = "com.sun.tools.attach.VirtualMachine";
            try {
                return Class.forName(vmClassName);
            }
            catch (ClassNotFoundException exp) {
                return this.lookupInToolsJar(vmClassName);
            }
        }
        catch (Exception exp) {
            throw new ProcessingException("Cannot find classes from tools.jar. The heuristics for loading tools.jar which contains\nessential classes for attaching to a running JVM could locate the necessary jar file.\n\nPlease call this launcher with a qualified classpath on the command line like\n\n   java -cp path/to/tools.jar:" + this.options.getJarFileName() + " " + AgentLauncher.class.getName() + " [options] <command> <ppid>\n", exp, this.options);
        }
    }

    private Class lookupInToolsJar(String pVmClassName) throws MalformedURLException, ClassNotFoundException {
        String extraInfo;
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            File[] toolsJars;
            extraInfo = "JAVA_HOME is " + javaHome;
            for (File toolsJar : toolsJars = new File[]{new File(javaHome + "/../lib/tools.jar"), new File(javaHome + "/lib/tools.jar")}) {
                if (!toolsJar.exists()) continue;
                URLClassLoader loader = new URLClassLoader(new URL[]{toolsJar.toURI().toURL()}, AgentLauncher.class.getClassLoader());
                return loader.loadClass(pVmClassName);
            }
        } else {
            extraInfo = "No JAVA_HOME set";
        }
        throw new ClassNotFoundException("No tools.jar found (" + extraInfo + ")");
    }

    static class ProcessDesc {
        private String id;
        private String display;

        public ProcessDesc(String pId, String pDisplay) {
            this.id = pId;
            this.display = pDisplay;
        }

        public String getId() {
            return this.id;
        }

        public String getDisplay() {
            return this.display;
        }
    }
}

