/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client;

import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class OptionsAndArgs {
    private static final Map<String, String> SHORT_OPTS = new HashMap<String, String>();
    private static final Set<String> OPTIONS = new HashSet<String>(Arrays.asList("host", "port", "agentContext", "user", "password", "quiet!", "verbose!", "executor", "threadNr", "backlog", "protocol", "keystore", "keystorePassword", "useSslClientAuthentication!", "historyMaxEntries", "debug!", "debugMaxEntries", "dispatcherClasses", "maxDepth", "maxCollectionSize", "maxObjects", "policyLocation", "mbeanQualifier", "config", "help!"));
    private String command;
    private String pid;
    private Map<String, String> options = new HashMap<String, String>();
    private boolean quiet;
    private boolean verbose;
    private File jarFile;
    private static final Pattern ARGUMENT_PATTERN_WITH_EQUAL;

    public OptionsAndArgs(String ... pArgs) {
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < pArgs.length; ++i) {
            String arg = pArgs[i];
            if (arg.startsWith("-")) {
                ArgParsed argParsed = this.parseArgument(pArgs[i], i + 1 <= pArgs.length - 1 ? pArgs[i + 1] : null);
                if (argParsed.skipNext) {
                    ++i;
                }
                this.options.put(argParsed.option, argParsed.value);
                continue;
            }
            arguments.add(arg);
        }
        this.command = arguments.size() > 0 ? (String)arguments.get(0) : null;
        this.pid = arguments.size() > 1 ? (String)arguments.get(1) : null;
        this.quiet = this.options.containsKey("quiet");
        this.verbose = this.options.containsKey("verbose");
        this.jarFile = OptionsAndArgs.lookupJarFile();
        this.initCommand();
    }

    public String toAgentArg() {
        StringBuilder arg = new StringBuilder();
        for (Map.Entry<String, String> entry : this.options.entrySet()) {
            if (entry.getKey().equals("quiet") || entry.getKey().equals("verbose")) continue;
            arg.append(entry.getKey()).append("=").append(entry.getValue()).append(",");
        }
        return arg.length() > 0 ? arg.substring(0, arg.length() - 1) : "";
    }

    public String getPid() {
        return this.pid;
    }

    public String getCommand() {
        return this.command;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public String getJarFilePath() {
        return this.jarFile.getAbsolutePath();
    }

    public String getJarFileName() {
        return this.jarFile.getName();
    }

    private ArgParsed parseArgument(String pArg, String pNextArgument) {
        if (pArg.startsWith("--")) {
            String opt = pArg.substring(2);
            String value = null;
            Matcher matcher = ARGUMENT_PATTERN_WITH_EQUAL.matcher(opt);
            if (matcher.matches()) {
                opt = matcher.group(1);
                value = matcher.group(2);
            }
            if (OPTIONS.contains(opt)) {
                if (value == null && (pNextArgument == null || pNextArgument.startsWith("-"))) {
                    throw new IllegalArgumentException("Option '" + opt + "' requires an argument");
                }
                return value != null ? new ArgParsed(opt, value, false) : new ArgParsed(opt, pNextArgument, true);
            }
            if (OPTIONS.contains(opt + "!")) {
                return new ArgParsed(opt, "true", false);
            }
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
        String opt = pArg.substring(1);
        String longOpt = SHORT_OPTS.get(opt);
        if (longOpt == null) {
            throw new IllegalArgumentException("No short option '" + opt + "' known");
        }
        return this.parseArgument("--" + longOpt, pNextArgument);
    }

    private void initCommand() {
        if (this.options.containsKey("help")) {
            this.command = "help";
        } else if (this.command != null && this.pid == null && this.command.matches("^[0-9]+$")) {
            this.pid = this.command;
            this.command = "toggle";
        } else if (this.command == null && this.pid == null) {
            this.command = "list";
        } else if (!"list".equals(this.command)) {
            if (this.pid == null) {
                throw new IllegalArgumentException("No process id (PID) given");
            }
            if (!this.pid.matches("^[0-9]+$")) {
                throw new IllegalArgumentException("Process id (PID) is not numeric");
            }
        }
    }

    static File lookupJarFile() {
        try {
            return new File(OptionsAndArgs.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Error: Cannot lookup jar for this class: " + e, e);
        }
    }

    static {
        String[] shortOptsDef = new String[]{"h", "help", "u", "user", "p", "password", "c", "agentContext", "v", "verbose", "q", "quiet"};
        for (int i = 0; i < shortOptsDef.length; i += 2) {
            SHORT_OPTS.put(shortOptsDef[i], shortOptsDef[i + 1]);
        }
        ARGUMENT_PATTERN_WITH_EQUAL = Pattern.compile("([^=]+)=(.*)");
    }

    private static final class ArgParsed {
        private boolean skipNext;
        private String option;
        private String value;

        private ArgParsed(String pOption, String pValue, boolean pSkipNext) {
            this.skipNext = pSkipNext;
            this.option = pOption;
            this.value = pValue;
        }
    }
}

