/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent.client;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Formatter;
import java.util.List;
import java.util.Properties;
import org.jolokia.jvmagent.client.OptionsAndArgs;
import org.jolokia.jvmagent.client.ProcessingException;
import org.jolokia.jvmagent.client.VirtualMachineHandler;
import org.jolokia.util.ConfigKey;

public class CommandDispatcher {
    private OptionsAndArgs options;

    CommandDispatcher(OptionsAndArgs pOptions) {
        this.options = pOptions;
    }

    public int dispatchCommand(Object pVm, VirtualMachineHandler pHandler) {
        String command = this.options.getCommand();
        try {
            int rc = 0;
            if ("help".equals(command)) {
                CommandDispatcher.printHelp(this.options.getJarFileName());
            } else if ("start".equals(command)) {
                rc = this.commandStart(pVm);
            } else {
                if ("status".equals(command)) {
                    return this.commandStatus(pVm);
                }
                if ("stop".equals(command)) {
                    return this.commandStop(pVm);
                }
                if ("toggle".equals(command)) {
                    return this.commandToggle(pVm);
                }
                if ("list".equals(command)) {
                    this.listProcesses(pHandler);
                } else {
                    throw new IllegalArgumentException("Unknown command '" + command + "'");
                }
            }
            return rc;
        }
        catch (InvocationTargetException e) {
            throw new ProcessingException("InvocationTargetException for command '" + command + "'", e, this.options);
        }
        catch (NoSuchMethodException e) {
            throw new ProcessingException("Internal: NoSuchMethod for command '" + command + "'", e, this.options);
        }
        catch (IllegalAccessException e) {
            throw new ProcessingException("IllegalAccess for command '" + command + "'", e, this.options);
        }
    }

    private void listProcesses(VirtualMachineHandler pHandler) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        List<VirtualMachineHandler.ProcessDesc> vmDescriptors = pHandler.listProcesses();
        for (VirtualMachineHandler.ProcessDesc descriptor : vmDescriptors) {
            System.out.println(new Formatter().format("%7.7s   %-100.100s", descriptor.getId(), descriptor.getDisplay()));
        }
    }

    private int commandStart(Object pVm) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String agentUrl = this.checkAgentUrl(pVm);
        boolean quiet = this.options.isQuiet();
        if (agentUrl == null) {
            String agent = this.options.getJarFilePath();
            this.loadAgent(pVm, agent, this.options.toAgentArg());
            if (!quiet) {
                System.out.println("Started Jolokia for PID " + this.options.getPid());
                System.out.println(this.checkAgentUrl(pVm));
            }
            return 0;
        }
        if (!quiet) {
            System.out.println("Jolokia already attached to " + this.options.getPid());
            System.out.println(agentUrl);
        }
        return 1;
    }

    private int commandStop(Object pVm) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String agentUrl = this.checkAgentUrl(pVm);
        boolean quiet = this.options.isQuiet();
        if (agentUrl != null) {
            String agent = this.options.getJarFilePath();
            String agentOpts = this.options.toAgentArg();
            this.loadAgent(pVm, agent, agentOpts.length() != 0 ? agentOpts + ",mode=stop" : "mode=stop");
            if (!quiet) {
                System.out.println("Stopped Jolokia for PID " + this.options.getPid());
            }
            return 0;
        }
        if (!quiet) {
            System.out.println("Jolokia is not attached to PID " + this.options.getPid());
        }
        return 1;
    }

    private int commandStatus(Object pVm) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        String agentUrl = this.checkAgentUrl(pVm);
        boolean quiet = this.options.isQuiet();
        if (agentUrl != null) {
            if (!quiet) {
                System.out.println("Jolokia started for PID " + this.options.getPid());
                System.out.println(agentUrl);
            }
            return 0;
        }
        if (!quiet) {
            System.out.println("No Jolokia agent attached to PID " + this.options.getPid());
        }
        return 1;
    }

    private int commandToggle(Object pVm) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        return this.checkAgentUrl(pVm) == null ? this.commandStart(pVm) : this.commandStop(pVm);
    }

    private String checkAgentUrl(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Properties systemProperties = this.getAgentSystemProperties(pVm);
        return systemProperties.getProperty("jolokia.agent");
    }

    private void loadAgent(Object pVm, String pAgent, String pPid) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = pVm.getClass();
        Method method = clazz.getMethod("loadAgent", String.class, String.class);
        method.invoke(pVm, pAgent, pPid);
    }

    private Properties getAgentSystemProperties(Object pVm) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz = pVm.getClass();
        Method method = clazz.getMethod("getSystemProperties", new Class[0]);
        return (Properties)method.invoke(pVm, new Object[0]);
    }

    public static void printHelp(String jar) {
        System.out.println("Jolokia Agent Launcher\n======================\n\nUsage: java -jar " + jar + " [options] <command> <pid>\n" + "\n" + "where <command> is one of\n" + "    start     -- Start a Jolokia agent for the given process id\n" + "    stop      -- Stop a Jolokia agent for the given process id\n" + "    status    -- Show status of an (potentially) attached agent\n" + "    toggle    -- Toggle between start/stop (default when no command is given)\n" + "    list      -- List all attachable Java processes (default when no argument is given)\n" + "\n" + "[options] are used for providing runtime information for attaching the agent:\n" + "\n" + "    --host <host>                 Hostname or IP address to which to bind on\n" + "                                  (default: InetAddress.getLocalHost())\n" + "    --port <port>                 Port to listen on (default: 8778)\n" + "    --agentContext <context>      HTTP Context under which the agent is reachable (default: " + ConfigKey.AGENT_CONTEXT.getDefaultValue() + ")\n" + "    --user <user>                 User used for Basic-Authentication\n" + "    --password <password>         Password used for Basic-Authentication\n" + "    --quiet                       No output. \"status\" will exit with code 0 if the agent is running, 1 otherwise\n" + "    --verbose                     Verbose output\n" + "    --executor <executor>         Executor policy for HTTP Threads to use (default: single)\n" + "                                  \"fixed\"  -- Thread pool with a fixed number of threads (default: 5)\n" + "                                  \"cached\" -- Cached Thread Pool, creates threads on demand\n" + "                                  \"single\" -- Single Thread\n" + "    --threadNr <nr threads>       Number of fixed threads if \"fixed\" is used as executor\n" + "    --backlog <backlog>           How many request to keep in the backlog (default: 10)\n" + "    --protocol <http|https>       Protocol which must be either \"http\" or \"https\" (default: http)\n" + "    --keystore <keystore>         Path to keystore (https only)\n" + "    --keystorePassword <pwd>      Password to the keystore (https only)\n" + "    --useSslClientAuthentication  Use client certificate authentication (https only)\n" + "    --debug                       Switch on agent debugging\n" + "    --debugMaxEntries <nr>        Number of debug entries to keep in memory which can be fetched from the Jolokia MBean\n" + "    --maxDepth <depth>            Maximum number of levels for serialization of beans (default: " + ConfigKey.MAX_DEPTH.getDefaultValue() + ")\n" + "    --maxCollectionSize <size>    Maximum number of element in collections to keep when serializing the response (default: " + ConfigKey.MAX_COLLECTION_SIZE.getDefaultValue() + ")\n" + "    --maxObjects <nr>             Maximum number of objects to consider for serialization (default: " + ConfigKey.MAX_OBJECTS + ")\n" + "    --policyLocation <url>        Location of a Jolokia policy file\n" + "    --mbeanQualifier <qualifier>  Qualifier to use when registering Jolokia internal MBeans\n" + "    --config <configfile>         Path to a property file from where to read the configuration\n" + "    --help                        This help documentation\n" + "\n" + "If no <command> is given but only a <pid> the state of the Agent will be toggled\n" + "between \"start\" and \"stop\"\n" + "\n" + "If neither <command> nor <pid> is given, a list of Java processes along with their IDs\n" + "is printed\n" + "\n" + "For more information please visit www.jolokia.org");
    }
}

