/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.BasicAuthenticator;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.jolokia.jvmagent.CleanupThread;
import org.jolokia.jvmagent.JolokiaHttpHandler;
import org.jolokia.jvmagent.ServerConfig;

public class JolokiaServer {
    private ServerConfig config;
    private CleanupThread cleaner = null;
    private HttpServer httpServer;
    private String url;
    private JolokiaHttpHandler jolokiaHttpHandler;

    public JolokiaServer(ServerConfig pConfig) throws IOException {
        this.config = pConfig;
        this.initServer();
    }

    public void start() {
        this.jolokiaHttpHandler.start();
        ThreadGroup threadGroup = new ThreadGroup("jolokia");
        threadGroup.setDaemon(false);
        Thread starterThread = new Thread(threadGroup, new Runnable(){

            @Override
            public void run() {
                JolokiaServer.this.httpServer.start();
            }
        });
        starterThread.start();
        this.cleaner = new CleanupThread(this.httpServer, threadGroup);
        this.cleaner.start();
    }

    public void stop() {
        this.jolokiaHttpHandler.stop();
        if (this.cleaner != null) {
            this.cleaner.stopServer();
        }
    }

    public String getUrl() {
        return this.url;
    }

    private void initServer() throws IOException {
        int port = this.config.getPort();
        InetAddress address = this.config.getAddress();
        String protocol = this.config.getProtocol();
        InetSocketAddress socketAddress = new InetSocketAddress(address, port);
        this.httpServer = protocol.equalsIgnoreCase("https") ? this.createHttpsServer(socketAddress) : HttpServer.create(socketAddress, this.config.getBacklog());
        String contextPath = this.config.getContextPath();
        this.jolokiaHttpHandler = new JolokiaHttpHandler(this.config.getJolokiaConfig());
        HttpContext context = this.httpServer.createContext(contextPath, this.jolokiaHttpHandler);
        this.addAuthenticatorIfNeeded(this.config.getUser(), this.config.getPassword(), context);
        this.initializeExecutor();
        this.url = String.format("%s://%s:%d%s", protocol, address.getCanonicalHostName(), port, contextPath);
    }

    private void addAuthenticatorIfNeeded(String user, String password, HttpContext pContext) {
        if (user != null) {
            if (password == null) {
                throw new SecurityException("No password given for user " + user);
            }
            pContext.setAuthenticator(new JolokiaAuthenticator(user, password));
        }
    }

    private void initializeExecutor() {
        String mode = this.config.getExecutor();
        ExecutorService executor = "fixed".equalsIgnoreCase(mode) ? Executors.newFixedThreadPool(this.config.getThreadNr()) : ("cached".equalsIgnoreCase(mode) ? Executors.newCachedThreadPool() : Executors.newSingleThreadExecutor());
        this.httpServer.setExecutor(executor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServer createHttpsServer(InetSocketAddress pSocketAddress) {
        try {
            HttpsServer server = HttpsServer.create(pSocketAddress, this.config.getBacklog());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            char[] password = this.config.getKeystorePassword();
            KeyStore ks = KeyStore.getInstance("JKS");
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(this.config.getKeystore());
                ks.load(fis, password);
            }
            finally {
                if (fis != null) {
                    fis.close();
                }
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
            tmf.init(ks);
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            server.setHttpsConfigurator(new JolokiaHttpsConfigurator(sslContext, this.config.useClientAuthentication()));
            return server;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Cannot use keystore for https communication: " + e, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot open keystore for https communication: " + e, e);
        }
    }

    private static final class JolokiaHttpsConfigurator
    extends HttpsConfigurator {
        private boolean useClientAuthentication;

        private JolokiaHttpsConfigurator(SSLContext pSSLContext, boolean pUseClientAuthenication) {
            super(pSSLContext);
            this.useClientAuthentication = pUseClientAuthenication;
        }

        @Override
        public void configure(HttpsParameters params) {
            try {
                SSLContext context = SSLContext.getDefault();
                SSLEngine engine = context.createSSLEngine();
                params.setNeedClientAuth(this.useClientAuthentication);
                params.setCipherSuites(engine.getEnabledCipherSuites());
                params.setProtocols(engine.getEnabledProtocols());
                params.setSSLParameters(context.getDefaultSSLParameters());
            }
            catch (NoSuchAlgorithmException e) {
                throw new IllegalArgumentException("jolokia: Exception while configuring SSL context: " + e, e);
            }
        }
    }

    private static class JolokiaAuthenticator
    extends BasicAuthenticator {
        private String user;
        private String password;

        JolokiaAuthenticator(String pUser, String pPassword) {
            super("jolokia");
            this.user = pUser;
            this.password = pPassword;
        }

        @Override
        public boolean checkCredentials(String pUserGiven, String pPasswordGiven) {
            return this.user.equals(pUserGiven) && this.password.equals(pPasswordGiven);
        }
    }
}

