/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jvmagent;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import javax.management.RuntimeMBeanException;
import org.jolokia.backend.BackendManager;
import org.jolokia.http.HttpRequestHandler;
import org.jolokia.jvmagent.ParsedUri;
import org.jolokia.restrictor.AllowAllRestrictor;
import org.jolokia.restrictor.DenyAllRestrictor;
import org.jolokia.restrictor.PolicyRestrictor;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.restrictor.RestrictorFactory;
import org.jolokia.util.ConfigKey;
import org.jolokia.util.LogHandler;
import org.json.simple.JSONAware;
import org.json.simple.JSONObject;

public class JolokiaHttpHandler
implements HttpHandler,
LogHandler {
    private BackendManager backendManager;
    private HttpRequestHandler requestHandler;
    private String context;
    private Pattern contentTypePattern = Pattern.compile(".*;\\s*charset=([^;,]+)\\s*.*");
    private Map<ConfigKey, String> configuration;

    public JolokiaHttpHandler(Map<ConfigKey, String> pConfig) {
        this.configuration = pConfig;
        this.context = pConfig.get(ConfigKey.AGENT_CONTEXT);
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
    }

    public void start() {
        this.backendManager = new BackendManager(this.configuration, (LogHandler)this, this.createRestrictor(this.configuration));
        this.requestHandler = new HttpRequestHandler(this.backendManager, (LogHandler)this);
    }

    public void stop() {
        this.backendManager.destroy();
        this.backendManager = null;
        this.requestHandler = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(HttpExchange pExchange) throws IOException {
        if (this.requestHandler == null) {
            throw new IllegalStateException("Handler not yet started");
        }
        JSONObject json = null;
        URI uri = pExchange.getRequestURI();
        ParsedUri parsedUri = new ParsedUri(uri, this.context);
        try {
            InetSocketAddress address = pExchange.getRemoteAddress();
            this.requestHandler.checkClientIPAccess(address.getHostName(), address.getAddress().getHostAddress());
            String method = pExchange.getRequestMethod();
            if ("GET".equalsIgnoreCase(method)) {
                json = this.executeGetRequest(parsedUri);
            } else if ("POST".equalsIgnoreCase(method)) {
                json = this.executePostRequest(pExchange, parsedUri);
            } else {
                throw new IllegalArgumentException("HTTP Method " + method + " is not supported.");
            }
            if (this.backendManager.isDebug()) {
                this.backendManager.info("Response: " + json);
            }
        }
        catch (Throwable exp) {
            JSONObject error;
            json = error = this.requestHandler.handleThrowable(exp instanceof RuntimeMBeanException ? ((RuntimeMBeanException)exp).getTargetException() : exp);
        }
        finally {
            this.sendResponse(pExchange, parsedUri, json.toJSONString());
        }
    }

    private Restrictor createRestrictor(Map<ConfigKey, String> pConfig) {
        String location = ConfigKey.POLICY_LOCATION.getValue(pConfig);
        try {
            PolicyRestrictor ret = RestrictorFactory.lookupPolicyRestrictor((String)location);
            if (ret != null) {
                this.info("Using access restrictor " + location);
                return ret;
            }
            this.info("No access restrictor found, access to all MBean is allowed");
            return new AllowAllRestrictor();
        }
        catch (IOException e) {
            this.error("Error while accessing access restrictor at " + location + ". Denying all access to MBeans for security reasons. Exception: " + e, e);
            return new DenyAllRestrictor();
        }
    }

    private JSONAware executeGetRequest(ParsedUri parsedUri) {
        return this.requestHandler.handleGetRequest(parsedUri.getUri().toString(), parsedUri.getPathInfo(), parsedUri.getParameterMap());
    }

    private JSONAware executePostRequest(HttpExchange pExchange, ParsedUri pUri) throws MalformedObjectNameException, IOException {
        Matcher matcher;
        String encoding = null;
        Headers headers = pExchange.getRequestHeaders();
        String cType = headers.getFirst("Content-Type");
        if (cType != null && (matcher = this.contentTypePattern.matcher(cType)).matches()) {
            encoding = matcher.group(1);
        }
        InputStream is = pExchange.getRequestBody();
        return this.requestHandler.handlePostRequest(pUri.toString(), is, encoding, pUri.getParameterMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResponse(HttpExchange pExchange, ParsedUri pParsedUri, String pJson) throws IOException {
        OutputStream out = null;
        String callback = pParsedUri.getParameter(ConfigKey.CALLBACK.getKeyValue());
        try {
            Headers headers = pExchange.getResponseHeaders();
            headers.set("Content-Type", (callback == null ? "text/plain" : "text/javascript") + "; charset=utf-8");
            String content = callback == null ? pJson : callback + "(" + pJson + ");";
            byte[] response = content.getBytes();
            pExchange.sendResponseHeaders(200, response.length);
            out = pExchange.getResponseBody();
            out.write(response);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    public final void debug(String message) {
        System.err.println("DEBUG: " + message);
    }

    public final void info(String message) {
        System.err.println("INFO: " + message);
    }

    public final void error(String message, Throwable t) {
        System.err.println("ERROR: " + message);
    }
}

