/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jsr160;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jolokia.backend.RequestDispatcher;
import org.jolokia.backend.executor.MBeanServerExecutor;
import org.jolokia.converter.Converters;
import org.jolokia.detector.ServerHandle;
import org.jolokia.handler.JsonRequestHandler;
import org.jolokia.handler.RequestHandlerManager;
import org.jolokia.jsr160.MBeanServerExecutorRemote;
import org.jolokia.request.JmxRequest;
import org.jolokia.request.ProxyTargetConfig;
import org.jolokia.restrictor.Restrictor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jsr160RequestDispatcher
implements RequestDispatcher {
    private RequestHandlerManager requestHandlerManager;

    public Jsr160RequestDispatcher(Converters pConverters, ServerHandle serverInfo, Restrictor restrictor) {
        this.requestHandlerManager = new RequestHandlerManager(pConverters, serverInfo, restrictor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object dispatchRequest(JmxRequest pJmxReq) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException, IOException {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxReq.getType());
        JMXConnector connector = this.getConnector(pJmxReq);
        try {
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            if (handler.handleAllServersAtOnce(pJmxReq)) {
                MBeanServerExecutorRemote manager = new MBeanServerExecutorRemote(connection);
                Object object = handler.handleRequest((MBeanServerExecutor)manager, pJmxReq);
                return object;
            }
            Object object = handler.handleRequest(connection, pJmxReq);
            return object;
        }
        finally {
            this.releaseConnector(connector);
        }
    }

    private JMXConnector getConnector(JmxRequest pJmxReq) throws IOException {
        ProxyTargetConfig targetConfig = pJmxReq.getTargetConfig();
        if (targetConfig == null) {
            throw new IllegalArgumentException("No proxy configuration in request " + pJmxReq);
        }
        String urlS = targetConfig.getUrl();
        JMXServiceURL url = new JMXServiceURL(urlS);
        Map<String, Object> env = this.prepareEnv(targetConfig.getEnv());
        JMXConnector ret = JMXConnectorFactory.newJMXConnector(url, env);
        ret.connect();
        return ret;
    }

    private void releaseConnector(JMXConnector pConnector) throws IOException {
        pConnector.close();
    }

    protected Map<String, Object> prepareEnv(Map<String, String> pTargetConfig) {
        if (pTargetConfig == null || pTargetConfig.size() == 0) {
            return null;
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(pTargetConfig);
        String user = (String)ret.remove("user");
        String password = (String)ret.remove("password");
        if (user != null && password != null) {
            ret.put("java.naming.security.principal", user);
            ret.put("java.naming.security.credentials", password);
            ret.put("jmx.remote.credentials", new String[]{user, password});
        }
        return ret;
    }

    public boolean canHandle(JmxRequest pJmxRequest) {
        return pJmxRequest.getTargetConfig() != null;
    }

    public boolean useReturnValueWithPath(JmxRequest pJmxRequest) {
        JsonRequestHandler handler = this.requestHandlerManager.getRequestHandler(pJmxRequest.getType());
        return handler.useReturnValueWithPath();
    }
}

