/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jmx;

import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBean;
import javax.management.openmbean.OpenType;
import org.jolokia.converter.Converters;
import org.jolokia.converter.json.JsonConvertOptions;
import org.jolokia.converter.json.ValueFaultHandler;
import org.jolokia.jmx.JsonDynamicMBeanImpl;
import org.jolokia.jmx.JsonMBean;
import org.jolokia.jmx.MBeanServerProxy;

class JolokiaMBeanServer
extends MBeanServerProxy {
    private MBeanServer delegateServer;
    private Set<ObjectName> delegatedMBeans;
    private Converters converters;

    public JolokiaMBeanServer() {
        MBeanServer mBeanServer = MBeanServerFactory.newMBeanServer();
        this.delegatedMBeans = new HashSet<ObjectName>();
        this.delegateServer = ManagementFactory.getPlatformMBeanServer();
        this.converters = new Converters();
        this.init(mBeanServer);
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        ObjectInstance ret = super.registerMBean(object, name);
        JsonMBean anno = this.extractJsonMBeanAnnotation(object);
        if (anno != null) {
            ObjectName realName = ret.getObjectName();
            try {
                MBeanInfo info = super.getMBeanInfo(realName);
                JsonDynamicMBeanImpl mbean = new JsonDynamicMBeanImpl(this, realName, info, this.getJsonConverterOptions(anno));
                this.delegatedMBeans.add(realName);
                this.delegateServer.registerMBean(mbean, realName);
            }
            catch (InstanceNotFoundException e) {
                throw new MBeanRegistrationException(e, "Cannot obtain MBeanInfo from Jolokia-Server for " + realName);
            }
            catch (IntrospectionException e) {
                throw new MBeanRegistrationException(e, "Cannot obtain MBeanInfo from Jolokia-Server for " + realName);
            }
            catch (ReflectionException e) {
                throw new MBeanRegistrationException(e, "Cannot obtain MBeanInfo from Jolokia-Server for " + realName);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonMBean extractJsonMBeanAnnotation(Object object) {
        JsonMBean anno;
        block11: {
            Class<?> clazz = object.getClass();
            anno = clazz.getAnnotation(JsonMBean.class);
            if (anno == null && ModelMBean.class.isAssignableFrom(object.getClass())) {
                Boolean isAccessible = null;
                Field field = null;
                try {
                    field = this.findField(clazz, "managedResource");
                    if (field != null) {
                        isAccessible = field.isAccessible();
                        field.setAccessible(true);
                        Object managedResource = field.get(object);
                        anno = managedResource.getClass().getAnnotation(JsonMBean.class);
                    }
                }
                catch (IllegalAccessException managedResource) {
                }
                catch (RuntimeException e) {
                    if (e.getClass().getName().equals("java.lang.reflect.InaccessibleObjectException")) {
                        isAccessible = null;
                        break block11;
                    }
                    throw e;
                }
                finally {
                    if (isAccessible != null) {
                        field.setAccessible(isAccessible);
                    }
                }
            }
        }
        return anno;
    }

    private Field findField(Class<?> pClazz, String pField) {
        Class<?> c = pClazz;
        while (true) {
            try {
                return c.getDeclaredField(pField);
            }
            catch (NoSuchFieldException e) {
                if ((c = pClazz.getSuperclass()) != null) continue;
                return null;
            }
            break;
        }
    }

    @Override
    public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        super.unregisterMBean(name);
        if (this.delegatedMBeans.contains(name)) {
            this.delegatedMBeans.remove(name);
            this.delegateServer.unregisterMBean(name);
        }
    }

    String toJson(Object object, JsonConvertOptions pConvertOptions) {
        try {
            Object ret = this.converters.getToJsonConverter().convertToJson(object, null, pConvertOptions);
            return ret.toString();
        }
        catch (AttributeNotFoundException exp) {
            return "";
        }
    }

    Object fromJson(String type, String json) {
        return this.converters.getToObjectConverter().convertFromString(type, json);
    }

    Object fromJson(OpenType type, String json) {
        return this.converters.getToOpenTypeConverter().convertToObject(type, (Object)json);
    }

    private JsonConvertOptions getJsonConverterOptions(JsonMBean pAnno) {
        if (pAnno == null) {
            return JsonConvertOptions.DEFAULT;
        }
        ValueFaultHandler faultHandler = pAnno.faultHandling() == JsonMBean.FaultHandler.IGNORE_ERRORS ? ValueFaultHandler.IGNORING_VALUE_FAULT_HANDLER : ValueFaultHandler.THROWING_VALUE_FAULT_HANDLER;
        return new JsonConvertOptions.Builder().maxCollectionSize(pAnno.maxCollectionSize()).maxDepth(pAnno.maxDepth()).maxObjects(pAnno.maxObjects()).faultHandler(faultHandler).build();
    }
}

