/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.jmx;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.JMException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jolokia.jmx.JolokiaMBeanServerHolder;

public final class JolokiaMBeanServerUtil {
    public static final String JOLOKIA_MBEAN_SERVER_ATTRIBUTE = "JolokiaMBeanServer";

    private JolokiaMBeanServerUtil() {
    }

    public static MBeanServer getJolokiaMBeanServer() {
        MBeanServer jolokiaMBeanServer;
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            jolokiaMBeanServer = (MBeanServer)server.getAttribute(JolokiaMBeanServerUtil.createObjectName("jolokia:type=MBeanServer"), JOLOKIA_MBEAN_SERVER_ATTRIBUTE);
        }
        catch (InstanceNotFoundException exp) {
            jolokiaMBeanServer = JolokiaMBeanServerUtil.registerJolokiaMBeanServerHolderMBean(server);
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal: Cannot get JolokiaMBean server via JMX lookup: " + e, e);
        }
        return jolokiaMBeanServer;
    }

    public static ObjectInstance registerMBean(Object object, ObjectName name) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return JolokiaMBeanServerUtil.getJolokiaMBeanServer().registerMBean(object, name);
    }

    public static void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException {
        JolokiaMBeanServerUtil.getJolokiaMBeanServer().unregisterMBean(name);
    }

    static MBeanServer registerJolokiaMBeanServerHolderMBean(MBeanServer pServer) {
        MBeanServer jolokiaMBeanServer;
        JolokiaMBeanServerHolder holder = new JolokiaMBeanServerHolder();
        ObjectName holderName = JolokiaMBeanServerUtil.createObjectName("jolokia:type=MBeanServer");
        try {
            pServer.registerMBean(holder, holderName);
            jolokiaMBeanServer = holder.getJolokiaMBeanServer();
        }
        catch (InstanceAlreadyExistsException e) {
            try {
                jolokiaMBeanServer = (MBeanServer)pServer.getAttribute(holderName, JOLOKIA_MBEAN_SERVER_ATTRIBUTE);
            }
            catch (JMException e1) {
                throw new IllegalStateException("Internal: Cannot get JolokiaMBean server in fallback JMX lookup while trying to register the holder MBean: " + e, e);
            }
        }
        catch (JMException e) {
            throw new IllegalStateException("Internal: JolokiaMBeanHolder cannot be registered to JMX: " + e, e);
        }
        return jolokiaMBeanServer;
    }

    private static ObjectName createObjectName(String pName) {
        try {
            return new ObjectName(pName);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name " + pName, e);
        }
    }
}

