/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.jmxadapter;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.exception.J4pBulkRemoteException;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.exception.UncheckedJmxAdapterException;
import org.jolokia.client.jmxadapter.ToOpenTypeConverter;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pListRequest;
import org.jolokia.client.request.J4pListResponse;
import org.jolokia.client.request.J4pQueryParameter;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.jolokia.client.request.J4pResponse;
import org.jolokia.client.request.J4pSearchRequest;
import org.jolokia.client.request.J4pSearchResponse;
import org.jolokia.client.request.J4pVersionRequest;
import org.jolokia.client.request.J4pVersionResponse;
import org.jolokia.client.request.J4pWriteRequest;
import org.jolokia.converter.Converters;
import org.jolokia.util.ClassUtil;
import org.json.simple.JSONObject;

public class RemoteJmxAdapter
implements MBeanServerConnection {
    private final J4pClient connector;
    private String agentId;
    private HashMap<J4pQueryParameter, String> defaultProcessingOptions;
    protected final Map<ObjectName, MBeanInfo> mbeanInfoCache = new HashMap<ObjectName, MBeanInfo>();
    String agentVersion;
    String protocolVersion;
    private static final Set<String> UNCHECKED_REMOTE_EXCEPTIONS = Collections.singleton("java.lang.UnsupportedOperationException");

    public RemoteJmxAdapter(J4pClient connector) throws IOException {
        this.connector = connector;
        try {
            J4pVersionResponse response = (J4pVersionResponse)this.unwrapExecute(new J4pVersionRequest());
            this.agentVersion = response.getAgentVersion();
            this.protocolVersion = response.getProtocolVersion();
            JSONObject value = (JSONObject)response.getValue();
            JSONObject config = (JSONObject)value.get((Object)"config");
            this.agentId = String.valueOf(config.get((Object)"agentId"));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public int hashCode() {
        return this.connector.getUri().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RemoteJmxAdapter && this.connector.getUri().equals(((RemoteJmxAdapter)o).connector.getUri());
    }

    public RemoteJmxAdapter(String url) throws IOException {
        this(new J4pClientBuilder().url(url).build());
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) {
        throw new UnsupportedOperationException("createMBean not supported by Jolokia");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) {
        throw new UnsupportedOperationException("createMBean not supported over Jolokia");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("createMBean not supported over Jolokia");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("createMBean not supported over Jolokia");
    }

    @Override
    public void unregisterMBean(ObjectName name) {
        throw new UnsupportedOperationException("unregisterMBean not supported over Jolokia");
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        J4pListResponse listResponse = (J4pListResponse)this.unwrapExecute(new J4pListRequest(name));
        return new ObjectInstance(name, listResponse.getClassName());
    }

    private List<ObjectInstance> listObjectInstances(ObjectName name) throws IOException {
        J4pListRequest listRequest = new J4pListRequest((String)null);
        if (name != null) {
            listRequest = new J4pListRequest(name);
        }
        try {
            J4pListResponse listResponse = (J4pListResponse)this.unwrapExecute(listRequest);
            return listResponse.getObjectInstances(name);
        }
        catch (MalformedObjectNameException e) {
            throw new UncheckedJmxAdapterException(e);
        }
        catch (InstanceNotFoundException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        for (ObjectInstance instance : this.listObjectInstances(name)) {
            if (query != null && !this.applyQuery(query, instance.getObjectName())) continue;
            result.add(instance);
        }
        return result;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        J4pSearchResponse response;
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        if (name == null) {
            try {
                name = RemoteJmxAdapter.getObjectName("");
            }
            catch (UncheckedJmxAdapterException uncheckedJmxAdapterException) {
                // empty catch block
            }
        }
        J4pSearchRequest j4pSearchRequest = new J4pSearchRequest(name);
        try {
            response = (J4pSearchResponse)this.unwrapExecute(j4pSearchRequest);
        }
        catch (InstanceNotFoundException e) {
            return Collections.emptySet();
        }
        List<ObjectName> names = response.getObjectNames();
        for (ObjectName objectName : names) {
            if (query != null && !this.applyQuery(query, objectName)) continue;
            result.add(objectName);
        }
        return result;
    }

    private boolean applyQuery(QueryExp query, ObjectName objectName) {
        if (QueryEval.getMBeanServer() == null) {
            query.setMBeanServer(this.createStandInMbeanServerProxyForQueryEvaluation());
        }
        try {
            return query.apply(objectName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UncheckedJmxAdapterException(e);
        }
    }

    private MBeanServer createStandInMbeanServerProxyForQueryEvaluation() {
        return (MBeanServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MBeanServer.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getName().contains("getObjectInstance") && args.length == 1) {
                    return RemoteJmxAdapter.this.getObjectInstance((ObjectName)args[0]);
                }
                throw new UnsupportedOperationException("This MBeanServer proxy does not support " + method);
            }
        });
    }

    private <RESP extends J4pResponse<REQ>, REQ extends J4pRequest> RESP unwrapExecute(REQ pRequest) throws IOException, InstanceNotFoundException {
        try {
            pRequest.setPreferredHttpMethod("POST");
            return this.connector.execute(pRequest, this.defaultProcessingOptions());
        }
        catch (J4pException e) {
            return (RESP)this.unwrapException(e);
        }
    }

    private Map<J4pQueryParameter, String> defaultProcessingOptions() {
        if (this.defaultProcessingOptions == null) {
            this.defaultProcessingOptions = new HashMap();
            this.defaultProcessingOptions.put(J4pQueryParameter.MAX_DEPTH, "10");
            this.defaultProcessingOptions.put(J4pQueryParameter.SERIALIZE_EXCEPTION, "true");
        }
        return this.defaultProcessingOptions;
    }

    protected J4pResponse unwrapException(J4pException e) throws IOException, InstanceNotFoundException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        if (e.getMessage().matches("Error: java.lang.IllegalArgumentException : No MBean '.+' found")) {
            throw new InstanceNotFoundException();
        }
        if (e instanceof J4pRemoteException && UNCHECKED_REMOTE_EXCEPTIONS.contains(((J4pRemoteException)e).getErrorType())) {
            throw new RuntimeMBeanException((RuntimeException)ClassUtil.newInstance((String)((J4pRemoteException)e).getErrorType(), (Object[])new Object[]{e.getMessage()}));
        }
        throw new UncheckedJmxAdapterException(e);
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        return !this.queryNames(name, null).isEmpty();
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        return this.queryNames(null, null).size();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, IOException {
        try {
            Object rawValue = ((J4pResponse)this.unwrapExecute(new J4pReadRequest(name, attribute))).getValue();
            return this.adaptJsonToOptimalResponseValue(name, attribute, rawValue);
        }
        catch (UncheckedJmxAdapterException e) {
            if (e.getCause() instanceof J4pRemoteException && "javax.management.AttributeNotFoundException".equals(((J4pRemoteException)e.getCause()).getErrorType())) {
                throw new AttributeNotFoundException(e.getCause().getMessage());
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            throw new AttributeNotFoundException();
        }
    }

    private Object adaptJsonToOptimalResponseValue(ObjectName name, String attribute, Object rawValue) throws IOException, InstanceNotFoundException {
        String qualifiedName = name + "." + attribute;
        this.getMBeanInfo(name);
        if (this.isPrimitive(rawValue)) {
            OpenType<?> attributeType = null;
            try {
                attributeType = ToOpenTypeConverter.cachedType(qualifiedName);
            }
            catch (OpenDataException openDataException) {
                // empty catch block
            }
            if (rawValue instanceof Number && attributeType != null) {
                return new Converters().getToOpenTypeConverter().convertToObject(attributeType, rawValue);
            }
            return rawValue;
        }
        if (rawValue instanceof JSONObject && ((JSONObject)rawValue).size() == 1 && ((JSONObject)rawValue).containsKey((Object)"objectName")) {
            return RemoteJmxAdapter.getObjectName("" + ((JSONObject)rawValue).get((Object)"objectName"));
        }
        try {
            return ToOpenTypeConverter.returnOpenTypedValue(qualifiedName, rawValue);
        }
        catch (OpenDataException e) {
            return rawValue;
        }
    }

    private boolean isPrimitive(Object rawValue) {
        return rawValue == null || rawValue instanceof Number || rawValue instanceof Boolean || rawValue instanceof String || rawValue instanceof Character;
    }

    static ObjectName getObjectName(String objectName) {
        try {
            return ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new UncheckedJmxAdapterException(e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, IOException {
        AttributeList result = new AttributeList();
        ArrayList<J4pReadRequest> requests = new ArrayList<J4pReadRequest>(attributes.length);
        for (String attribute : attributes) {
            requests.add(new J4pReadRequest(name, attribute));
        }
        List responses = Collections.emptyList();
        try {
            responses = this.connector.execute(requests, this.defaultProcessingOptions());
        }
        catch (J4pBulkRemoteException e) {
            responses = e.getResults();
        }
        catch (J4pException j4pException) {
            // empty catch block
        }
        for (Object item : responses) {
            if (!(item instanceof J4pReadResponse)) continue;
            J4pReadResponse value = (J4pReadResponse)item;
            String attribute = ((J4pReadRequest)value.getRequest()).getAttribute();
            result.add(new Attribute(attribute, this.adaptJsonToOptimalResponseValue(name, attribute, value.getValue())));
        }
        return result;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, IOException {
        J4pWriteRequest request = new J4pWriteRequest(name, attribute.getName(), attribute.getValue(), new String[0]);
        try {
            this.unwrapExecute(request);
        }
        catch (UncheckedJmxAdapterException e) {
            if (e.getCause() instanceof J4pRemoteException) {
                J4pRemoteException remote = (J4pRemoteException)e.getCause();
                if ("javax.management.AttributeNotFoundException".equals(remote.getErrorType())) {
                    throw new AttributeNotFoundException(e.getCause().getMessage());
                }
                if ("java.lang.IllegalArgumentException".equals(remote.getErrorType()) && remote.getMessage().matches("Error: java.lang.IllegalArgumentException : Invalid value .+ for attribute .+")) {
                    throw new InvalidAttributeValueException(remote.getMessage());
                }
            }
            throw e;
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, IOException {
        ArrayList<J4pWriteRequest> attributeWrites = new ArrayList<J4pWriteRequest>(attributes.size());
        for (Attribute attribute : attributes.asList()) {
            attributeWrites.add(new J4pWriteRequest(name, attribute.getName(), attribute.getValue(), new String[0]));
        }
        try {
            this.connector.execute(attributeWrites);
        }
        catch (J4pException e) {
            this.unwrapException(e);
        }
        return attributes;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, IOException {
        if (params == null && (signature == null || signature.length == 0)) {
            params = new Object[]{};
        }
        try {
            J4pExecResponse response = (J4pExecResponse)this.unwrapExecute(new J4pExecRequest(name, operationName + this.makeSignature(signature), params));
            return this.adaptJsonToOptimalResponseValue(name, operationName, response.getValue());
        }
        catch (UncheckedJmxAdapterException e) {
            if (e.getCause() instanceof J4pRemoteException) {
                throw new MBeanException((Exception)e.getCause());
            }
            throw e;
        }
    }

    private String makeSignature(String[] signature) {
        StringBuilder builder = new StringBuilder("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(signature[i]);
            }
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public String getDefaultDomain() {
        return "DefaultDomain";
    }

    @Override
    public String[] getDomains() throws IOException {
        HashSet<String> domains = new HashSet<String>();
        for (ObjectName name : this.queryNames(null, null)) {
            domains.add(name.getDomain());
        }
        return domains.toArray(new String[0]);
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (!(this.isRunningInJConsole() || this.isRunningInJVisualVm() || this.isRunningInJmc())) {
            throw new UnsupportedOperationException("addNotificationListener not supported for Jolokia");
        }
    }

    private boolean isRunningInJVisualVm() {
        String version = System.getProperty("netbeans.productversion");
        return version != null && version.contains("VisualVM");
    }

    private boolean isRunningInJConsole() {
        return System.getProperty("jconsole.showOutputViewer") != null;
    }

    private boolean isRunningInJmc() {
        return System.getProperty("running.in.jmc") != null;
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException("addNotificationListener not supported for Jolokia");
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) {
        throw new UnsupportedOperationException("removeNotificationListener not supported for Jolokia");
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException("removeNotificationListener not supported by Jolokia");
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) {
        if (!(this.isRunningInJmc() || this.isRunningInJConsole() || this.isRunningInJVisualVm())) {
            throw new UnsupportedOperationException("removeNotificationListener not supported by Jolokia");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException("removeNotificationListener not supported by Jolokia");
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IOException {
        MBeanInfo result = this.mbeanInfoCache.get(name);
        if (result == null) {
            J4pListResponse response = (J4pListResponse)this.unwrapExecute(new J4pListRequest(name));
            result = response.getMbeanInfo();
            this.mbeanInfoCache.put(name, result);
            for (MBeanAttributeInfo attr : result.getAttributes()) {
                String qualifiedName = name + "." + attr.getName();
                try {
                    if (ToOpenTypeConverter.cachedType(qualifiedName) != null) continue;
                    ToOpenTypeConverter.cacheType(ToOpenTypeConverter.typeFor(attr.getType()), qualifiedName);
                }
                catch (OpenDataException openDataException) {
                }
                catch (InvalidOpenTypeException invalidOpenTypeException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        ObjectInstance objectInstance = this.getObjectInstance(name);
        try {
            return Class.forName(className).isAssignableFrom(Class.forName(objectInstance.getClassName()));
        }
        catch (ClassNotFoundException e) {
            if (className.equals(objectInstance.getClassName())) {
                return true;
            }
            try {
                if (ToOpenTypeConverter.cachedType(name.toString()) != null) {
                    return ToOpenTypeConverter.cachedType(name.toString()).getTypeName().equals(className);
                }
            }
            catch (OpenDataException openDataException) {
                // empty catch block
            }
            return false;
        }
    }

    String getId() {
        return this.agentId;
    }
}

