/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.jmxadapter;

import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import org.jolokia.converter.Converters;
import org.jolokia.converter.object.StringToOpenTypeConverter;
import org.jolokia.util.ClassUtil;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class ToOpenTypeConverter {
    private static final SimpleType<?>[] typeArray = new SimpleType[]{SimpleType.VOID, SimpleType.BOOLEAN, SimpleType.CHARACTER, SimpleType.BYTE, SimpleType.SHORT, SimpleType.INTEGER, SimpleType.LONG, SimpleType.FLOAT, SimpleType.DOUBLE, SimpleType.STRING, SimpleType.BIGDECIMAL, SimpleType.BIGINTEGER, SimpleType.DATE, SimpleType.OBJECTNAME};
    static final StringToOpenTypeConverter CONVERTER = new Converters().getToOpenTypeConverter().makeForgiving();
    private static HashMap<String, OpenType<?>> TABULAR_CONTENT_TYPE;
    private static Map<String, OpenType<?>> TYPE_SPECIFICATIONS;

    public static Object returnOpenTypedValue(String name, Object rawValue) throws OpenDataException {
        if (rawValue instanceof JSONArray && ((JSONArray)rawValue).isEmpty()) {
            OpenType<?> type = ToOpenTypeConverter.cachedType(name);
            if (type != null) {
                return new Converters().getToOpenTypeConverter().convertToObject(type, rawValue);
            }
            return rawValue;
        }
        OpenType<?> type = ToOpenTypeConverter.recursivelyBuildOpenType(name, rawValue);
        if (type == null) {
            return rawValue;
        }
        if (type.isArray() && ((ArrayType)type).isPrimitiveArray()) {
            return ToOpenTypeConverter.toPrimitiveArray((ArrayType)type, (JSONArray)rawValue);
        }
        return CONVERTER.convertToObject(type, rawValue);
    }

    private static Object toPrimitiveArray(ArrayType<?> type, JSONArray rawValue) {
        if (SimpleType.LONG.equals(type.getElementOpenType())) {
            long[] longArray = new long[rawValue.size()];
            for (int i = 0; i < rawValue.size(); ++i) {
                longArray[i] = ((Number)rawValue.get(i)).longValue();
            }
            return longArray;
        }
        if (SimpleType.INTEGER.equals(type.getElementOpenType())) {
            int[] intArray = new int[rawValue.size()];
            for (int i = 0; i < rawValue.size(); ++i) {
                intArray[i] = ((Number)rawValue.get(i)).intValue();
            }
            return intArray;
        }
        if (SimpleType.DOUBLE.equals(type.getElementOpenType())) {
            double[] doubleArray = new double[rawValue.size()];
            for (int i = 0; i < rawValue.size(); ++i) {
                doubleArray[i] = ((Number)rawValue.get(i)).doubleValue();
            }
            return doubleArray;
        }
        if (SimpleType.BOOLEAN.equals(type.getElementOpenType())) {
            boolean[] booleanArray = new boolean[rawValue.size()];
            for (int i = 0; i < rawValue.size(); ++i) {
                booleanArray[i] = rawValue.get(i) == Boolean.TRUE;
            }
            return booleanArray;
        }
        if (SimpleType.BYTE.equals(type.getElementOpenType())) {
            byte[] byteArray = new byte[rawValue.size()];
            for (int i = 0; i < rawValue.size(); ++i) {
                byteArray[i] = ((Number)rawValue.get(i)).byteValue();
            }
            return byteArray;
        }
        return rawValue.toArray((Object[])Array.newInstance(ClassUtil.classForName((String)type.getElementOpenType().getClassName(), (ClassLoader[])new ClassLoader[0]), rawValue.size()));
    }

    public static OpenType<?> recursivelyBuildOpenType(String name, Object rawValue) throws OpenDataException {
        for (SimpleType<?> type : typeArray) {
            if (!type.isValue(rawValue) && (type.getClassName() == null || !type.equals(ToOpenTypeConverter.cachedType(name)))) continue;
            return type;
        }
        if (rawValue instanceof JSONArray) {
            JSONArray array = (JSONArray)rawValue;
            if (array.size() > 0) {
                OpenType<?> elementType = ToOpenTypeConverter.recursivelyBuildOpenType(name + ".item", array.get(0));
                if (elementType instanceof SimpleType && ToOpenTypeConverter.cachedType(name) != null) {
                    return ToOpenTypeConverter.cachedType(name);
                }
                return ArrayType.getArrayType(elementType);
            }
        } else {
            if (ToOpenTypeConverter.tabularContentType(name) != null) {
                String typeName = "Map<java.lang.String," + ToOpenTypeConverter.tabularContentType(name).getClassName() + ">";
                return new TabularType(typeName, typeName, new CompositeType(typeName, typeName, new String[]{"key", "value"}, new String[]{"key", "value"}, new OpenType[]{SimpleType.STRING, ToOpenTypeConverter.tabularContentType(name)}), new String[]{"key"});
            }
            if (ToOpenTypeConverter.cachedType(name) != null) {
                return ToOpenTypeConverter.cachedType(name);
            }
            if (rawValue instanceof JSONObject) {
                JSONObject structure = (JSONObject)rawValue;
                String[] keys = new String[structure.size()];
                OpenType[] types = new OpenType[structure.size()];
                int index = 0;
                for (Object element : structure.entrySet()) {
                    Map.Entry entry = (Map.Entry)element;
                    keys[index] = (String)entry.getKey();
                    types[index++] = ToOpenTypeConverter.recursivelyBuildOpenType(name + "." + (String)entry.getKey(), entry.getValue());
                }
                if (types.length == 0) {
                    throw new InvalidOpenTypeException("No subtypes for " + name);
                }
                return new CompositeType("complex", "complex", keys, keys, types);
            }
        }
        throw new InvalidOpenTypeException("Unable to figure out type for " + rawValue);
    }

    static OpenType<?> cachedType(String name) throws OpenDataException {
        if (TYPE_SPECIFICATIONS == null) {
            Class eventTypesClass;
            Class configurationClass;
            Class gcInfo;
            TYPE_SPECIFICATIONS = new HashMap();
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(MemoryUsage.class), "java.lang:type=Memory.NonHeapMemoryUsage", "java.lang:type=MemoryPool,name=Metaspace.PeakUsage", "java.lang:type=MemoryPool,name=Code Cache.PeakUsage", "java.lang:type=MemoryPool,name=Code Cache.Usage", "java.lang:type=MemoryPool,name=PS Old Gen.CollectionUsage", "java.lang:type=MemoryPool,name=PS Old Gen.PeakUsage", "java.lang:type=MemoryPool,name=PS Old Gen.Usage", "java.lang:type=MemoryPool,name=PS Eden Space.CollectionUsage", "java.lang:type=MemoryPool,name=PS Eden Space.PeakUsage", "java.lang:type=MemoryPool,name=Compressed Class Space.PeakUsage", "java.lang:type=MemoryPool,name=Compressed Class Space.Usage", "java.lang:type=MemoryPool,name=Metaspace.Usage", "java.lang:type=MemoryPool,name=PS Eden Space.Usage", "java.lang:type=Memory.HeapMemoryUsage", "java.lang:type=MemoryPool,name=PS Survivor Space.CollectionUsage", "java.lang:type=MemoryPool,name=PS Survivor Space.PeakUsage", "java.lang:type=MemoryPool,name=PS Perm Gen.CollectionUsage", "java.lang:type=MemoryPool,name=PS Perm Gen.Usage", "java.lang:type=MemoryPool,name=PS Survivor Space.Usage", "java.lang:type=MemoryPool,name=PS Perm Gen.PeakUsage", "java.lang:type=MemoryPool,name=tenured-LOA.CollectionUsage", "java.lang:type=MemoryPool,name=class storage.PeakUsage", "java.lang:type=MemoryPool,name=miscellaneous non-heap storage.PeakUsage", "java.lang:type=MemoryPool,name=nursery-survivor.CollectionUsage", "java.lang:type=MemoryPool,name=JIT code cache.PeakUsage", "java.lang:type=GarbageCollector,name=global.LastGcInfo", "java.lang:type=MemoryPool,name=JIT data cache.PeakUsage", "java.lang:type=MemoryPool,name=tenured-SOA.CollectionUsage", "java.lang:type=MemoryPool,name=nursery-allocate.CollectionUsage", "java.lang:type=MemoryPool,name=tenured-LOA.PeakUsage", "java.lang:type=MemoryPool,name=class storage.Usage", "java.lang:type=MemoryPool,name=miscellaneous non-heap storage.Usage", "java.lang:type=MemoryPool,name=nursery-survivor.PeakUsage", "java.lang:type=MemoryPool,name=JIT code cache.PeakUsage", "java.lang:type=MemoryPool,name=JIT data cache.Usage", "java.lang:type=MemoryPool,name=tenured-SOA.PeakUsage", "java.lang:type=MemoryPool,name=tenured-LOA.PreCollectionUsage", "java.lang:type=MemoryPool,name=nursery-survivor.PreCollectionUsage", "java.lang:type=MemoryPool,name=JIT code cache.Usage", "java.lang:type=MemoryPool,name=tenured-SOA.PreCollectionUsage", "java.lang:type=MemoryPool,name=nursery-allocate.PeakUsage", "java.lang:type=MemoryPool,name=tenured-LOA.Usage", "java.lang:type=MemoryPool,name=nursery-survivor.Usage", "java.lang:type=MemoryPool,name=tenured-SOA.Usage", "java.lang:type=MemoryPool,name=nursery-allocate.PreCollectionUsage", "java.lang:type=MemoryPool,name=nursery-allocate.Usage");
            Class vmOptionClass = ClassUtil.classForName((String)"com.sun.management.VMOption", (ClassLoader[])new ClassLoader[0]);
            if (vmOptionClass != null) {
                ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(vmOptionClass), "com.sun.management:type=HotSpotDiagnostic.DiagnosticOptions.item", "com.sun.management:type=HotSpotDiagnostic.getVMOption");
                ToOpenTypeConverter.cacheType(new ArrayType(1, ToOpenTypeConverter.introspectComplexTypeRequireNonNull(vmOptionClass)), "com.sun.management:type=HotSpotDiagnostic.DiagnosticOptions");
            }
            if ((gcInfo = ClassUtil.classForName((String)"com.sun.management.GcInfo", (ClassLoader[])new ClassLoader[0])) != null) {
                ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(gcInfo), "java.lang:type=GarbageCollector,name=scavenge.LastGcInfo", "java.lang:type=GarbageCollector,name=global.LastGcInfo");
            }
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(ThreadInfo.class), "java.lang:type=Threading.getThreadInfo.item", "java.lang:type=Threading.getThreadInfo");
            ToOpenTypeConverter.cacheType(ArrayType.getPrimitiveArrayType(long[].class), "java.lang:type=Threading.AllThreadIds");
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(ThreadInfo.class), "java.lang:type=Threading.dumpAllThreads.item");
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(ClassLoadingMXBean.class), "java.lang:type=ClassLoading");
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(CompilationMXBean.class), "java.lang:type=Compilation");
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(MemoryMXBean.class), "java.lang:type=Memory");
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(OperatingSystemMXBean.class), "java.lang:type=OperatingSystem");
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(RuntimeMXBean.class), "java.lang:type=Runtime");
            ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(ThreadMXBean.class), "java.lang:type=Threading");
            Class recordingClass = ClassUtil.classForName((String)"jdk.management.jfr.RecordingInfo", (ClassLoader[])new ClassLoader[0]);
            if (recordingClass != null) {
                ToOpenTypeConverter.cacheType(ArrayType.getArrayType(ToOpenTypeConverter.introspectComplexTypeFrom(recordingClass)), "jdk.management.jfr:type=FlightRecorder.Recordings", "jdk.jfr.management:type=FlightRecorder.Recordings");
                ToOpenTypeConverter.cacheType(ToOpenTypeConverter.introspectComplexTypeFrom(recordingClass), "jdk.management.jfr:type=FlightRecorder.Recordings.item", "jdk.jfr.management:type=FlightRecorder.Recordings.item");
            }
            if ((configurationClass = ClassUtil.classForName((String)"jdk.management.jfr.ConfigurationInfo", (ClassLoader[])new ClassLoader[0])) != null) {
                ToOpenTypeConverter.cacheType(ArrayType.getArrayType(ToOpenTypeConverter.introspectComplexTypeFrom(configurationClass)), "jdk.management.jfr:type=FlightRecorder.Configurations", "jdk.jfr.management:type=FlightRecorder.Configurations");
            }
            if ((eventTypesClass = ClassUtil.classForName((String)"jdk.management.jfr.EventTypeInfo", (ClassLoader[])new ClassLoader[0])) != null) {
                ToOpenTypeConverter.cacheType(ArrayType.getArrayType(ToOpenTypeConverter.introspectComplexTypeFrom(eventTypesClass)), "jdk.management.jfr:type=FlightRecorder.EventTypes", "jdk.jfr.management:type=FlightRecorder.EventTypes");
            }
            ToOpenTypeConverter.cacheType(ArrayType.getPrimitiveArrayType(byte[].class), "jdk.management.jfr:type=FlightRecorder.readStream", "jdk.jfr.management:type=FlightRecorder.readStream");
        }
        ToOpenTypeConverter.cacheType(SimpleType.STRING, "jdk.management.jfr:type=FlightRecorder.EventTypes.item.description");
        return TYPE_SPECIFICATIONS.get(name);
    }

    static void cacheType(OpenType<?> type, String ... names) {
        for (String name : names) {
            TYPE_SPECIFICATIONS.put(name, type);
        }
    }

    private static OpenType<?> introspectComplexTypeRequireNonNull(Class<?> klass) throws OpenDataException {
        OpenType<?> type = ToOpenTypeConverter.introspectComplexTypeFrom(klass);
        if (type == null) {
            throw new InvalidOpenTypeException("Unable to detect opentype for " + klass);
        }
        return type;
    }

    static OpenType<?> introspectComplexTypeFrom(Class<?> klass) throws OpenDataException {
        if (CompositeData.class.equals(klass) || TabularData.class.equals(klass)) {
            return null;
        }
        if (klass.isEnum()) {
            return SimpleType.STRING;
        }
        if (klass.isPrimitive()) {
            for (SimpleType<?> type : typeArray) {
                if (!type.getTypeName().substring(type.getTypeName().lastIndexOf(46) + 1).toLowerCase().startsWith(klass.getSimpleName())) continue;
                return type;
            }
        }
        for (SimpleType<?> type : typeArray) {
            if (!klass.getName().equals(type.getClassName())) continue;
            return type;
        }
        if (klass.isArray()) {
            return new ArrayType(1, ToOpenTypeConverter.introspectComplexTypeRequireNonNull(klass.getComponentType()));
        }
        LinkedList<String> names = new LinkedList<String>();
        LinkedList types = new LinkedList();
        for (Class<?> classToIntrospect = klass; classToIntrospect != null && !classToIntrospect.equals(Object.class); classToIntrospect = classToIntrospect.getSuperclass()) {
            for (Method method : classToIntrospect.getDeclaredMethods()) {
                String nameWithoutPrefix;
                if (Modifier.isStatic(method.getModifiers()) || !Modifier.isPublic(method.getModifiers()) || method.getParameterTypes().length != 0) continue;
                if (method.getName().startsWith("get")) {
                    nameWithoutPrefix = method.getName().substring(3, 4).toLowerCase() + method.getName().substring(4);
                    ToOpenTypeConverter.recursivelyBuildSubtype(klass, names, types, method.getReturnType(), nameWithoutPrefix);
                    continue;
                }
                if (!method.getName().startsWith("is")) continue;
                nameWithoutPrefix = method.getName().substring(2, 3).toLowerCase() + method.getName().substring(3);
                ToOpenTypeConverter.recursivelyBuildSubtype(klass, names, types, method.getReturnType(), nameWithoutPrefix);
            }
        }
        if (types.isEmpty()) {
            throw new InvalidOpenTypeException("Found no fields to build composite type for class " + klass);
        }
        return new CompositeType(klass.getName(), klass.getName(), names.toArray(new String[0]), names.toArray(new String[0]), types.toArray(new OpenType[0]));
    }

    private static void recursivelyBuildSubtype(Class<?> klass, List<String> names, List<OpenType<?>> types, Class<?> subType, String nameWithoutPrefix) throws OpenDataException {
        if (klass.equals(subType)) {
            throw new OpenDataException("Unable to support recursive types, abort and allow default handling to take place");
        }
        names.add(nameWithoutPrefix);
        types.add(ToOpenTypeConverter.introspectComplexTypeFrom(subType));
    }

    private static OpenType<?> tabularContentType(String attribute) throws OpenDataException {
        if (TABULAR_CONTENT_TYPE == null) {
            TABULAR_CONTENT_TYPE = new HashMap();
            TABULAR_CONTENT_TYPE.put("java.lang:type=Runtime.SystemProperties", SimpleType.STRING);
            TABULAR_CONTENT_TYPE.put("jdk.management.jfr:type=FlightRecorder.Recordings.item.Settings", SimpleType.STRING);
            TABULAR_CONTENT_TYPE.put("jdk.jfr.management:type=FlightRecorder.Recordings.item.Settings", SimpleType.STRING);
            TABULAR_CONTENT_TYPE.put("jdk.management.jfr:type=FlightRecorder.Configurations.item.Settings", SimpleType.STRING);
            TABULAR_CONTENT_TYPE.put("jdk.jfr.management:type=FlightRecorder.Configurations.item.Settings", SimpleType.STRING);
            TABULAR_CONTENT_TYPE.put("java.lang:name=PS Scavenge,type=GarbageCollector.LastGcInfo.memoryUsageAfterGc", ToOpenTypeConverter.introspectComplexTypeFrom(MemoryUsage.class));
            TABULAR_CONTENT_TYPE.put("java.lang:name=PS Scavenge,type=GarbageCollector.LastGcInfo.memoryUsageBeforeGc", ToOpenTypeConverter.introspectComplexTypeFrom(MemoryUsage.class));
            TABULAR_CONTENT_TYPE.put("java.lang:name=PS MarkSweep,type=GarbageCollector.LastGcInfo.memoryUsageAfterGc", ToOpenTypeConverter.introspectComplexTypeFrom(MemoryUsage.class));
            TABULAR_CONTENT_TYPE.put("java.lang:name=PS MarkSweep,type=GarbageCollector.LastGcInfo.memoryUsageBeforeGc", ToOpenTypeConverter.introspectComplexTypeFrom(MemoryUsage.class));
        }
        return TABULAR_CONTENT_TYPE.get(attribute);
    }

    static OpenType<?> typeFor(String attributeType) throws OpenDataException {
        Class klass = ClassUtil.classForName((String)attributeType, (ClassLoader[])new ClassLoader[0]);
        if (klass == null) {
            if (attributeType.equals("int")) {
                klass = Integer.class;
            } else if (attributeType.equals("long")) {
                klass = Long.class;
            } else if (attributeType.equals("boolean")) {
                klass = Boolean.class;
            } else if (attributeType.equals("double")) {
                klass = Double.class;
            } else {
                return null;
            }
        }
        return ToOpenTypeConverter.typeFor(klass);
    }

    static OpenType<?> typeFor(Class<?> attributeClass) throws OpenDataException {
        for (SimpleType<?> simpleType : typeArray) {
            if (!simpleType.getClass().isAssignableFrom(attributeClass)) continue;
            return simpleType;
        }
        return ToOpenTypeConverter.introspectComplexTypeFrom(attributeClass);
    }
}

