/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.it.core;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.jolokia.it.core.AttributeChecking;
import org.jolokia.it.core.JsonChecking;
import org.jolokia.it.core.JsonChecking2;
import org.jolokia.it.core.JsonChecking2MXBean;
import org.jolokia.it.core.MxBeanSample;
import org.jolokia.it.core.ObjectNameChecking;
import org.jolokia.it.core.OperationChecking;
import org.jolokia.it.core.TabularMBean;
import org.jolokia.it.core.notification.Chat;
import org.jolokia.support.jmx.JolokiaMBeanServerUtil;

public class ItSetup {
    public static final String JOLOKIA_IT_DOMAIN = "jolokia.it";
    public static final String JOLOKIA_IT_DOMAIN_HIDDEN = "jolokia.it.hidden";
    private static final String JOLOKIA_IT_JSONMBEAN_DOMAIN = "jolokia.it.jsonmbean";
    private final String[] strangeNamesShort = new String[]{"\\/", "simple", "/slash-simple/", "/--/", "with%3acolon", "//server/client", "service%3ajmx%3armi%3a///jndi/rmi%3a//bhut%3a9999/jmxrmi", "\"jdbc/testDB\"", "name with space", "n!a!m!e with !/!"};
    private final List<String> strangeNames = new ArrayList<String>();
    private final String[] fullNames = new String[]{"jolokia/it:id=3786439,pid=[ServiceRegistryProvider#(null)],type=ParticipantMonitor", "jolokia.jboss.as.expr:access=authorization,applies-to=\"/subsystem=undertow/server=\\*/ajp-listener=\\*\",classification=socket-binding-ref,constraint=sensitivity-classification,core-service=management,type=core"};
    private final String[] escapedNamesShort = new String[]{"name*withstrange=chars", "name?withstrange=chars", "namewithstrange=\"chars\"", "namewithstrange:\"chars\"", ",,,", ",,/,,", "===", "***", "\"\"\"", ":::", "???", "!!!"};
    private final List<String> escapedNames = new ArrayList<String>();
    private List<ObjectName> registeredMBeans;
    private List<ObjectName> registeredJolokiaMBeans = Collections.emptyList();

    public void start() {
        this.registeredMBeans = this.registerMBeans(ManagementFactory.getPlatformMBeanServer(), JOLOKIA_IT_DOMAIN);
        MBeanServer jolokiaServer = this.getJolokiaMBeanServer();
        if (jolokiaServer != null) {
            this.registeredJolokiaMBeans = this.registerMBeans(jolokiaServer, JOLOKIA_IT_DOMAIN_HIDDEN);
            try {
                this.registeredJolokiaMBeans.addAll(this.registerJsonMBeans(jolokiaServer, JOLOKIA_IT_JSONMBEAN_DOMAIN));
            }
            catch (RuntimeException exp) {
                System.err.println("Error: Cannot register JSON MBeans: " + String.valueOf(exp));
            }
        }
    }

    public void stop() {
        this.unregisterMBeans(this.registeredMBeans, ManagementFactory.getPlatformMBeanServer());
        MBeanServer jolokiaServer = this.getJolokiaMBeanServer();
        if (jolokiaServer != null) {
            this.unregisterMBeans(this.registeredJolokiaMBeans, jolokiaServer);
        }
    }

    public static void premain(String agentArgs) {
        ItSetup itSetup = new ItSetup();
        itSetup.start();
    }

    private List<ObjectName> registerMBeans(MBeanServer pServer, String pDomain) {
        ArrayList<ObjectName> ret = new ArrayList<ObjectName>();
        try {
            for (String name : this.strangeNamesShort) {
                String strangeName = pDomain + ":type=naming/,name=" + name;
                this.strangeNames.add(strangeName);
                ret.add(this.registerMBean(pServer, new ObjectNameChecking(strangeName), strangeName));
            }
            for (String name : this.escapedNamesShort) {
                String escapedName = pDomain + ":type=escape,name=" + ObjectName.quote(name);
                this.escapedNames.add(escapedName);
                ret.add(this.registerMBean(pServer, new ObjectNameChecking(escapedName), escapedName));
            }
            for (String name : this.fullNames) {
                ret.add(this.registerMBean(pServer, new ObjectNameChecking(name), name));
            }
            boolean isWebsphere = this.checkForClass("com.ibm.websphere.management.AdminServiceFactory");
            ret.add(this.registerMBean(pServer, new OperationChecking(JOLOKIA_IT_DOMAIN), isWebsphere ? null : pDomain + ":type=operation"));
            ret.add(this.registerMBean(pServer, new AttributeChecking(JOLOKIA_IT_DOMAIN), isWebsphere ? null : pDomain + ":type=attribute"));
            if (this.hasMxBeanSupport()) {
                ret.add(this.registerMBean(pServer, new MxBeanSample(), isWebsphere ? null : pDomain + ":type=mxbean"));
            }
            ret.add(this.registerMBean(pServer, new TabularMBean(), pDomain + ":type=tabularData"));
            ret.add(this.registerMBean(pServer, new Chat(), pDomain + ":type=Chat"));
        }
        catch (Exception exp) {
            throw new RuntimeException("Error", exp);
        }
        return ret;
    }

    private List<ObjectName> registerJsonMBeans(MBeanServer pServer, String pDomain) {
        ArrayList<ObjectName> ret = new ArrayList<ObjectName>();
        try {
            ret.add(this.registerMBean(pServer, new JsonChecking(), pDomain + ":type=plain"));
            ret.add(this.registerMXBean(pServer, new JsonChecking2(), JsonChecking2MXBean.class, pDomain + ":type=mx"));
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Error", e);
        }
        catch (NoSuchMethodError e) {
            return ret;
        }
    }

    private boolean hasMxBeanSupport() {
        return this.checkForClass("javax.management.MXBean") && !this.checkForClass("org.jboss.mx.util.MBeanServerLocator");
    }

    public String getAttributeMBean() {
        return "jolokia.it:type=attribute";
    }

    public String getOperationMBean() {
        return "jolokia.it:type=operation";
    }

    public String getMxBean() {
        return "jolokia.it:type=mxbean";
    }

    private void unregisterMBeans(List<ObjectName> pMBeanNames, MBeanServer pServer) {
        for (ObjectName name : pMBeanNames) {
            try {
                pServer.unregisterMBean(name);
            }
            catch (Exception e) {
                System.out.println("Exception while unregistering " + String.valueOf(e));
            }
        }
    }

    private ObjectName registerMBean(MBeanServer pServer, Object pObject, String pName) throws MalformedObjectNameException, MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        ObjectName registeredName = pName != null ? pServer.registerMBean(pObject, new ObjectName(pName)).getObjectName() : pServer.registerMBean(pObject, null).getObjectName();
        return registeredName;
    }

    private ObjectName registerMXBean(MBeanServer pServer, Object pObject, Class pManagementInterface, String pName) throws MalformedObjectNameException, NotCompliantMBeanException, InstanceAlreadyExistsException, MBeanRegistrationException {
        ObjectName objectName = new ObjectName(pName);
        StandardMBean mxBean = new StandardMBean(pObject, pManagementInterface, true);
        pServer.registerMBean(mxBean, objectName);
        return objectName;
    }

    public List<String> getStrangeNames() {
        return this.strangeNames;
    }

    public List<String> getEscapedNames() {
        return this.escapedNames;
    }

    private boolean checkForClass(String pClassName) {
        return this.getClass(pClassName) != null;
    }

    private Class<?> getClass(String pClassName) {
        try {
            ClassLoader loader = this.getClassLoader();
            return Class.forName(pClassName, false, loader);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public MBeanServer getJolokiaMBeanServer() {
        try {
            if (this.getClass("org.jolokia.support.jmx.JolokiaMBeanServerUtil") == null) {
                Class.forName("org.jolokia.support.jmx.JolokiaMBeanServerUtil");
            }
            return JolokiaMBeanServerUtil.getJolokiaMBeanServer();
        }
        catch (RuntimeException e) {
            System.out.println("No JolokiaServer found: " + String.valueOf(e));
            e.printStackTrace();
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.out.println("No JolokiaServer found, ignoring certain tests ...");
            return null;
        }
    }
}

