/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.it.core;

import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class TabularMBean
implements DynamicMBean {
    private static final String[] COLUMN_NAMES = new String[]{"Column1", "Column2", "Column3"};
    private static final String[][] TABLE_DATA = new String[][]{{"Value0.0", "Value0.1", "Value0.2"}, {"Value1.0", "Value1.1", "Value1.2"}, {"Value2.0", "Value2.1", "Value2.2"}};
    private final MBeanInfo _mbeanInfo;
    private final TabularType _table1Type;
    private final TabularType _table2Type;
    private final TabularType _updateType;

    public TabularMBean() throws OpenDataException {
        MBeanAttributeInfo[] attributes = new MBeanAttributeInfo[2];
        String[] columnDescriptions = new String[]{"column one", "column two", "column three"};
        OpenType[] columnTypes = new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING};
        CompositeType compositeType = new CompositeType("SensorMetric", "Sensor metric data", COLUMN_NAMES, columnDescriptions, columnTypes);
        this._table1Type = new TabularType("Table1Type", "table one type", compositeType, new String[]{"Column1"});
        attributes[0] = new OpenMBeanAttributeInfoSupport("Table1", "table one", this._table1Type, true, false, false);
        this._table2Type = new TabularType("Table2Type", "table two type", compositeType, new String[]{"Column1", "Column2"});
        attributes[1] = new OpenMBeanAttributeInfoSupport("Table2", "table two", this._table2Type, true, false, false);
        this._updateType = new TabularType("UpdateType", "Update data", new CompositeType("updateRow", "Row desc", new String[]{"Key", "Value", "Type"}, new String[]{"Key", "Value", "Type"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING}), new String[]{"Key"});
        MBeanOperationInfo[] operations = new MBeanOperationInfo[]{new OpenMBeanOperationInfoSupport("update", "Test method for TabularData", new OpenMBeanParameterInfo[]{new OpenMBeanParameterInfoSupport("name", "1. param", SimpleType.STRING), new OpenMBeanParameterInfoSupport("data", "2. param", this._updateType)}, this._updateType, 0)};
        this._mbeanInfo = new MBeanInfo(this.getClass().getName(), "tabular mbean", attributes, null, operations, null);
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (attribute.equals("Table1")) {
            return this.getTableData(this._table1Type);
        }
        if (attribute.equals("Table2")) {
            return this.getTableData(this._table2Type);
        }
        throw new AttributeNotFoundException("MBean attribute " + attribute + " not exposed for " + this.getClass().getName());
    }

    private Object getTableData(TabularType tabularType) throws MBeanException {
        TabularDataSupport tableData = new TabularDataSupport(tabularType);
        for (Object[] objectArray : TABLE_DATA) {
            try {
                tableData.put(new CompositeDataSupport(tabularType.getRowType(), COLUMN_NAMES, objectArray));
            }
            catch (OpenDataException exc) {
                throw new MBeanException(exc, "Error creating table data");
            }
        }
        return tableData;
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new MBeanException(new UnsupportedOperationException("MBean operation setAttribute is not supported for " + this.getClass().getName()));
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        AttributeList values = new AttributeList(attributes.length);
        for (String attributeName : attributes) {
            Object result;
            try {
                result = this.getAttribute(attributeName);
            }
            catch (Exception exc) {
                result = exc;
            }
            values.add(new Attribute(attributeName, result));
        }
        return values;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        Iterator iterator = attributes.iterator();
        AttributeList newValues = new AttributeList(attributes.size());
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            try {
                this.setAttribute(attribute);
            }
            catch (Exception exc) {
                attribute = new Attribute(attribute.getName(), exc);
            }
            newValues.add(attribute);
        }
        return newValues;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (actionName.equals("update")) {
            return params[1];
        }
        throw new MBeanException(new UnsupportedOperationException("MBean operation " + actionName + " is not supported for " + this.getClass().getName()));
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this._mbeanInfo;
    }
}

