/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.kubernetes.client;

import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.StatusBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.internal.OperationSupport;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.utils.KubernetesSerialization;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import okhttp3.HttpUrl;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicStatusLine;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.util.Base64Util;

public class MinimalHttpClientAdapter
implements HttpClient {
    private final KubernetesClient client;
    private final KubernetesSerialization serialization;
    private final String urlPath;
    private String user;
    private String password;

    public MinimalHttpClientAdapter(KubernetesClient client, String urlPath, Map<String, Object> env) {
        this.client = client;
        this.serialization = this.client.getKubernetesSerialization();
        this.urlPath = urlPath;
        String[] credentials = (String[])env.get("jmx.remote.credentials");
        if (credentials != null) {
            this.user = credentials[0];
            this.password = credentials[1];
        }
    }

    static void authenticate(Map<String, String> headers, String username, String password) {
        if (username != null) {
            headers.put("X-jolokia-authorization", "Basic " + Base64Util.encode((byte[])(username + ":" + password).getBytes()));
        }
    }

    public HttpParams getParams() {
        throw new UnsupportedOperationException();
    }

    public ClientConnectionManager getConnectionManager() {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest) throws IOException {
        try {
            io.fabric8.kubernetes.client.http.HttpResponse<byte[]> response = MinimalHttpClientAdapter.performRequest(this.client, this.urlPath, this.extractBody((HttpRequest)httpUriRequest), httpUriRequest.getURI().getQuery(), this.allHeaders(httpUriRequest));
            return this.convertResponse(response);
        }
        catch (KubernetesClientException | InterruptedException | ExecutionException e) {
            throw new ClientProtocolException(e);
        }
    }

    private Map<String, String> allHeaders(HttpUriRequest httpUriRequest) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : httpUriRequest.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        MinimalHttpClientAdapter.authenticate(headers, this.user, this.password);
        return headers;
    }

    public static io.fabric8.kubernetes.client.http.HttpResponse<byte[]> performRequest(KubernetesClient client, String path, byte[] body, String query, Map<String, String> headers) throws IOException, InterruptedException, ExecutionException {
        HttpRequest.Builder requestBuilder = client.getHttpClient().newHttpRequestBuilder();
        requestBuilder.method("POST", "application/json", new String(body)).url(MinimalHttpClientAdapter.buildHttpUri(client, path, query));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            requestBuilder.header(header.getKey(), header.getValue());
        }
        io.fabric8.kubernetes.client.http.HttpRequest request = requestBuilder.build();
        CompletionStage futureResponse = client.getHttpClient().sendAsync(request, byte[].class).thenApply(response -> {
            try {
                return response;
            }
            catch (KubernetesClientException e) {
                throw e;
            }
            catch (Exception e) {
                throw OperationSupport.requestException((io.fabric8.kubernetes.client.http.HttpRequest)request, (Exception)e);
            }
        });
        return (io.fabric8.kubernetes.client.http.HttpResponse)((CompletableFuture)futureResponse).get();
    }

    private static URL buildHttpUri(KubernetesClient client, String resourcePath, String query) {
        URL masterUrl = client.getMasterUrl();
        HttpUrl.Builder builder = new HttpUrl.Builder().scheme(masterUrl.getProtocol()).host(masterUrl.getHost()).query(query);
        builder.encodedPath(resourcePath);
        if (masterUrl.getPort() != -1) {
            builder.port(masterUrl.getPort());
        }
        return builder.build().url();
    }

    protected HttpResponse convertResponse(io.fabric8.kubernetes.client.http.HttpResponse<byte[]> response) {
        int responseCode = response.code();
        ProtocolVersion hackHardcodedHttpVersion = new ProtocolVersion("http", 1, 1);
        BasicHttpResponse convertedResponse = new BasicHttpResponse((StatusLine)new BasicStatusLine(hackHardcodedHttpVersion, responseCode, response.message()));
        for (String header : response.headers().keySet()) {
            convertedResponse.setHeader(header, response.header(header));
        }
        if (response.body() != null) {
            byte[] responseBytes;
            BasicHttpEntity responseEntity = new BasicHttpEntity();
            if (responseCode >= 400) {
                JSONObject errorResponse = new JSONObject();
                Object syntethicException = new ClientProtocolException("Failure calling Jolokia in kubernetes");
                errorResponse.put((Object)"status", (Object)responseCode);
                try {
                    syntethicException = new KubernetesClientException(this.convertResponseBody(response));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                errorResponse.put((Object)"error_type", (Object)syntethicException.getClass().getName());
                errorResponse.put((Object)"error", (Object)((Throwable)syntethicException).getMessage());
                StringWriter stacktrace = new StringWriter();
                ((Throwable)syntethicException).printStackTrace(new PrintWriter(stacktrace));
                errorResponse.put((Object)"stacktrace", (Object)stacktrace.getBuffer().toString());
                responseBytes = errorResponse.toJSONString().getBytes();
            } else {
                responseBytes = (byte[])response.body();
            }
            responseEntity.setContentLength((long)responseBytes.length);
            responseEntity.setContent((InputStream)new ByteArrayInputStream(responseBytes));
            responseEntity.setContentType(response.header("Content-Type"));
            convertedResponse.setEntity((HttpEntity)responseEntity);
            convertedResponse.setHeader("Content-Length", String.valueOf(responseBytes.length));
        }
        return convertedResponse;
    }

    private Status convertResponseBody(io.fabric8.kubernetes.client.http.HttpResponse<byte[]> response) {
        int statusCode;
        String statusMessage = "";
        byte[] body = response != null ? (byte[])response.body() : null;
        int n = statusCode = response != null ? response.code() : 0;
        if (body != null) {
            statusMessage = new String(body);
        } else if (response != null) {
            statusMessage = response.message();
        }
        Status status = (Status)this.serialization.unmarshal(statusMessage, Status.class);
        if (status.getCode() == null) {
            status = ((StatusBuilder)new StatusBuilder(status).withCode(Integer.valueOf(statusCode))).build();
        }
        return status;
    }

    protected byte[] extractBody(HttpRequest httpUriRequest) throws IOException {
        if (httpUriRequest instanceof HttpEntityEnclosingRequest) {
            HttpEntity entity = ((HttpEntityEnclosingRequest)httpUriRequest).getEntity();
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            entity.writeTo((OutputStream)buffer);
            return buffer.toByteArray();
        }
        return null;
    }

    public HttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest) {
        throw new UnsupportedOperationException();
    }

    public HttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler) {
        throw new UnsupportedOperationException();
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) {
        throw new UnsupportedOperationException();
    }
}

