/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.jmxadapter;

import java.io.IOException;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.RuntimeMBeanException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.jolokia.client.JolokiaClient;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.JolokiaQueryParameter;
import org.jolokia.client.exception.JolokiaBulkRemoteException;
import org.jolokia.client.exception.JolokiaException;
import org.jolokia.client.exception.JolokiaRemoteException;
import org.jolokia.client.exception.UncheckedJmxAdapterException;
import org.jolokia.client.jmxadapter.ToOpenTypeConverter;
import org.jolokia.client.request.HttpMethod;
import org.jolokia.client.request.JolokiaExecRequest;
import org.jolokia.client.request.JolokiaListRequest;
import org.jolokia.client.request.JolokiaReadRequest;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.client.request.JolokiaSearchRequest;
import org.jolokia.client.request.JolokiaVersionRequest;
import org.jolokia.client.request.JolokiaWriteRequest;
import org.jolokia.client.response.JolokiaExecResponse;
import org.jolokia.client.response.JolokiaListResponse;
import org.jolokia.client.response.JolokiaReadResponse;
import org.jolokia.client.response.JolokiaResponse;
import org.jolokia.client.response.JolokiaSearchResponse;
import org.jolokia.client.response.JolokiaVersionResponse;
import org.jolokia.json.JSONObject;
import org.jolokia.server.core.util.ClassUtil;
import org.jolokia.service.serializer.JolokiaSerializer;

public class RemoteJmxAdapter
implements MBeanServerConnection {
    String agentVersion;
    String protocolVersion;
    private String agentId;
    private final JolokiaClient connector;
    private HashMap<JolokiaQueryParameter, String> defaultProcessingOptions;
    protected final Map<ObjectName, MBeanInfo> mbeanInfoCache = new HashMap<ObjectName, MBeanInfo>();
    private static final Set<String> UNCHECKED_REMOTE_EXCEPTIONS = Collections.singleton("java.lang.UnsupportedOperationException");

    public RemoteJmxAdapter(String url) throws IOException {
        this(new JolokiaClientBuilder().url(url).build());
    }

    public RemoteJmxAdapter(JolokiaClient connector) throws IOException {
        this.connector = connector;
        try {
            JolokiaVersionResponse response = (JolokiaVersionResponse)this.unwrapExecute(new JolokiaVersionRequest());
            this.agentVersion = response.getAgentVersion();
            this.protocolVersion = response.getProtocolVersion();
            JSONObject value = (JSONObject)response.getValue();
            JSONObject config = (JSONObject)value.get((Object)"config");
            this.agentId = String.valueOf(config.get((Object)"agentId"));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    public int hashCode() {
        return this.connector.getUri().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof RemoteJmxAdapter && this.connector.getUri().equals(((RemoteJmxAdapter)o).connector.getUri());
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name) {
        throw new UnsupportedOperationException("createMBean not supported over Jolokia");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) {
        throw new UnsupportedOperationException("createMBean not supported over Jolokia");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("createMBean not supported over Jolokia");
    }

    @Override
    public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) {
        throw new UnsupportedOperationException("createMBean not supported over Jolokia");
    }

    @Override
    public void unregisterMBean(ObjectName name) {
        throw new UnsupportedOperationException("unregisterMBean not supported over Jolokia");
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
        JolokiaListResponse listResponse = (JolokiaListResponse)this.unwrapExecute(new JolokiaListRequest(name));
        return new ObjectInstance(name, listResponse.getClassName(name));
    }

    private List<ObjectInstance> listObjectInstances(ObjectName name) throws IOException {
        JolokiaListRequest listRequest = name == null ? new JolokiaListRequest((String)null) : new JolokiaListRequest(name);
        try {
            JolokiaListResponse listResponse = (JolokiaListResponse)this.unwrapExecute(listRequest);
            return listResponse.getObjectInstances(name);
        }
        catch (MalformedObjectNameException e) {
            throw new UncheckedJmxAdapterException((Exception)e);
        }
        catch (InstanceNotFoundException e) {
            return Collections.emptyList();
        }
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName name, QueryExp query) throws IOException {
        HashSet<ObjectInstance> result = new HashSet<ObjectInstance>();
        for (ObjectInstance instance : this.listObjectInstances(name)) {
            if (query != null && !this.applyQuery(query, instance.getObjectName())) continue;
            result.add(instance);
        }
        return result;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName name, QueryExp query) throws IOException {
        JolokiaSearchResponse response;
        HashSet<ObjectName> result = new HashSet<ObjectName>();
        if (name == null) {
            try {
                name = RemoteJmxAdapter.getObjectName("");
            }
            catch (UncheckedJmxAdapterException uncheckedJmxAdapterException) {
                // empty catch block
            }
        }
        JolokiaSearchRequest j4pSearchRequest = new JolokiaSearchRequest(name);
        try {
            response = (JolokiaSearchResponse)this.unwrapExecute(j4pSearchRequest);
        }
        catch (InstanceNotFoundException e) {
            return Collections.emptySet();
        }
        List names = response.getObjectNames();
        for (ObjectName objectName : names) {
            if (query != null && !this.applyQuery(query, objectName)) continue;
            result.add(objectName);
        }
        return result;
    }

    private boolean applyQuery(QueryExp query, ObjectName objectName) {
        if (QueryEval.getMBeanServer() == null) {
            query.setMBeanServer(this.createStandInMbeanServerProxyForQueryEvaluation());
        }
        try {
            return query.apply(objectName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UncheckedJmxAdapterException(e);
        }
    }

    private MBeanServer createStandInMbeanServerProxyForQueryEvaluation() {
        return (MBeanServer)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{MBeanServer.class}, (proxy, method, args) -> {
            if (method.getName().contains("getObjectInstance") && args.length == 1) {
                return this.getObjectInstance((ObjectName)args[0]);
            }
            throw new UnsupportedOperationException("This MBeanServer proxy does not support " + String.valueOf(method));
        });
    }

    private <RESP extends JolokiaResponse<REQ>, REQ extends JolokiaRequest> RESP unwrapExecute(REQ pRequest) throws IOException, InstanceNotFoundException {
        try {
            pRequest.setPreferredHttpMethod(HttpMethod.POST);
            return (RESP)this.connector.execute(pRequest, this.defaultProcessingOptions());
        }
        catch (JolokiaException e) {
            return (RESP)this.unwrapException(e);
        }
    }

    private Map<JolokiaQueryParameter, String> defaultProcessingOptions() {
        if (this.defaultProcessingOptions == null) {
            this.defaultProcessingOptions = new HashMap();
            this.defaultProcessingOptions.put(JolokiaQueryParameter.MAX_DEPTH, "10");
            this.defaultProcessingOptions.put(JolokiaQueryParameter.SERIALIZE_EXCEPTION, "true");
        }
        return this.defaultProcessingOptions;
    }

    protected JolokiaResponse unwrapException(JolokiaException e) throws IOException, InstanceNotFoundException {
        if (e.getCause() instanceof IOException) {
            throw (IOException)e.getCause();
        }
        if (e.getCause() instanceof RuntimeException) {
            throw (RuntimeException)e.getCause();
        }
        if (e.getCause() instanceof Error) {
            throw (Error)e.getCause();
        }
        if (e.getMessage().matches("Error: java.lang.IllegalArgumentException : No MBean '.+' found")) {
            throw new InstanceNotFoundException();
        }
        if (e instanceof JolokiaRemoteException && UNCHECKED_REMOTE_EXCEPTIONS.contains(((JolokiaRemoteException)e).getErrorType())) {
            throw new RuntimeMBeanException((RuntimeException)ClassUtil.newInstance((String)((JolokiaRemoteException)e).getErrorType(), (Object[])new Object[]{e.getMessage()}));
        }
        throw new UncheckedJmxAdapterException((Exception)((Object)e));
    }

    @Override
    public boolean isRegistered(ObjectName name) throws IOException {
        return !this.queryNames(name, null).isEmpty();
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        return this.queryNames(null, null).size();
    }

    @Override
    public Object getAttribute(ObjectName name, String attribute) throws AttributeNotFoundException, InstanceNotFoundException, IOException {
        try {
            Object rawValue = this.unwrapExecute(new JolokiaReadRequest(name, new String[]{attribute})).getValue();
            return this.adaptJsonToOptimalResponseValue(name, attribute, rawValue, this.getAttributeTypeFromMBeanInfo(name, attribute));
        }
        catch (UncheckedJmxAdapterException e) {
            if (e.getCause() instanceof JolokiaRemoteException && "javax.management.AttributeNotFoundException".equals(((JolokiaRemoteException)e.getCause()).getErrorType())) {
                throw new AttributeNotFoundException(e.getCause().getMessage());
            }
            throw e;
        }
        catch (UnsupportedOperationException e) {
            throw new AttributeNotFoundException();
        }
    }

    private Object adaptJsonToOptimalResponseValue(ObjectName name, String attribute, Object rawValue, String typeFromMBeanInfo) throws IOException, InstanceNotFoundException {
        String qualifiedName = String.valueOf(name) + "." + attribute;
        this.getMBeanInfo(name);
        if (this.isPrimitive(rawValue)) {
            OpenType<?> attributeType = null;
            try {
                attributeType = ToOpenTypeConverter.cachedType(qualifiedName);
            }
            catch (OpenDataException openDataException) {
                // empty catch block
            }
            if (rawValue instanceof Number && attributeType != null) {
                return new JolokiaSerializer().deserializeOpenType(attributeType, rawValue);
            }
            return rawValue;
        }
        if (rawValue instanceof JSONObject && ((JSONObject)rawValue).size() == 1 && ((JSONObject)rawValue).containsKey((Object)"objectName")) {
            return RemoteJmxAdapter.getObjectName(String.valueOf(((JSONObject)rawValue).get((Object)"objectName")));
        }
        try {
            return ToOpenTypeConverter.returnOpenTypedValue(qualifiedName, rawValue, typeFromMBeanInfo);
        }
        catch (OpenDataException e) {
            return rawValue;
        }
    }

    private boolean isPrimitive(Object rawValue) {
        return rawValue == null || rawValue instanceof Number || rawValue instanceof Boolean || rawValue instanceof String || rawValue instanceof Character;
    }

    static ObjectName getObjectName(String objectName) {
        try {
            return ObjectName.getInstance(objectName);
        }
        catch (MalformedObjectNameException e) {
            throw new UncheckedJmxAdapterException((Exception)e);
        }
    }

    @Override
    public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, IOException {
        AttributeList result = new AttributeList();
        ArrayList<JolokiaReadRequest> requests = new ArrayList<JolokiaReadRequest>(attributes.length);
        for (String attribute : attributes) {
            requests.add(new JolokiaReadRequest(name, new String[]{attribute}));
        }
        List responses = Collections.emptyList();
        try {
            responses = this.connector.execute(requests, this.defaultProcessingOptions());
        }
        catch (JolokiaBulkRemoteException e) {
            responses = e.getResults();
        }
        catch (JolokiaException jolokiaException) {
            // empty catch block
        }
        for (Object item : responses) {
            if (!(item instanceof JolokiaReadResponse)) continue;
            JolokiaReadResponse value = (JolokiaReadResponse)item;
            String attribute = ((JolokiaReadRequest)value.getRequest()).getAttribute();
            result.add(new Attribute(attribute, this.adaptJsonToOptimalResponseValue(name, attribute, value.getValue(), this.getAttributeTypeFromMBeanInfo(name, attribute))));
        }
        return result;
    }

    @Override
    public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, IOException {
        JolokiaWriteRequest request = new JolokiaWriteRequest(name, attribute.getName(), attribute.getValue());
        try {
            this.unwrapExecute(request);
        }
        catch (UncheckedJmxAdapterException e) {
            if (e.getCause() instanceof JolokiaRemoteException) {
                JolokiaRemoteException remote = (JolokiaRemoteException)e.getCause();
                if ("javax.management.AttributeNotFoundException".equals(remote.getErrorType())) {
                    throw new AttributeNotFoundException(e.getCause().getMessage());
                }
                if ("java.lang.IllegalArgumentException".equals(remote.getErrorType()) && remote.getMessage().matches("Error: java.lang.IllegalArgumentException : Invalid value .+ for attribute .+")) {
                    throw new InvalidAttributeValueException(remote.getMessage());
                }
            }
            throw e;
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, IOException {
        ArrayList<JolokiaWriteRequest> attributeWrites = new ArrayList<JolokiaWriteRequest>(attributes.size());
        for (Attribute attribute : attributes.asList()) {
            attributeWrites.add(new JolokiaWriteRequest(name, attribute.getName(), attribute.getValue()));
        }
        try {
            this.connector.execute(attributeWrites);
        }
        catch (JolokiaException e) {
            this.unwrapException(e);
        }
        return attributes;
    }

    @Override
    public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, IOException {
        if (params == null && (signature == null || signature.length == 0)) {
            params = new Object[]{};
        }
        try {
            JolokiaExecResponse response = (JolokiaExecResponse)this.unwrapExecute(new JolokiaExecRequest(name, operationName + this.makeSignature(signature), params));
            return this.adaptJsonToOptimalResponseValue(name, operationName, response.getValue(), this.getOperationTypeFromMBeanInfo(name, operationName, signature));
        }
        catch (UncheckedJmxAdapterException e) {
            if (e.getCause() instanceof JolokiaRemoteException) {
                throw new MBeanException((Exception)e.getCause());
            }
            throw e;
        }
    }

    private String getOperationTypeFromMBeanInfo(ObjectName name, String operationName, String[] signature) throws IOException, InstanceNotFoundException {
        MBeanInfo mBeanInfo = this.getMBeanInfo(name);
        if (signature == null) {
            signature = new String[]{};
        }
        for (MBeanOperationInfo operation : mBeanInfo.getOperations()) {
            if (!operationName.equals(operation.getName()) || !Arrays.equals(Arrays.stream(operation.getSignature()).map(MBeanParameterInfo::getType).toArray(String[]::new), signature)) continue;
            return operation.getReturnType();
        }
        return null;
    }

    private String makeSignature(String[] signature) {
        StringBuilder builder = new StringBuilder("(");
        if (signature != null) {
            for (int i = 0; i < signature.length; ++i) {
                if (i > 0) {
                    builder.append(',');
                }
                builder.append(signature[i]);
            }
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public String getDefaultDomain() {
        return "DefaultDomain";
    }

    @Override
    public String[] getDomains() throws IOException {
        HashSet<String> domains = new HashSet<String>();
        for (ObjectName name : this.queryNames(null, null)) {
            domains.add(name.getDomain());
        }
        return domains.toArray(new String[0]);
    }

    @Override
    public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        if (!(this.isRunningInJConsole() || this.isRunningInJVisualVm() || this.isRunningInJmc())) {
            throw new UnsupportedOperationException("addNotificationListener not supported for Jolokia");
        }
    }

    @Override
    public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException("addNotificationListener not supported for Jolokia");
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener) {
        throw new UnsupportedOperationException("removeNotificationListener not supported for Jolokia");
    }

    @Override
    public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException("removeNotificationListener not supported by Jolokia");
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener) {
        if (!(this.isRunningInJmc() || this.isRunningInJConsole() || this.isRunningInJVisualVm())) {
            throw new UnsupportedOperationException("removeNotificationListener not supported by Jolokia");
        }
    }

    @Override
    public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) {
        throw new UnsupportedOperationException("removeNotificationListener not supported by Jolokia");
    }

    private boolean isRunningInJVisualVm() {
        String version = System.getProperty("netbeans.productversion");
        return version != null && version.contains("VisualVM");
    }

    private boolean isRunningInJConsole() {
        return System.getProperty("jconsole.showOutputViewer") != null;
    }

    private boolean isRunningInJmc() {
        return System.getProperty("running.in.jmc") != null;
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IOException {
        MBeanInfo result = this.mbeanInfoCache.get(name);
        if (result == null) {
            JolokiaListResponse response = (JolokiaListResponse)this.unwrapExecute(new JolokiaListRequest(name));
            result = response.getMbeanInfo(name);
            this.mbeanInfoCache.put(name, result);
            for (MBeanAttributeInfo attr : result.getAttributes()) {
                String qualifiedName = String.valueOf(name) + "." + attr.getName();
                try {
                    if (ToOpenTypeConverter.cachedType(qualifiedName) != null) continue;
                    ToOpenTypeConverter.cacheType(ToOpenTypeConverter.typeFor(attr.getType()), qualifiedName);
                }
                catch (InvalidOpenTypeException | OpenDataException exception) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private String getAttributeTypeFromMBeanInfo(ObjectName name, String attributeName) throws IOException, InstanceNotFoundException {
        MBeanInfo mBeanInfo = this.getMBeanInfo(name);
        for (MBeanAttributeInfo attribute : mBeanInfo.getAttributes()) {
            if (!attributeName.equals(attribute.getName())) continue;
            return attribute.getType();
        }
        return null;
    }

    @Override
    public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
        ObjectInstance objectInstance = this.getObjectInstance(name);
        try {
            return Class.forName(className).isAssignableFrom(Class.forName(objectInstance.getClassName()));
        }
        catch (ClassNotFoundException e) {
            if (className.equals(objectInstance.getClassName())) {
                return true;
            }
            try {
                if (ToOpenTypeConverter.cachedType(name.toString()) != null) {
                    return ToOpenTypeConverter.cachedType(name.toString()).getTypeName().equals(className);
                }
            }
            catch (OpenDataException openDataException) {
                // empty catch block
            }
            return false;
        }
    }

    String getId() {
        return this.agentId;
    }
}

