/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.jmxadapter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import javax.security.auth.Subject;
import org.jolokia.client.JolokiaClientBuilder;
import org.jolokia.client.jmxadapter.RemoteJmxAdapter;

public class JolokiaJmxConnector
implements JMXConnector {
    protected final JMXServiceURL serviceUrl;
    private final Map<String, ?> environment;
    protected RemoteJmxAdapter adapter;
    private final NotificationBroadcasterSupport broadcasterSupport = new NotificationBroadcasterSupport();
    private long clientNotifSeqNo = 1L;
    private String connectionId;

    public JolokiaJmxConnector(JMXServiceURL serviceURL, Map<String, ?> environment) {
        this.serviceUrl = serviceURL;
        this.environment = environment;
    }

    @Override
    public void connect() throws IOException {
        this.connect(Collections.emptyMap());
    }

    private String prefixWithSlashIfNone(String urlPath) {
        if (urlPath.startsWith("/")) {
            return urlPath;
        }
        return "/" + urlPath;
    }

    @Override
    public void connect(Map<String, ?> env) throws IOException {
        if (!"jolokia".equals(this.serviceUrl.getProtocol())) {
            throw new MalformedURLException(String.format("Invalid URL %s : Only protocol \"jolokia\" is supported (not %s)", this.serviceUrl, this.serviceUrl.getProtocol()));
        }
        Map<String, Object> mergedEnv = this.mergedEnvironment(env);
        String internalProtocol = this.getJolokiaProtocol(mergedEnv);
        JolokiaClientBuilder clientBuilder = new JolokiaClientBuilder().url(internalProtocol + "://" + this.serviceUrl.getHost() + ":" + this.serviceUrl.getPort() + this.prefixWithSlashIfNone(this.serviceUrl.getURLPath()));
        if (mergedEnv.containsKey("jmx.remote.credentials")) {
            String[] credentials = (String[])mergedEnv.get("jmx.remote.credentials");
            clientBuilder.user(credentials[0]);
            clientBuilder.password(credentials[1]);
        }
        this.adapter = this.instantiateAdapter(clientBuilder, mergedEnv);
        this.postCreateAdapter();
    }

    public String getJolokiaProtocol(Map<String, Object> env) {
        String protocol = "http";
        if (String.valueOf(this.serviceUrl.getPort()).endsWith("443") || "true".equals(env.get("jmx.remote.x.check.stub"))) {
            protocol = "https";
        }
        return protocol;
    }

    protected void postCreateAdapter() {
        this.connectionId = this.adapter.getId();
        this.broadcasterSupport.sendNotification(new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifSeqNo++, "Successful connection", null));
    }

    protected Map<String, Object> mergedEnvironment(Map<String, ?> env) {
        HashMap<String, Object> mergedEnv = new HashMap<String, Object>();
        if (this.environment != null) {
            mergedEnv.putAll(this.environment);
        }
        if (env != null) {
            mergedEnv.putAll(env);
        }
        return mergedEnv;
    }

    protected RemoteJmxAdapter instantiateAdapter(JolokiaClientBuilder clientBuilder, Map<String, Object> ignoredMergedEnv) throws IOException {
        return new RemoteJmxAdapter(clientBuilder.build());
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() {
        return this.adapter;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) {
        throw new UnsupportedOperationException("Jolokia currently do not support connections using a subject, if you have a use case, raise an issue in Jolokias github repo");
    }

    @Override
    public void close() {
        this.broadcasterSupport.sendNotification(new JMXConnectionNotification("jmx.remote.connection.closed", this, this.connectionId, this.clientNotifSeqNo++, "Client has been closed", null));
        this.adapter = null;
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        this.broadcasterSupport.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(listener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener l, NotificationFilter f, Object handback) throws ListenerNotFoundException {
        this.broadcasterSupport.removeNotificationListener(l, f, handback);
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }
}

