/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.client.request;

import java.util.ArrayList;
import java.util.List;
import javax.management.ObjectName;
import org.jolokia.client.EscapeUtil;
import org.jolokia.client.JolokiaOperation;
import org.jolokia.client.JolokiaTargetConfig;
import org.jolokia.client.request.JolokiaRequest;
import org.jolokia.client.response.JolokiaListResponse;
import org.jolokia.json.JSONObject;

public class JolokiaListRequest
extends JolokiaRequest {
    private final List<String> pathElements;

    protected JolokiaListRequest() {
        this(null, (String)null);
    }

    protected JolokiaListRequest(JolokiaTargetConfig pTargetConfig) {
        this(pTargetConfig, (String)null);
    }

    public JolokiaListRequest(String pPath) {
        this(null, pPath);
    }

    public JolokiaListRequest(JolokiaTargetConfig pConfig, String pPath) {
        super(JolokiaOperation.LIST, pConfig);
        this.pathElements = EscapeUtil.splitPath(pPath);
    }

    public JolokiaListRequest(List<String> pPathElements) {
        this(null, pPathElements);
    }

    public JolokiaListRequest(JolokiaTargetConfig pConfig, List<String> pPathElements) {
        super(JolokiaOperation.LIST, pConfig);
        this.pathElements = new ArrayList<String>(pPathElements);
    }

    public JolokiaListRequest(ObjectName pObjectName) {
        this(null, pObjectName);
    }

    public JolokiaListRequest(JolokiaTargetConfig pConfig, ObjectName pObjectName) {
        super(JolokiaOperation.LIST, pConfig);
        this.pathElements = new ArrayList<String>();
        this.pathElements.add(pObjectName.getDomain());
        this.pathElements.add(pObjectName.getCanonicalKeyPropertyListString());
    }

    public JolokiaListResponse createResponse(JSONObject pResponse) {
        return new JolokiaListResponse(this, pResponse);
    }

    @Override
    public List<String> getRequestParts() {
        return this.pathElements;
    }

    @Override
    public JSONObject toJson() {
        JSONObject ret = super.toJson();
        String pathToUse = EscapeUtil.combinePath(this.pathElements);
        if (pathToUse != null) {
            ret.put((Object)"path", (Object)pathToUse);
        }
        return ret;
    }
}

